/*
 * Decompiled with CFR 0.152.
 */
package sun.print;

import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Vector;
import javax.print.CancelablePrintJob;
import javax.print.Doc;
import javax.print.DocFlavor;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.attribute.Attribute;
import javax.print.attribute.AttributeSetUtilities;
import javax.print.attribute.DocAttributeSet;
import javax.print.attribute.HashPrintJobAttributeSet;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintJobAttribute;
import javax.print.attribute.PrintJobAttributeSet;
import javax.print.attribute.PrintRequestAttribute;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.TextSyntax;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.Destination;
import javax.print.attribute.standard.DocumentName;
import javax.print.attribute.standard.Fidelity;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.JobOriginatingUserName;
import javax.print.attribute.standard.JobSheets;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.OrientationRequested;
import javax.print.attribute.standard.RequestingUserName;
import javax.print.event.PrintJobAttributeListener;
import javax.print.event.PrintJobEvent;
import javax.print.event.PrintJobListener;
import sun.print.ImagePrinter;
import sun.print.PSPrinterJob;
import sun.print.PrintJobAttributeException;
import sun.print.PrintJobFlavorException;
import sun.print.UnixPrintService;
import sun.print.UnixPrintServiceLookup;

public class UnixPrintJob
implements CancelablePrintJob {
    private transient Vector jobListeners;
    private transient Vector attrListeners;
    private transient Vector listenedAttributeSets;
    private UnixPrintService service;
    private boolean fidelity;
    private boolean printing = false;
    private boolean printReturned = false;
    private PrintRequestAttributeSet reqAttrSet = null;
    private PrintJobAttributeSet jobAttrSet = null;
    private PrinterJob job;
    private Doc doc;
    private InputStream instream = null;
    private Reader reader = null;
    private String jobName = "Java Printing";
    private int copies = 1;
    private MediaSizeName mediaName = MediaSizeName.NA_LETTER;
    private MediaSize mediaSize = MediaSize.NA.LETTER;
    private OrientationRequested orient = OrientationRequested.PORTRAIT;
    private static int DESTPRINTER = 1;
    private static int DESTFILE = 2;
    private int mDestType = DESTPRINTER;
    private File spoolFile;
    private String mDestination;
    private String mOptions;
    private boolean mNoJobSheet = false;
    static Class class$javax$print$attribute$standard$RequestingUserName;
    static Class class$javax$print$attribute$standard$JobName;
    static Class class$javax$print$attribute$standard$DocumentName;
    static Class class$javax$print$attribute$standard$Fidelity;
    static Class class$javax$print$attribute$standard$Destination;
    static Class class$javax$print$attribute$standard$JobSheets;
    static Class class$javax$print$attribute$standard$Copies;
    static Class class$javax$print$attribute$standard$Media;
    static Class class$javax$print$attribute$standard$OrientationRequested;

    static int access$300() {
        return DESTFILE;
    }

    public void cancel() throws PrintException {
        UnixPrintJob unixPrintJob = this;
        synchronized (unixPrintJob) {
            if (!this.printing) {
                throw new PrintException("Job is not yet submitted.");
            }
            if (this.job != null && !this.printReturned) {
                this.job.cancel();
                this.notifyEvent(101);
                return;
            }
            throw new PrintException("Job could not be cancelled.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeDataStreams() {
        if (this.doc == null) {
            return;
        }
        Object object = null;
        try {
            object = this.doc.getPrintData();
        }
        catch (IOException iOException) {
            return;
        }
        if (this.instream != null) {
            try {
                this.instream.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.instream = null;
            }
        } else if (this.reader != null) {
            try {
                this.reader.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.reader = null;
            }
        } else if (object instanceof InputStream) {
            try {
                ((InputStream)object).close();
            }
            catch (IOException iOException) {}
        } else if (object instanceof Reader) {
            try {
                ((Reader)object).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyEvent(int n2) {
        switch (n2) {
            case 101: 
            case 102: 
            case 103: 
            case 105: 
            case 106: {
                this.closeDataStreams();
            }
        }
        UnixPrintJob unixPrintJob = this;
        synchronized (unixPrintJob) {
            if (this.jobListeners != null) {
                PrintJobEvent printJobEvent = new PrintJobEvent(this, n2);
                block12: for (int i2 = 0; i2 < this.jobListeners.size(); ++i2) {
                    PrintJobListener printJobListener = (PrintJobListener)this.jobListeners.elementAt(i2);
                    switch (n2) {
                        case 101: {
                            printJobListener.printJobCanceled(printJobEvent);
                            continue block12;
                        }
                        case 103: {
                            printJobListener.printJobFailed(printJobEvent);
                            continue block12;
                        }
                        case 106: {
                            printJobListener.printDataTransferCompleted(printJobEvent);
                            continue block12;
                        }
                        case 105: {
                            printJobListener.printJobNoMoreEvents(printJobEvent);
                            continue block12;
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pageableJob(Pageable pageable) throws PrintException {
        try {
            UnixPrintJob unixPrintJob = this;
            synchronized (unixPrintJob) {
                if (this.job != null) {
                    throw new PrintException("already printing");
                }
                this.job = new PSPrinterJob();
            }
            this.job.setPrintService(this.getPrintService());
            this.job.setCopies(this.copies);
            this.job.setJobName(this.jobName);
            this.job.setPageable(pageable);
            this.job.print(this.reqAttrSet);
            this.notifyEvent(106);
            return;
        }
        catch (PrinterException printerException) {
            this.notifyEvent(103);
            throw new PrintException(printerException);
        }
        finally {
            this.printReturned = true;
            this.notifyEvent(105);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printableJob(Printable printable) throws PrintException {
        try {
            Object object = this;
            synchronized (object) {
                if (this.job != null) {
                    throw new PrintException("already printing");
                }
                this.job = new PSPrinterJob();
            }
            this.job.setPrintService(this.getPrintService());
            this.job.setCopies(this.copies);
            this.job.setJobName(this.jobName);
            object = new PageFormat();
            if (this.mediaSize != null) {
                Paper paper = new Paper();
                paper.setSize((double)this.mediaSize.getX(25400) * 72.0, (double)this.mediaSize.getY(25400) * 72.0);
                paper.setImageableArea(72.0, 72.0, paper.getWidth() - 144.0, paper.getHeight() - 144.0);
                ((PageFormat)object).setPaper(paper);
            }
            if (this.orient == OrientationRequested.REVERSE_LANDSCAPE) {
                ((PageFormat)object).setOrientation(2);
            } else if (this.orient == OrientationRequested.LANDSCAPE) {
                ((PageFormat)object).setOrientation(0);
            }
            this.job.setPrintable(printable, (PageFormat)object);
            this.job.print(this.reqAttrSet);
            this.notifyEvent(106);
            return;
        }
        catch (PrinterException printerException) {
            this.notifyEvent(103);
            throw new PrintException(printerException);
        }
        finally {
            this.printReturned = true;
            this.notifyEvent(105);
        }
    }

    private void getAttributeValues(DocFlavor docFlavor) throws PrintException {
        this.fidelity = this.reqAttrSet.get(class$javax$print$attribute$standard$Fidelity == null ? (class$javax$print$attribute$standard$Fidelity = UnixPrintJob.class$("javax.print.attribute.standard.Fidelity")) : class$javax$print$attribute$standard$Fidelity) == Fidelity.FIDELITY_TRUE;
        Attribute[] attributeArray = this.reqAttrSet.toArray();
        for (int i2 = 0; i2 < attributeArray.length; ++i2) {
            Attribute attribute = attributeArray[i2];
            Class clazz = attribute.getCategory();
            if (this.fidelity) {
                if (!this.service.isAttributeCategorySupported(clazz)) {
                    this.notifyEvent(103);
                    throw new PrintJobAttributeException("unsupported category: " + clazz, clazz, null);
                }
                if (!this.service.isAttributeValueSupported(attribute, docFlavor, null)) {
                    this.notifyEvent(103);
                    throw new PrintJobAttributeException("unsupported attribute: " + attribute, null, attribute);
                }
            }
            if (clazz == (class$javax$print$attribute$standard$Destination == null ? UnixPrintJob.class$("javax.print.attribute.standard.Destination") : class$javax$print$attribute$standard$Destination)) {
                URI uRI = ((Destination)attribute).getURI();
                if (!"file".equals(uRI.getScheme())) {
                    this.notifyEvent(103);
                    throw new PrintException("Not a file: URI");
                }
                try {
                    this.mDestType = DESTFILE;
                    this.mDestination = new File(uRI).getPath();
                }
                catch (Exception exception) {
                    throw new PrintException(exception);
                }
                SecurityManager securityManager = System.getSecurityManager();
                if (securityManager == null) continue;
                try {
                    securityManager.checkWrite(this.mDestination);
                    continue;
                }
                catch (SecurityException securityException) {
                    this.notifyEvent(103);
                    throw new PrintException(securityException);
                }
            }
            if (clazz == (class$javax$print$attribute$standard$JobSheets == null ? UnixPrintJob.class$("javax.print.attribute.standard.JobSheets") : class$javax$print$attribute$standard$JobSheets)) {
                if ((JobSheets)attribute != JobSheets.NONE) continue;
                this.mNoJobSheet = true;
                continue;
            }
            if (clazz == (class$javax$print$attribute$standard$JobName == null ? UnixPrintJob.class$("javax.print.attribute.standard.JobName") : class$javax$print$attribute$standard$JobName)) {
                this.jobName = ((JobName)attribute).getValue();
                continue;
            }
            if (clazz == (class$javax$print$attribute$standard$Copies == null ? UnixPrintJob.class$("javax.print.attribute.standard.Copies") : class$javax$print$attribute$standard$Copies)) {
                this.copies = ((Copies)attribute).getValue();
                continue;
            }
            if (clazz == (class$javax$print$attribute$standard$Media == null ? UnixPrintJob.class$("javax.print.attribute.standard.Media") : class$javax$print$attribute$standard$Media)) {
                if (!(attribute instanceof MediaSizeName)) continue;
                this.mediaName = (MediaSizeName)attribute;
                if (this.service.isAttributeValueSupported(attribute, null, null)) continue;
                this.mediaSize = MediaSize.getMediaSizeForName(this.mediaName);
                continue;
            }
            if (clazz != (class$javax$print$attribute$standard$OrientationRequested == null ? UnixPrintJob.class$("javax.print.attribute.standard.OrientationRequested") : class$javax$print$attribute$standard$OrientationRequested)) continue;
            this.orient = (OrientationRequested)attribute;
        }
    }

    public PrintService getPrintService() {
        return this.service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PrintJobAttributeSet getAttributes() {
        UnixPrintJob unixPrintJob = this;
        synchronized (unixPrintJob) {
            if (this.jobAttrSet == null) {
                HashPrintJobAttributeSet hashPrintJobAttributeSet = new HashPrintJobAttributeSet();
                return AttributeSetUtilities.unmodifiableView(hashPrintJobAttributeSet);
            }
            return this.jobAttrSet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePrintJobAttributeListener(PrintJobAttributeListener printJobAttributeListener) {
        UnixPrintJob unixPrintJob = this;
        synchronized (unixPrintJob) {
            if (printJobAttributeListener == null || this.attrListeners == null) {
                return;
            }
            int n2 = this.attrListeners.indexOf(printJobAttributeListener);
            if (n2 == -1) {
                return;
            }
            this.attrListeners.remove(n2);
            this.listenedAttributeSets.remove(n2);
            if (this.attrListeners.isEmpty()) {
                this.attrListeners = null;
                this.listenedAttributeSets = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPrintJobListener(PrintJobListener printJobListener) {
        UnixPrintJob unixPrintJob = this;
        synchronized (unixPrintJob) {
            if (printJobListener == null) {
                return;
            }
            if (this.jobListeners == null) {
                this.jobListeners = new Vector();
            }
            this.jobListeners.add(printJobListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePrintJobListener(PrintJobListener printJobListener) {
        UnixPrintJob unixPrintJob = this;
        synchronized (unixPrintJob) {
            if (printJobListener == null || this.jobListeners == null) {
                return;
            }
            this.jobListeners.remove(printJobListener);
            if (this.jobListeners.isEmpty()) {
                this.jobListeners = null;
            }
        }
    }

    static int access$1000(UnixPrintJob unixPrintJob) {
        return unixPrintJob.copies;
    }

    static int access$200(UnixPrintJob unixPrintJob) {
        return unixPrintJob.mDestType;
    }

    static boolean access$800(UnixPrintJob unixPrintJob) {
        return unixPrintJob.mNoJobSheet;
    }

    static void access$600(UnixPrintJob unixPrintJob, int n2) {
        unixPrintJob.notifyEvent(n2);
    }

    UnixPrintJob(UnixPrintService unixPrintService) {
        this.service = unixPrintService;
        this.mDestination = unixPrintService.getName();
        this.mDestType = DESTPRINTER;
    }

    static File access$400(UnixPrintJob unixPrintJob) {
        return unixPrintJob.spoolFile;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    static String access$500(UnixPrintJob unixPrintJob) {
        return unixPrintJob.mDestination;
    }

    static String access$700(UnixPrintJob unixPrintJob) {
        return unixPrintJob.mOptions;
    }

    static String access$900(UnixPrintJob unixPrintJob) {
        return unixPrintJob.jobName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPrintJobAttributeListener(PrintJobAttributeListener printJobAttributeListener, PrintJobAttributeSet printJobAttributeSet) {
        UnixPrintJob unixPrintJob = this;
        synchronized (unixPrintJob) {
            if (printJobAttributeListener == null) {
                return;
            }
            if (this.attrListeners == null) {
                this.attrListeners = new Vector();
                this.listenedAttributeSets = new Vector();
            }
            this.attrListeners.add(printJobAttributeListener);
            if (printJobAttributeSet == null) {
                printJobAttributeSet = new HashPrintJobAttributeSet();
            }
            this.listenedAttributeSets.add(printJobAttributeSet);
        }
    }

    private synchronized void initializeAttributeSets(Doc doc, PrintRequestAttributeSet printRequestAttributeSet) {
        TextSyntax textSyntax;
        DocAttributeSet docAttributeSet;
        Attribute[] attributeArray;
        this.reqAttrSet = new HashPrintRequestAttributeSet();
        this.jobAttrSet = new HashPrintJobAttributeSet();
        if (printRequestAttributeSet != null) {
            this.reqAttrSet.addAll(printRequestAttributeSet);
            attributeArray = printRequestAttributeSet.toArray();
            for (int i2 = 0; i2 < attributeArray.length; ++i2) {
                if (!(attributeArray[i2] instanceof PrintJobAttribute)) continue;
                this.jobAttrSet.add(attributeArray[i2]);
            }
        }
        if ((docAttributeSet = doc.getAttributes()) != null) {
            attributeArray = docAttributeSet.toArray();
            for (int i3 = 0; i3 < attributeArray.length; ++i3) {
                if (attributeArray[i3] instanceof PrintRequestAttribute) {
                    this.reqAttrSet.add(attributeArray[i3]);
                }
                if (!(attributeArray[i3] instanceof PrintJobAttribute)) continue;
                this.jobAttrSet.add(attributeArray[i3]);
            }
        }
        String string = "";
        try {
            string = System.getProperty("user.name");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (string == null || string.equals("")) {
            textSyntax = (RequestingUserName)printRequestAttributeSet.get(class$javax$print$attribute$standard$RequestingUserName == null ? (class$javax$print$attribute$standard$RequestingUserName = UnixPrintJob.class$("javax.print.attribute.standard.RequestingUserName")) : class$javax$print$attribute$standard$RequestingUserName);
            if (textSyntax != null) {
                this.jobAttrSet.add(new JobOriginatingUserName(textSyntax.getValue(), textSyntax.getLocale()));
            } else {
                this.jobAttrSet.add(new JobOriginatingUserName("", null));
            }
        } else {
            this.jobAttrSet.add(new JobOriginatingUserName(string, null));
        }
        if (this.jobAttrSet.get(class$javax$print$attribute$standard$JobName == null ? (class$javax$print$attribute$standard$JobName = UnixPrintJob.class$("javax.print.attribute.standard.JobName")) : class$javax$print$attribute$standard$JobName) == null) {
            if (docAttributeSet != null && docAttributeSet.get(class$javax$print$attribute$standard$DocumentName == null ? (class$javax$print$attribute$standard$DocumentName = UnixPrintJob.class$("javax.print.attribute.standard.DocumentName")) : class$javax$print$attribute$standard$DocumentName) != null) {
                DocumentName documentName = (DocumentName)docAttributeSet.get(class$javax$print$attribute$standard$DocumentName == null ? (class$javax$print$attribute$standard$DocumentName = UnixPrintJob.class$("javax.print.attribute.standard.DocumentName")) : class$javax$print$attribute$standard$DocumentName);
                textSyntax = new JobName(documentName.getValue(), documentName.getLocale());
                this.jobAttrSet.add((Attribute)((Object)textSyntax));
            } else {
                String string2 = "JPS Job:" + doc;
                try {
                    Object object = doc.getPrintData();
                    if (object instanceof URL) {
                        string2 = ((URL)doc.getPrintData()).toString();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                textSyntax = new JobName(string2, null);
                this.jobAttrSet.add((Attribute)((Object)textSyntax));
            }
        }
        this.jobAttrSet = AttributeSetUtilities.unmodifiableView(this.jobAttrSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void print(Doc doc, PrintRequestAttributeSet printRequestAttributeSet) throws PrintException {
        Object object;
        block56: {
            OutputStream iOException3;
            block55: {
                Object iOException;
                String string;
                Object object3;
                block54: {
                    Object object2;
                    object3 = this;
                    synchronized (object3) {
                        if (this.printing) {
                            throw new PrintException("already printing");
                        }
                        this.printing = true;
                    }
                    this.doc = doc;
                    object3 = doc.getDocFlavor();
                    try {
                        object2 = doc.getPrintData();
                    }
                    catch (IOException iOException2) {
                        this.notifyEvent(103);
                        throw new PrintException("can't get print data: " + iOException2.toString());
                    }
                    if (object3 == null || !this.service.isDocFlavorSupported((DocFlavor)object3)) {
                        this.notifyEvent(103);
                        throw new PrintJobFlavorException("invalid flavor", (DocFlavor)object3);
                    }
                    this.initializeAttributeSets(doc, printRequestAttributeSet);
                    this.getAttributeValues((DocFlavor)object3);
                    String iOException4 = ((DocFlavor)object3).getRepresentationClassName();
                    String string2 = ((DocFlavor)object3).getParameter("charset");
                    string = "us-ascii";
                    if (string2 != null && !string2.equals("")) {
                        string = string2;
                    }
                    if (((DocFlavor)object3).equals(DocFlavor.INPUT_STREAM.GIF) || ((DocFlavor)object3).equals(DocFlavor.INPUT_STREAM.JPEG) || ((DocFlavor)object3).equals(DocFlavor.INPUT_STREAM.PNG) || ((DocFlavor)object3).equals(DocFlavor.BYTE_ARRAY.GIF) || ((DocFlavor)object3).equals(DocFlavor.BYTE_ARRAY.JPEG) || ((DocFlavor)object3).equals(DocFlavor.BYTE_ARRAY.PNG)) {
                        try {
                            this.instream = doc.getStreamForBytes();
                            this.printableJob(new ImagePrinter(this.instream));
                            this.service.wakeNotifier();
                            return;
                        }
                        catch (ClassCastException classCastException) {
                            this.notifyEvent(103);
                            throw new PrintException(classCastException);
                        }
                        catch (IOException classCastException) {
                            this.notifyEvent(103);
                            throw new PrintException(classCastException);
                        }
                    }
                    if (((DocFlavor)object3).equals(DocFlavor.URL.GIF) || ((DocFlavor)object3).equals(DocFlavor.URL.JPEG) || ((DocFlavor)object3).equals(DocFlavor.URL.PNG)) {
                        try {
                            this.printableJob(new ImagePrinter((URL)object2));
                            this.service.wakeNotifier();
                            return;
                        }
                        catch (ClassCastException iOException5) {
                            this.notifyEvent(103);
                            throw new PrintException(iOException5);
                        }
                    }
                    if (((DocFlavor)object3).equals(DocFlavor.CHAR_ARRAY.TEXT_PLAIN) || ((DocFlavor)object3).equals(DocFlavor.READER.TEXT_PLAIN) || ((DocFlavor)object3).equals(DocFlavor.STRING.TEXT_PLAIN)) {
                        try {
                            this.reader = doc.getReaderForText();
                            if (this.reader == null) {
                                this.notifyEvent(103);
                                throw new PrintException("No reader for data");
                            }
                            break block54;
                        }
                        catch (IOException classCastException) {
                            this.notifyEvent(103);
                            throw new PrintException(classCastException.toString());
                        }
                    }
                    if (iOException4.equals("[B") || iOException4.equals("java.io.InputStream")) {
                        try {
                            this.instream = doc.getStreamForBytes();
                            if (this.instream == null) {
                                this.notifyEvent(103);
                                throw new PrintException("No stream for data");
                            }
                            break block54;
                        }
                        catch (IOException iOException6) {
                            this.notifyEvent(103);
                            throw new PrintException(iOException6.toString());
                        }
                    }
                    if (((DocFlavor)object3).equals(DocFlavor.URL.AUTOSENSE) || ((DocFlavor)object3).equals(DocFlavor.URL.POSTSCRIPT) || ((DocFlavor)object3).equals(DocFlavor.URL.TEXT_PLAIN_HOST) || ((DocFlavor)object3).equals(DocFlavor.URL.TEXT_PLAIN_UTF_8) || ((DocFlavor)object3).equals(DocFlavor.URL.TEXT_PLAIN_UTF_16) || ((DocFlavor)object3).equals(DocFlavor.URL.TEXT_PLAIN_UTF_16BE) || ((DocFlavor)object3).equals(DocFlavor.URL.TEXT_PLAIN_UTF_16LE) || ((DocFlavor)object3).equals(DocFlavor.URL.TEXT_PLAIN_US_ASCII)) {
                        iOException = (URL)object2;
                        try {
                            this.instream = ((URL)iOException).openStream();
                        }
                        catch (IOException iOException7) {
                            this.notifyEvent(103);
                            throw new PrintException(iOException7.toString());
                        }
                    } else {
                        if (iOException4.equals("java.awt.print.Pageable")) {
                            try {
                                this.pageableJob((Pageable)doc.getPrintData());
                                this.service.wakeNotifier();
                                return;
                            }
                            catch (ClassCastException object22) {
                                this.notifyEvent(103);
                                throw new PrintException(object22);
                            }
                            catch (IOException classCastException) {
                                this.notifyEvent(103);
                                throw new PrintException(classCastException);
                            }
                        }
                        if (!iOException4.equals("java.awt.print.Printable")) {
                            this.notifyEvent(103);
                            throw new PrintException("unrecognized class: " + iOException4);
                        }
                        try {
                            this.printableJob((Printable)doc.getPrintData());
                            this.service.wakeNotifier();
                            return;
                        }
                        catch (ClassCastException iOException2) {
                            this.notifyEvent(103);
                            throw new PrintException(iOException2);
                        }
                        catch (IOException classCastException) {
                            this.notifyEvent(103);
                            throw new PrintException(classCastException);
                        }
                    }
                }
                iOException = new PrinterOpener(this, null);
                AccessController.doPrivileged((PrivilegedAction)iOException);
                if (((PrinterOpener)iOException).pex != null) {
                    throw ((PrinterOpener)iOException).pex;
                }
                iOException3 = ((PrinterOpener)iOException).result;
                BufferedWriter bufferedWriter = null;
                if (this.instream == null && this.reader != null) {
                    object = new BufferedReader(this.reader);
                    OutputStreamWriter outputStreamWriter = new OutputStreamWriter(iOException3);
                    bufferedWriter = new BufferedWriter(outputStreamWriter);
                    char[] cArray = new char[1024];
                    try {
                        int n2;
                        while ((n2 = ((BufferedReader)object).read(cArray, 0, cArray.length)) >= 0) {
                            bufferedWriter.write(cArray, 0, n2);
                        }
                        ((BufferedReader)object).close();
                        bufferedWriter.flush();
                        bufferedWriter.close();
                    }
                    catch (IOException iOException8) {
                        this.notifyEvent(103);
                        throw new PrintException(iOException8);
                    }
                }
                if (this.instream == null || !((DocFlavor)object3).getMediaType().equalsIgnoreCase("text")) break block55;
                try {
                    try {
                        object = new InputStreamReader(this.instream, string);
                        BufferedReader outputStreamWriter = new BufferedReader((Reader)object);
                        OutputStreamWriter cArray = new OutputStreamWriter(iOException3);
                        bufferedWriter = new BufferedWriter(cArray);
                        char[] n3 = new char[1024];
                        while ((iOException = outputStreamWriter.read(n3, 0, n3.length)) >= 0) {
                            bufferedWriter.write(n3, 0, iOException);
                        }
                        bufferedWriter.flush();
                    }
                    catch (IOException object4) {
                        this.notifyEvent(103);
                        throw new PrintException(object4);
                    }
                    Object var17_36 = null;
                    {
                    }
                }
                catch (Throwable throwable) {
                    Object var17_37 = null;
                    try {
                        if (bufferedWriter == null) throw throwable;
                        bufferedWriter.close();
                        throw throwable;
                    }
                    catch (IOException iOException9) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {}
                catch (IOException iOException10) {}
                if (bufferedWriter != null) {
                    bufferedWriter.close();
                }
                break block56;
            }
            if (this.instream != null) {
                object = new BufferedInputStream(this.instream);
                BufferedOutputStream bufferedReader = new BufferedOutputStream(iOException3);
                byte[] outputStreamWriter = new byte[1024];
                int cArray = 0;
                try {
                    while ((cArray = ((FilterInputStream)object).read(outputStreamWriter)) >= 0) {
                        bufferedReader.write(outputStreamWriter, 0, cArray);
                    }
                    ((BufferedInputStream)object).close();
                    bufferedReader.flush();
                    bufferedReader.close();
                }
                catch (IOException n2) {
                    this.notifyEvent(103);
                    throw new PrintException(n2);
                }
            }
        }
        this.notifyEvent(106);
        if (this.mDestType == DESTPRINTER) {
            object = new PrinterSpooler(this, null);
            AccessController.doPrivileged((PrivilegedAction)object);
            if (((PrinterSpooler)object).pex != null) {
                throw ((PrinterSpooler)object).pex;
            }
        }
        this.notifyEvent(105);
        this.service.wakeNotifier();
    }

    static File access$402(UnixPrintJob unixPrintJob, File file) {
        unixPrintJob.spoolFile = file;
        return unixPrintJob.spoolFile;
    }

    private String[] printExecCmd(String string, String string2, boolean bl2, String string3, int n2, String string4) {
        String[] stringArray;
        int n3 = 1;
        int n4 = 2;
        int n5 = 4;
        int n6 = 8;
        int n7 = 16;
        int n8 = 0;
        int n9 = 2;
        int n10 = 0;
        if (string != null && !string.equals("") && !string.equals("lp")) {
            n8 |= n3;
            ++n9;
        }
        if (string2 != null && !string2.equals("")) {
            n8 |= n4;
            ++n9;
        }
        if (string3 != null && !string3.equals("")) {
            n8 |= n5;
            ++n9;
        }
        if (n2 > 1) {
            n8 |= n6;
            ++n9;
        }
        if (bl2) {
            n8 |= n7;
            ++n9;
        }
        if (UnixPrintServiceLookup.osname.equals("SunOS")) {
            stringArray = new String[++n9];
            stringArray[n10++] = "/usr/bin/lp";
            stringArray[n10++] = "-c";
            if ((n8 & n3) != 0) {
                stringArray[n10++] = new String("-d" + string);
            }
            if ((n8 & n5) != 0) {
                String string5 = "\"";
                stringArray[n10++] = new String("-t " + string5 + string3 + string5);
            }
            if ((n8 & n6) != 0) {
                stringArray[n10++] = new String("-n " + new Integer(n2).toString());
            }
            if ((n8 & n7) != 0) {
                stringArray[n10++] = new String("-o nobanner");
            }
            if ((n8 & n4) != 0) {
                stringArray[n10++] = new String("-o " + string2);
            }
        } else {
            stringArray = new String[n9];
            stringArray[n10++] = "/usr/bin/lpr";
            if ((n8 & n3) != 0) {
                stringArray[n10++] = new String("-P" + string);
            }
            if ((n8 & n5) != 0) {
                stringArray[n10++] = new String("-J " + string3);
            }
            if ((n8 & n6) != 0) {
                stringArray[n10++] = new String("-#" + new Integer(n2).toString());
            }
            if ((n8 & n7) != 0) {
                stringArray[n10++] = new String("-h");
            }
            if ((n8 & n4) != 0) {
                stringArray[n10++] = new String(string2);
            }
        }
        stringArray[n10++] = string4;
        return stringArray;
    }

    static String[] access$1100(UnixPrintJob unixPrintJob, String string, String string2, boolean bl2, String string3, int n2, String string4) {
        return unixPrintJob.printExecCmd(string, string2, bl2, string3, n2, string4);
    }

    static class 1 {
    }

    private class PrinterOpener
    implements PrivilegedAction {
        PrintException pex;
        OutputStream result;
        private final UnixPrintJob this$0;

        public Object run() {
            try {
                if (UnixPrintJob.access$200(this.this$0) == UnixPrintJob.access$300()) {
                    UnixPrintJob.access$402(this.this$0, new File(UnixPrintJob.access$500(this.this$0)));
                } else {
                    UnixPrintJob.access$402(this.this$0, File.createTempFile("javaprint", ".ps", null));
                    UnixPrintJob.access$400(this.this$0).deleteOnExit();
                }
                this.result = new FileOutputStream(UnixPrintJob.access$400(this.this$0));
                return this.result;
            }
            catch (IOException iOException) {
                UnixPrintJob.access$600(this.this$0, 103);
                this.pex = new PrintException(iOException);
                return null;
            }
        }

        private PrinterOpener(UnixPrintJob unixPrintJob) {
            this.this$0 = unixPrintJob;
        }

        PrinterOpener(UnixPrintJob unixPrintJob, 1 var2_2) {
            this(unixPrintJob);
        }
    }

    private class PrinterSpooler
    implements PrivilegedAction {
        PrintException pex;
        private final UnixPrintJob this$0;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object run() {
            try {
                if (UnixPrintJob.access$400(this.this$0) == null || !UnixPrintJob.access$400(this.this$0).exists()) {
                    this.pex = new PrintException("No spool file");
                    UnixPrintJob.access$600(this.this$0, 103);
                    Object var1_1 = null;
                    return var1_1;
                }
                String string = UnixPrintJob.access$400(this.this$0).getAbsolutePath();
                String[] stringArray = UnixPrintJob.access$1100(this.this$0, UnixPrintJob.access$500(this.this$0), UnixPrintJob.access$700(this.this$0), UnixPrintJob.access$800(this.this$0), UnixPrintJob.access$900(this.this$0), UnixPrintJob.access$1000(this.this$0), string);
                Process process = Runtime.getRuntime().exec(stringArray);
                process.waitFor();
                UnixPrintJob.access$400(this.this$0).delete();
                UnixPrintJob.access$600(this.this$0, 106);
            }
            catch (IOException iOException) {
                UnixPrintJob.access$600(this.this$0, 103);
                this.pex = new PrintException(iOException);
            }
            catch (InterruptedException interruptedException) {
                UnixPrintJob.access$600(this.this$0, 103);
                this.pex = new PrintException(interruptedException);
            }
            finally {
                UnixPrintJob.access$600(this.this$0, 105);
            }
            return null;
        }

        private PrinterSpooler(UnixPrintJob unixPrintJob) {
            this.this$0 = unixPrintJob;
        }

        PrinterSpooler(UnixPrintJob unixPrintJob, 1 var2_2) {
            this(unixPrintJob);
        }
    }
}

