/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import sun.nio.cs.StandardCharsets;
import sun.nio.cs.Surrogate;
import sun.nio.cs.Unicode;

class UTF_8
extends Unicode {
    static Class class$sun$nio$cs$UTF_8;

    public UTF_8() {
        super("UTF-8", StandardCharsets.aliasesFor("UTF-8"));
    }

    public String historicalName() {
        return "UTF8";
    }

    public CharsetDecoder newDecoder() {
        return new Decoder(this, null);
    }

    public CharsetEncoder newEncoder() {
        return new Encoder(this, null);
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    static final void updatePositions(CharBuffer charBuffer, int n2, ByteBuffer byteBuffer, int n3) {
        charBuffer.position(n2 - charBuffer.arrayOffset());
        byteBuffer.position(n3 - byteBuffer.arrayOffset());
    }

    static final void updatePositions(ByteBuffer byteBuffer, int n2, CharBuffer charBuffer, int n3) {
        byteBuffer.position(n2 - byteBuffer.arrayOffset());
        charBuffer.position(n3 - charBuffer.arrayOffset());
    }

    static class 1 {
    }

    private static class Decoder
    extends CharsetDecoder {
        static final boolean $assertionsDisabled = !(class$sun$nio$cs$UTF_8 == null ? (class$sun$nio$cs$UTF_8 = UTF_8.class$("sun.nio.cs.UTF_8")) : class$sun$nio$cs$UTF_8).desiredAssertionStatus();

        private static boolean isNotContinuation(int n2) {
            return (n2 & 0xC0) != 128;
        }

        private static final boolean isMalformed2(int n2, int n3) {
            return (n2 & 0x1E) == 0 || (n3 & 0xC0) != 128;
        }

        private static boolean isMalformed3(int n2, int n3, int n4) {
            return n2 == -32 && (n3 & 0xE0) == 128 || (n3 & 0xC0) != 128 || (n4 & 0xC0) != 128;
        }

        private static final boolean isMalformed4(int n2, int n3, int n4) {
            return (n2 & 0xC0) != 128 || (n3 & 0xC0) != 128 || (n4 & 0xC0) != 128;
        }

        private Decoder(Charset charset) {
            super(charset, 1.0f, 1.0f);
        }

        private static CoderResult xflow(Buffer buffer, int n2, int n3) {
            CoderResult coderResult = n3 == 0 || buffer.remaining() < n3 - 1 ? CoderResult.UNDERFLOW : CoderResult.OVERFLOW;
            buffer.position(n2);
            return coderResult;
        }

        private static CoderResult lookupN(ByteBuffer byteBuffer, int n2) {
            for (int i2 = 1; i2 < n2; ++i2) {
                if (!Decoder.isNotContinuation(byteBuffer.get())) continue;
                return CoderResult.malformedForLength(i2);
            }
            return CoderResult.malformedForLength(n2);
        }

        private static CoderResult malformedN(ByteBuffer byteBuffer, int n2) {
            switch (n2) {
                case 1: {
                    byte by = byteBuffer.get();
                    if (by >> 2 == -2) {
                        if (byteBuffer.remaining() < 4) {
                            return CoderResult.UNDERFLOW;
                        }
                        return Decoder.lookupN(byteBuffer, 5);
                    }
                    if (by >> 1 == -2) {
                        if (byteBuffer.remaining() < 5) {
                            return CoderResult.UNDERFLOW;
                        }
                        return Decoder.lookupN(byteBuffer, 6);
                    }
                    return CoderResult.malformedForLength(1);
                }
                case 2: {
                    return CoderResult.malformedForLength(1);
                }
                case 3: {
                    byte by = byteBuffer.get();
                    byte by2 = byteBuffer.get();
                    return CoderResult.malformedForLength(by == -32 && (by2 & 0xE0) == 128 || Decoder.isNotContinuation(by2) ? 1 : 2);
                }
                case 4: {
                    int n3 = byteBuffer.get() & 0xFF;
                    int n4 = byteBuffer.get() & 0xFF;
                    if (n3 > 244 || n3 == 240 && (n4 < 144 || n4 > 191) || n3 == 244 && (n4 & 0xF0) != 128 || Decoder.isNotContinuation(n4)) {
                        return CoderResult.malformedForLength(1);
                    }
                    if (Decoder.isNotContinuation(byteBuffer.get())) {
                        return CoderResult.malformedForLength(2);
                    }
                    return CoderResult.malformedForLength(3);
                }
            }
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            return null;
        }

        private static CoderResult malformed(ByteBuffer byteBuffer, int n2, int n3) {
            byteBuffer.position(n2);
            CoderResult coderResult = Decoder.malformedN(byteBuffer, n3);
            byteBuffer.position(n2);
            return coderResult;
        }

        Decoder(Charset charset, 1 var2_2) {
            this(charset);
        }

        private static CoderResult xflow(ByteBuffer byteBuffer, int n2, int n3, CharBuffer charBuffer, int n4, int n5) {
            UTF_8.updatePositions(byteBuffer, n2, charBuffer, n4);
            return n5 == 0 || n3 - n2 < n5 ? CoderResult.UNDERFLOW : CoderResult.OVERFLOW;
        }

        private static CoderResult malformed(ByteBuffer byteBuffer, int n2, CharBuffer charBuffer, int n3, int n4) {
            byteBuffer.position(n2 - byteBuffer.arrayOffset());
            CoderResult coderResult = Decoder.malformedN(byteBuffer, n4);
            UTF_8.updatePositions(byteBuffer, n2, charBuffer, n3);
            return coderResult;
        }

        private CoderResult decodeArrayLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            byte[] byArray = byteBuffer.array();
            int n2 = byteBuffer.arrayOffset() + byteBuffer.position();
            int n3 = byteBuffer.arrayOffset() + byteBuffer.limit();
            char[] cArray = charBuffer.array();
            int n4 = charBuffer.arrayOffset() + charBuffer.position();
            int n5 = charBuffer.arrayOffset() + charBuffer.limit();
            int n6 = n4 + Math.min(n3 - n2, n5 - n4);
            while (n4 < n6 && byArray[n2] >= 0) {
                cArray[n4++] = (char)byArray[n2++];
            }
            while (n2 < n3) {
                byte by;
                byte by2;
                byte by3 = byArray[n2];
                if (by3 >= 0) {
                    if (n4 >= n5) {
                        return Decoder.xflow(byteBuffer, n2, n3, charBuffer, n4, 1);
                    }
                    cArray[n4++] = (char)by3;
                    ++n2;
                    continue;
                }
                if (by3 >> 5 == -2) {
                    if (n3 - n2 < 2 || n4 >= n5) {
                        return Decoder.xflow(byteBuffer, n2, n3, charBuffer, n4, 2);
                    }
                    by2 = byArray[n2 + 1];
                    if (Decoder.isMalformed2(by3, by2)) {
                        return Decoder.malformed(byteBuffer, n2, charBuffer, n4, 2);
                    }
                    cArray[n4++] = (char)(by3 << 6 ^ by2 ^ 0xF80);
                    n2 += 2;
                    continue;
                }
                if (by3 >> 4 == -2) {
                    if (n3 - n2 < 3 || n4 >= n5) {
                        return Decoder.xflow(byteBuffer, n2, n3, charBuffer, n4, 3);
                    }
                    by2 = byArray[n2 + 1];
                    by = byArray[n2 + 2];
                    if (Decoder.isMalformed3(by3, by2, by)) {
                        return Decoder.malformed(byteBuffer, n2, charBuffer, n4, 3);
                    }
                    cArray[n4++] = (char)(by3 << 12 ^ by2 << 6 ^ by ^ 0x1F80);
                    n2 += 3;
                    continue;
                }
                if (by3 >> 3 == -2) {
                    if (n3 - n2 < 4 || n5 - n4 < 2) {
                        return Decoder.xflow(byteBuffer, n2, n3, charBuffer, n4, 4);
                    }
                    by2 = byArray[n2 + 1];
                    by = byArray[n2 + 2];
                    byte by4 = byArray[n2 + 3];
                    int n7 = (by3 & 7) << 18 | (by2 & 0x3F) << 12 | (by & 0x3F) << 6 | by4 & 0x3F;
                    if (Decoder.isMalformed4(by2, by, by4) || !Surrogate.neededFor(n7)) {
                        return Decoder.malformed(byteBuffer, n2, charBuffer, n4, 4);
                    }
                    cArray[n4++] = Surrogate.high(n7);
                    cArray[n4++] = Surrogate.low(n7);
                    n2 += 4;
                    continue;
                }
                return Decoder.malformed(byteBuffer, n2, charBuffer, n4, 1);
            }
            return Decoder.xflow(byteBuffer, n2, n3, charBuffer, n4, 0);
        }

        private CoderResult decodeBufferLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            int n2 = byteBuffer.position();
            int n3 = byteBuffer.limit();
            while (n2 < n3) {
                byte by;
                byte by2;
                byte by3 = byteBuffer.get();
                if (by3 >= 0) {
                    if (charBuffer.remaining() < 1) {
                        return Decoder.xflow(byteBuffer, n2, 1);
                    }
                    charBuffer.put((char)by3);
                    ++n2;
                    continue;
                }
                if (by3 >> 5 == -2) {
                    if (n3 - n2 < 2 || charBuffer.remaining() < 1) {
                        return Decoder.xflow(byteBuffer, n2, 2);
                    }
                    by2 = byteBuffer.get();
                    if (Decoder.isMalformed2(by3, by2)) {
                        return Decoder.malformed(byteBuffer, n2, 2);
                    }
                    charBuffer.put((char)(by3 << 6 ^ by2 ^ 0xF80));
                    n2 += 2;
                    continue;
                }
                if (by3 >> 4 == -2) {
                    if (n3 - n2 < 3 || charBuffer.remaining() < 1) {
                        return Decoder.xflow(byteBuffer, n2, 3);
                    }
                    by2 = byteBuffer.get();
                    if (Decoder.isMalformed3(by3, by2, by = byteBuffer.get())) {
                        return Decoder.malformed(byteBuffer, n2, 3);
                    }
                    charBuffer.put((char)(by3 << 12 ^ by2 << 6 ^ by ^ 0x1F80));
                    n2 += 3;
                    continue;
                }
                if (by3 >> 3 == -2) {
                    if (n3 - n2 < 4 || charBuffer.remaining() < 2) {
                        return Decoder.xflow(byteBuffer, n2, 4);
                    }
                    by2 = byteBuffer.get();
                    by = byteBuffer.get();
                    byte by4 = byteBuffer.get();
                    int n4 = (by3 & 7) << 18 | (by2 & 0x3F) << 12 | (by & 0x3F) << 6 | by4 & 0x3F;
                    if (Decoder.isMalformed4(by2, by, by4) || !Surrogate.neededFor(n4)) {
                        return Decoder.malformed(byteBuffer, n2, 4);
                    }
                    charBuffer.put(Surrogate.high(n4));
                    charBuffer.put(Surrogate.low(n4));
                    n2 += 4;
                    continue;
                }
                return Decoder.malformed(byteBuffer, n2, 1);
            }
            return Decoder.xflow(byteBuffer, n2, 0);
        }

        protected CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            if (byteBuffer.hasArray() && charBuffer.hasArray()) {
                return this.decodeArrayLoop(byteBuffer, charBuffer);
            }
            return this.decodeBufferLoop(byteBuffer, charBuffer);
        }
    }

    private static class Encoder
    extends CharsetEncoder {
        private Surrogate.Parser sgp;

        public boolean canEncode(char c2) {
            return !Surrogate.is(c2);
        }

        public boolean isLegalReplacement(byte[] byArray) {
            return byArray.length == 1 && byArray[0] >= 0 || super.isLegalReplacement(byArray);
        }

        private Encoder(Charset charset) {
            super(charset, 1.1f, 4.0f);
        }

        private static CoderResult overflow(CharBuffer charBuffer, int n2) {
            charBuffer.position(n2);
            return CoderResult.OVERFLOW;
        }

        Encoder(Charset charset, 1 var2_2) {
            this(charset);
        }

        private static CoderResult overflow(CharBuffer charBuffer, int n2, ByteBuffer byteBuffer, int n3) {
            UTF_8.updatePositions(charBuffer, n2, byteBuffer, n3);
            return CoderResult.OVERFLOW;
        }

        private CoderResult encodeArrayLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
            char[] cArray = charBuffer.array();
            int n2 = charBuffer.arrayOffset() + charBuffer.position();
            int n3 = charBuffer.arrayOffset() + charBuffer.limit();
            byte[] byArray = byteBuffer.array();
            int n4 = byteBuffer.arrayOffset() + byteBuffer.position();
            int n5 = byteBuffer.arrayOffset() + byteBuffer.limit();
            int n6 = n4 + Math.min(n3 - n2, n5 - n4);
            while (n4 < n6 && cArray[n2] < '\u0080') {
                byArray[n4++] = (byte)cArray[n2++];
            }
            while (n2 < n3) {
                char c2 = cArray[n2];
                if (c2 < '\u0080') {
                    if (n4 >= n5) {
                        return Encoder.overflow(charBuffer, n2, byteBuffer, n4);
                    }
                    byArray[n4++] = (byte)c2;
                } else if (c2 < '\u0800') {
                    if (n5 - n4 < 2) {
                        return Encoder.overflow(charBuffer, n2, byteBuffer, n4);
                    }
                    byArray[n4++] = (byte)(0xC0 | c2 >> 6);
                    byArray[n4++] = (byte)(0x80 | c2 & 0x3F);
                } else if (Surrogate.is(c2)) {
                    int n7;
                    if (this.sgp == null) {
                        this.sgp = new Surrogate.Parser();
                    }
                    if ((n7 = this.sgp.parse(c2, cArray, n2, n3)) < 0) {
                        UTF_8.updatePositions(charBuffer, n2, byteBuffer, n4);
                        return this.sgp.error();
                    }
                    if (n5 - n4 < 4) {
                        return Encoder.overflow(charBuffer, n2, byteBuffer, n4);
                    }
                    byArray[n4++] = (byte)(0xF0 | n7 >> 18);
                    byArray[n4++] = (byte)(0x80 | n7 >> 12 & 0x3F);
                    byArray[n4++] = (byte)(0x80 | n7 >> 6 & 0x3F);
                    byArray[n4++] = (byte)(0x80 | n7 & 0x3F);
                    ++n2;
                } else {
                    if (n5 - n4 < 3) {
                        return Encoder.overflow(charBuffer, n2, byteBuffer, n4);
                    }
                    byArray[n4++] = (byte)(0xE0 | c2 >> 12);
                    byArray[n4++] = (byte)(0x80 | c2 >> 6 & 0x3F);
                    byArray[n4++] = (byte)(0x80 | c2 & 0x3F);
                }
                ++n2;
            }
            UTF_8.updatePositions(charBuffer, n2, byteBuffer, n4);
            return CoderResult.UNDERFLOW;
        }

        private CoderResult encodeBufferLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
            int n2 = charBuffer.position();
            while (charBuffer.hasRemaining()) {
                char c2 = charBuffer.get();
                if (c2 < '\u0080') {
                    if (!byteBuffer.hasRemaining()) {
                        return Encoder.overflow(charBuffer, n2);
                    }
                    byteBuffer.put((byte)c2);
                } else if (c2 < '\u0800') {
                    if (byteBuffer.remaining() < 2) {
                        return Encoder.overflow(charBuffer, n2);
                    }
                    byteBuffer.put((byte)(0xC0 | c2 >> 6));
                    byteBuffer.put((byte)(0x80 | c2 & 0x3F));
                } else if (Surrogate.is(c2)) {
                    int n3;
                    if (this.sgp == null) {
                        this.sgp = new Surrogate.Parser();
                    }
                    if ((n3 = this.sgp.parse(c2, charBuffer)) < 0) {
                        charBuffer.position(n2);
                        return this.sgp.error();
                    }
                    if (byteBuffer.remaining() < 4) {
                        return Encoder.overflow(charBuffer, n2);
                    }
                    byteBuffer.put((byte)(0xF0 | n3 >> 18));
                    byteBuffer.put((byte)(0x80 | n3 >> 12 & 0x3F));
                    byteBuffer.put((byte)(0x80 | n3 >> 6 & 0x3F));
                    byteBuffer.put((byte)(0x80 | n3 & 0x3F));
                    ++n2;
                } else {
                    if (byteBuffer.remaining() < 3) {
                        return Encoder.overflow(charBuffer, n2);
                    }
                    byteBuffer.put((byte)(0xE0 | c2 >> 12));
                    byteBuffer.put((byte)(0x80 | c2 >> 6 & 0x3F));
                    byteBuffer.put((byte)(0x80 | c2 & 0x3F));
                }
                ++n2;
            }
            charBuffer.position(n2);
            return CoderResult.UNDERFLOW;
        }

        protected final CoderResult encodeLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
            if (charBuffer.hasArray() && byteBuffer.hasArray()) {
                return this.encodeArrayLoop(charBuffer, byteBuffer);
            }
            return this.encodeBufferLoop(charBuffer, byteBuffer);
        }
    }
}

