/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.Timer;

class Autoscroller
extends MouseAdapter
implements Serializable {
    transient MouseEvent event;
    transient Timer timer;
    JComponent component;

    void dispose() {
        this.stop();
        this.component.removeMouseListener(this);
    }

    void stop() {
        this.timer.stop();
        this.event = null;
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        Rectangle rectangle = this.component.getVisibleRect();
        boolean bl2 = rectangle.contains(mouseEvent.getX(), mouseEvent.getY());
        if (bl2) {
            if (this.timer.isRunning()) {
                this.stop();
            }
        } else {
            Point point = this.component.getLocationOnScreen();
            this.event = new MouseEvent(this.component, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX() + point.x, mouseEvent.getY() + point.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
            if (!this.timer.isRunning()) {
                this.timer.start();
            }
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.stop();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.timer = new Timer(100, new AutoScrollTimerAction(this));
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    Autoscroller(JComponent jComponent) {
        if (jComponent == null) {
            throw new IllegalArgumentException("component must be non null");
        }
        this.component = jComponent;
        this.timer = new Timer(100, new AutoScrollTimerAction(this));
        this.component.addMouseListener(this);
    }

    class AutoScrollTimerAction
    implements ActionListener {
        private final Autoscroller this$0;

        public void actionPerformed(ActionEvent actionEvent) {
            if (!this.this$0.component.isShowing() || this.this$0.event == null) {
                this.this$0.stop();
                return;
            }
            Point point = this.this$0.component.getLocationOnScreen();
            MouseEvent mouseEvent = new MouseEvent(this.this$0.component, this.this$0.event.getID(), this.this$0.event.getWhen(), this.this$0.event.getModifiers(), this.this$0.event.getX() - point.x, this.this$0.event.getY() - point.y, this.this$0.event.getClickCount(), this.this$0.event.isPopupTrigger());
            this.this$0.component.superProcessMouseMotionEvent(mouseEvent);
        }

        AutoScrollTimerAction(Autoscroller autoscroller) {
            this.this$0 = autoscroller;
        }
    }
}

