/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.gtk;

import com.sun.java.swing.plaf.gtk.ColorType;
import com.sun.java.swing.plaf.gtk.LazyActionMap;
import com.sun.java.swing.plaf.gtk.Region;
import com.sun.java.swing.plaf.gtk.SynthArrowButton;
import com.sun.java.swing.plaf.gtk.SynthContext;
import com.sun.java.swing.plaf.gtk.SynthLookAndFeel;
import com.sun.java.swing.plaf.gtk.SynthStyle;
import com.sun.java.swing.plaf.gtk.SynthUI;
import com.sun.java.swing.plaf.gtk.TabContext;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.InputMapUIResource;
import javax.swing.plaf.TabbedPaneUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.text.View;

class SynthTabbedPaneUI
extends TabbedPaneUI
implements SynthUI,
SwingConstants {
    private static Action scrollTabsForwardAction = new ScrollTabsForwardAction(null);
    private static Action scrollTabsBackwardAction = new ScrollTabsBackwardAction(null);
    private SynthContext tabAreaContext;
    private TabContext tabContext;
    private SynthContext tabContentContext;
    private SynthStyle style;
    private SynthStyle tabStyle;
    private SynthStyle tabAreaStyle;
    private SynthStyle tabContentStyle;
    private int tabRunOverlay;
    protected JTabbedPane tabPane;
    protected int[] tabRuns = new int[10];
    protected int runCount = 0;
    protected int selectedRun = -1;
    protected Rectangle[] rects = new Rectangle[0];
    protected int maxTabHeight;
    protected int maxTabWidth;
    protected ChangeListener tabChangeListener;
    protected PropertyChangeListener propertyChangeListener;
    protected MouseInputListener mouseInputListener;
    protected FocusListener focusListener;
    private ContainerListener containerListener;
    private Insets currentPadInsets = new Insets(0, 0, 0, 0);
    private Insets currentTabAreaInsets = new Insets(0, 0, 0, 0);
    private Component visibleComponent;
    private Vector htmlViews;
    private Hashtable mnemonicToIndexMap;
    private InputMap mnemonicInputMap;
    private ScrollableTabSupport tabScroller;
    protected transient Rectangle calcRect = new Rectangle(0, 0, 0, 0);
    private int tabCount;
    private int mouseIndex;
    private boolean selectionFollowsFocus = true;
    private int focusIndex = -1;
    private Rectangle mouseBounds;
    static Class class$com$sun$java$swing$plaf$gtk$SynthTabbedPaneUI;
    static Class class$com$sun$java$swing$plaf$gtk$SynthContext;
    static Class class$com$sun$java$swing$plaf$gtk$TabContext;

    int getFocusIndex() {
        return this.focusIndex;
    }

    private int getTextIconGap() {
        Integer n2 = (Integer)this.tabContext.getStyle().get(this.tabContext, "textIconGap");
        if (n2 == null) {
            return 0;
        }
        return n2;
    }

    SynthTabbedPaneUI() {
    }

    private void ensureCurrentLayout() {
        if (!this.tabPane.isValid()) {
            this.tabPane.validate();
        }
        if (!this.tabPane.isValid()) {
            TabbedPaneLayout tabbedPaneLayout = (TabbedPaneLayout)this.tabPane.getLayout();
            tabbedPaneLayout.calculateLayoutInfo();
        }
    }

    protected void expandTabRunsArray() {
        int n2 = this.tabRuns.length;
        int[] nArray = new int[n2 + 10];
        System.arraycopy(this.tabRuns, 0, nArray, 0, this.runCount);
        this.tabRuns = nArray;
    }

    private void initMnemonics() {
        this.mnemonicToIndexMap = new Hashtable();
        this.mnemonicInputMap = new InputMapUIResource();
        this.mnemonicInputMap.setParent(SwingUtilities.getUIInputMap(this.tabPane, 1));
        SwingUtilities.replaceUIInputMap(this.tabPane, 1, this.mnemonicInputMap);
    }

    protected void installComponents() {
        if (this.scrollableTabLayoutEnabled() && this.tabScroller == null) {
            this.tabScroller = new ScrollableTabSupport(this, this.tabPane.getTabPlacement());
            this.tabPane.add(this.tabScroller.viewport);
            this.tabPane.add(this.tabScroller.scrollForwardButton);
            this.tabPane.add(this.tabScroller.scrollBackwardButton);
        }
    }

    protected void installDefaults() {
        this.fetchStyle(this.tabPane);
    }

    protected void installKeyboardActions() {
        InputMap inputMap = this.getInputMap(1);
        SwingUtilities.replaceUIInputMap(this.tabPane, 1, inputMap);
        inputMap = this.getInputMap(0);
        SwingUtilities.replaceUIInputMap(this.tabPane, 0, inputMap);
        LazyActionMap.installLazyActionMap(this.tabPane, class$com$sun$java$swing$plaf$gtk$SynthTabbedPaneUI == null ? (class$com$sun$java$swing$plaf$gtk$SynthTabbedPaneUI = SynthTabbedPaneUI.class$("com.sun.java.swing.plaf.gtk.SynthTabbedPaneUI")) : class$com$sun$java$swing$plaf$gtk$SynthTabbedPaneUI, "TabbedPane.actionMap");
        if (this.scrollableTabLayoutEnabled()) {
            this.tabScroller.scrollForwardButton.setAction(scrollTabsForwardAction);
            this.tabScroller.scrollBackwardButton.setAction(scrollTabsBackwardAction);
        }
    }

    protected void installListeners() {
        this.propertyChangeListener = this.createPropertyChangeListener();
        if (this.propertyChangeListener != null) {
            this.tabPane.addPropertyChangeListener(this.propertyChangeListener);
        }
        if ((this.tabChangeListener = this.createChangeListener()) != null) {
            this.tabPane.addChangeListener(this.tabChangeListener);
        }
        if ((this.mouseInputListener = this.createMouseInputListener()) != null) {
            if (this.scrollableTabLayoutEnabled()) {
                this.tabScroller.tabPanel.addMouseListener(this.mouseInputListener);
                this.tabScroller.tabPanel.addMouseMotionListener(this.mouseInputListener);
            } else {
                this.tabPane.addMouseListener(this.mouseInputListener);
                this.tabPane.addMouseMotionListener(this.mouseInputListener);
            }
        }
        if ((this.focusListener = this.createFocusListener()) != null) {
            this.tabPane.addFocusListener(this.focusListener);
        }
        if ((this.containerListener = new ContainerHandler(this, null)) != null) {
            this.tabPane.addContainerListener(this.containerListener);
            if (this.tabPane.getTabCount() > 0) {
                this.htmlViews = this.createHTMLVector();
            }
        }
    }

    private void resetMnemonics() {
        if (this.mnemonicToIndexMap != null) {
            this.mnemonicToIndexMap.clear();
            this.mnemonicInputMap.clear();
        }
    }

    protected void uninstallComponents() {
        if (this.scrollableTabLayoutEnabled()) {
            this.tabPane.remove(this.tabScroller.viewport);
            this.tabPane.remove(this.tabScroller.scrollForwardButton);
            this.tabPane.remove(this.tabScroller.scrollBackwardButton);
            this.tabScroller = null;
        }
    }

    protected void uninstallDefaults() {
        SynthContext synthContext = this.getContext((JComponent)this.tabPane, 1);
        this.style.uninstallDefaults(synthContext);
        synthContext.dispose();
        this.style = null;
        synthContext = this.getContext(this.tabPane, Region.TABBED_PANE_TAB, 1);
        this.tabStyle.uninstallDefaults(synthContext);
        synthContext.dispose();
        this.tabStyle = null;
        synthContext = this.getContext(this.tabPane, Region.TABBED_PANE_TAB_AREA, 1);
        this.tabAreaStyle.uninstallDefaults(synthContext);
        synthContext.dispose();
        this.tabAreaStyle = null;
        synthContext = this.getContext(this.tabPane, Region.TABBED_PANE_CONTENT, 1);
        this.tabContentStyle.uninstallDefaults(synthContext);
        synthContext.dispose();
        this.tabContentStyle = null;
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIActionMap(this.tabPane, null);
        SwingUtilities.replaceUIInputMap(this.tabPane, 1, null);
        SwingUtilities.replaceUIInputMap(this.tabPane, 0, null);
    }

    protected void uninstallListeners() {
        if (this.mouseInputListener != null) {
            if (this.scrollableTabLayoutEnabled()) {
                this.tabScroller.tabPanel.removeMouseListener(this.mouseInputListener);
                this.tabScroller.tabPanel.removeMouseMotionListener(this.mouseInputListener);
            } else {
                this.tabPane.removeMouseListener(this.mouseInputListener);
                this.tabPane.removeMouseMotionListener(this.mouseInputListener);
            }
            this.mouseInputListener = null;
        }
        if (this.focusListener != null) {
            this.tabPane.removeFocusListener(this.focusListener);
            this.focusListener = null;
        }
        if (this.containerListener != null) {
            this.tabPane.removeContainerListener(this.containerListener);
            this.containerListener = null;
            if (this.htmlViews != null) {
                this.htmlViews.removeAllElements();
                this.htmlViews = null;
            }
        }
        if (this.tabChangeListener != null) {
            this.tabPane.removeChangeListener(this.tabChangeListener);
            this.tabChangeListener = null;
        }
        if (this.propertyChangeListener != null) {
            this.tabPane.removePropertyChangeListener(this.propertyChangeListener);
            this.propertyChangeListener = null;
        }
    }

    private void updateMnemonics() {
        this.resetMnemonics();
        for (int i2 = this.tabPane.getTabCount() - 1; i2 >= 0; --i2) {
            int n2 = this.tabPane.getMnemonicAt(i2);
            if (n2 <= 0) continue;
            this.addMnemonic(i2, n2);
        }
    }

    boolean requestFocusForVisibleComponent() {
        Component component = this.getVisibleComponent();
        if (component.isFocusTraversable()) {
            component.requestFocus();
            return true;
        }
        return component instanceof JComponent && ((JComponent)component).requestDefaultFocus();
    }

    private boolean scrollableTabLayoutEnabled() {
        return this.tabPane.getLayout() instanceof TabbedPaneScrollLayout;
    }

    protected int calculateMaxTabHeight(int n2) {
        FontMetrics fontMetrics = this.getFontMetrics(this.tabContext.getStyle().getFont(this.tabContext));
        int n3 = this.tabPane.getTabCount();
        int n4 = 0;
        int n5 = fontMetrics.getHeight();
        for (int i2 = 0; i2 < n3; ++i2) {
            n4 = Math.max(this.calculateTabHeight(n2, i2, n5), n4);
        }
        return n4;
    }

    protected int calculateMaxTabWidth(int n2) {
        FontMetrics fontMetrics = this.getFontMetrics(this.tabContext.getStyle().getFont(this.tabContext));
        int n3 = this.tabPane.getTabCount();
        int n4 = 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            n4 = Math.max(this.calculateTabWidth(n2, i2, fontMetrics), n4);
        }
        return n4;
    }

    protected int getNextTabIndex(int n2) {
        return (n2 + 1) % this.tabPane.getTabCount();
    }

    protected int getNextTabRun(int n2) {
        return (n2 + 1) % this.runCount;
    }

    protected int getPreviousTabIndex(int n2) {
        int n3 = n2 - 1 >= 0 ? n2 - 1 : this.tabPane.getTabCount() - 1;
        return n3 >= 0 ? n3 : 0;
    }

    protected int getPreviousTabRun(int n2) {
        int n3 = n2 - 1 >= 0 ? n2 - 1 : this.runCount - 1;
        return n3 >= 0 ? n3 : 0;
    }

    protected int getTabRunOverlay(int n2) {
        return this.tabRunOverlay;
    }

    protected void assureRectsCreated(int n2) {
        int n3 = this.rects.length;
        if (n2 != n3) {
            Rectangle[] rectangleArray = new Rectangle[n2];
            System.arraycopy(this.rects, 0, rectangleArray, 0, Math.min(n3, n2));
            this.rects = rectangleArray;
            for (int i2 = n3; i2 < n2; ++i2) {
                this.rects[i2] = new Rectangle();
            }
        }
    }

    protected void navigateSelectedTab(int n2) {
        int n3 = this.tabPane.getTabPlacement();
        int n4 = this.selectionFollowsFocus ? this.tabPane.getSelectedIndex() : this.focusIndex;
        int n5 = this.tabPane.getTabCount();
        if (n5 <= 0) {
            return;
        }
        block0 : switch (n3) {
            case 12: {
                this.selectNextTab(n4);
                break;
            }
            case 13: {
                this.selectPreviousTab(n4);
                break;
            }
            case 2: 
            case 4: {
                switch (n2) {
                    case 1: {
                        this.selectPreviousTabInRun(n4);
                        break block0;
                    }
                    case 5: {
                        this.selectNextTabInRun(n4);
                        break block0;
                    }
                    case 7: {
                        int n6 = this.getTabRunOffset(n3, n5, n4, false);
                        this.selectAdjacentRunTab(n3, n4, n6);
                        break block0;
                    }
                    case 3: {
                        int n7 = this.getTabRunOffset(n3, n5, n4, true);
                        this.selectAdjacentRunTab(n3, n4, n7);
                        break block0;
                    }
                }
                break;
            }
            default: {
                switch (n2) {
                    case 1: {
                        int n8 = this.getTabRunOffset(n3, n5, n4, false);
                        this.selectAdjacentRunTab(n3, n4, n8);
                        break block0;
                    }
                    case 5: {
                        int n9 = this.getTabRunOffset(n3, n5, n4, true);
                        this.selectAdjacentRunTab(n3, n4, n9);
                        break block0;
                    }
                    case 3: {
                        this.selectNextTabInRun(n4);
                        break block0;
                    }
                    case 7: {
                        this.selectPreviousTabInRun(n4);
                        break block0;
                    }
                }
            }
        }
    }

    private void navigateTo(int n2) {
        if (this.selectionFollowsFocus) {
            this.setFocusIndex(n2);
            this.tabPane.setSelectedIndex(n2);
        } else {
            int n3 = this.focusIndex;
            this.setFocusIndex(n2);
            this.tabPane.repaint(this.getTabBounds(this.tabPane, this.focusIndex));
            if (n3 != -1) {
                this.tabPane.repaint(this.getTabBounds(this.tabPane, n3));
            }
        }
    }

    private void repaintTab(int n2) {
    }

    protected void selectNextTab(int n2) {
        int n3 = this.getNextTabIndex(n2);
        while (n3 != n2 && !this.tabPane.isEnabledAt(n3)) {
            n3 = this.getNextTabIndex(n3);
        }
        this.navigateTo(n3);
    }

    protected void selectNextTabInRun(int n2) {
        int n3 = this.tabPane.getTabCount();
        int n4 = this.getNextTabIndexInRun(n3, n2);
        while (n4 != n2 && !this.tabPane.isEnabledAt(n4)) {
            n4 = this.getNextTabIndexInRun(n3, n4);
        }
        this.navigateTo(n4);
    }

    protected void selectPreviousTab(int n2) {
        int n3 = this.getPreviousTabIndex(n2);
        while (n3 != n2 && !this.tabPane.isEnabledAt(n3)) {
            n3 = this.getPreviousTabIndex(n3);
        }
        this.navigateTo(n3);
    }

    protected void selectPreviousTabInRun(int n2) {
        int n3 = this.tabPane.getTabCount();
        int n4 = this.getPreviousTabIndexInRun(n3, n2);
        while (n4 != n2 && !this.tabPane.isEnabledAt(n4)) {
            n4 = this.getPreviousTabIndexInRun(n3, n4);
        }
        this.navigateTo(n4);
    }

    void setFocusIndex(int n2) {
        this.focusIndex = n2;
    }

    private void setMouseOverTab(int n2) {
        if (n2 != this.mouseIndex) {
            if (this.mouseBounds != null) {
                this.tabPane.repaint(this.mouseBounds);
            }
            this.mouseIndex = n2;
            if (n2 != -1 && n2 < this.tabPane.getTabCount()) {
                this.mouseBounds = this.tabPane.getBoundsAt(n2);
                if (this.mouseBounds != null) {
                    this.tabPane.repaint(this.mouseBounds);
                }
            } else {
                this.mouseBounds = null;
            }
        }
    }

    protected boolean shouldRotateTabRuns(int n2) {
        return true;
    }

    private int getClosestTab(int n2, int n3) {
        int n4;
        int n5;
        int n6 = 0;
        int n7 = n5 = Math.min(this.rects.length, this.tabPane.getTabCount());
        int n8 = this.tabPane.getTabPlacement();
        boolean bl2 = n8 == 1 || n8 == 3;
        int n9 = n4 = bl2 ? n2 : n3;
        while (n6 != n7) {
            int n10;
            int n11;
            int n12 = (n7 + n6) / 2;
            if (bl2) {
                n11 = this.rects[n12].x;
                n10 = n11 + this.rects[n12].width;
            } else {
                n11 = this.rects[n12].y;
                n10 = n11 + this.rects[n12].height;
            }
            if (n4 < n11) {
                n7 = n12;
                if (n6 != n7) continue;
                return Math.max(0, n12 - 1);
            }
            if (n4 >= n10) {
                n6 = n12;
                if (n7 - n6 > 1) continue;
                return Math.max(n12 + 1, n5 - 1);
            }
            return n12;
        }
        return n6;
    }

    protected int getNextTabIndexInRun(int n2, int n3) {
        if (this.runCount < 2) {
            return this.getNextTabIndex(n3);
        }
        int n4 = this.getRunForTab(n2, n3);
        int n5 = this.getNextTabIndex(n3);
        if (n5 == this.tabRuns[this.getNextTabRun(n4)]) {
            return this.tabRuns[n4];
        }
        return n5;
    }

    protected int getPreviousTabIndexInRun(int n2, int n3) {
        if (this.runCount < 2) {
            return this.getPreviousTabIndex(n3);
        }
        int n4 = this.getRunForTab(n2, n3);
        if (n3 == this.tabRuns[n4]) {
            int n5 = this.tabRuns[this.getNextTabRun(n4)] - 1;
            return n5 != -1 ? n5 : n2 - 1;
        }
        return this.getPreviousTabIndex(n3);
    }

    protected int getRunForTab(int n2, int n3) {
        for (int i2 = 0; i2 < this.runCount; ++i2) {
            int n4 = this.tabRuns[i2];
            int n5 = this.lastTabInRun(n2, i2);
            if (n3 < n4 || n3 > n5) continue;
            return i2;
        }
        return 0;
    }

    private int getTabAtLocation(int n2, int n3) {
        this.ensureCurrentLayout();
        int n4 = this.tabPane.getTabCount();
        for (int i2 = 0; i2 < n4; ++i2) {
            if (!this.rects[i2].contains(n2, n3)) continue;
            return i2;
        }
        return -1;
    }

    protected int getTabRunIndent(int n2, int n3) {
        return 0;
    }

    protected int lastTabInRun(int n2, int n3) {
        int n4;
        if (this.runCount == 1) {
            return n2 - 1;
        }
        int n5 = n4 = n3 == this.runCount - 1 ? 0 : n3 + 1;
        if (this.tabRuns[n4] == 0) {
            return n2 - 1;
        }
        return this.tabRuns[n4] - 1;
    }

    private void addMnemonic(int n2, int n3) {
        if (this.mnemonicToIndexMap == null) {
            this.initMnemonics();
        }
        this.mnemonicInputMap.put(KeyStroke.getKeyStroke(n3, 8), "setSelectedIndex");
        this.mnemonicToIndexMap.put(new Integer(n3), new Integer(n2));
    }

    private void updateMouseOver(int n2, int n3) {
        this.setMouseOverTab(this.getTabAtLocation(n2, n3));
    }

    protected boolean shouldPadTabRun(int n2, int n3) {
        return this.runCount > 1;
    }

    protected int calculateTabAreaHeight(int n2, int n3, int n4) {
        Insets insets = this.getTabAreaInsets(n2);
        int n5 = this.getTabRunOverlay(n2);
        return n3 > 0 ? n3 * (n4 - n5) + n5 + insets.top + insets.bottom : 0;
    }

    protected int calculateTabAreaWidth(int n2, int n3, int n4) {
        Insets insets = this.getTabAreaInsets(n2);
        int n5 = this.getTabRunOverlay(n2);
        return n3 > 0 ? n3 * (n4 - n5) + n5 + insets.left + insets.right : 0;
    }

    protected int calculateTabHeight(int n2, int n3, int n4) {
        int n5 = 0;
        View view = this.getTextViewForTab(n3);
        n5 = view != null ? (n5 += (int)view.getPreferredSpan(1)) : (n5 += n4);
        Icon icon = this.getIconForTab(n3);
        Insets insets = this.getTabInsets(n2, n3);
        if (icon != null) {
            n5 = Math.max(n5, icon.getIconHeight());
        }
        return n5 += insets.top + insets.bottom + 2;
    }

    protected void selectAdjacentRunTab(int n2, int n3, int n4) {
        int n5;
        if (this.runCount < 2) {
            return;
        }
        Rectangle rectangle = this.rects[n3];
        switch (n2) {
            case 2: 
            case 4: {
                n5 = this.getTabAtLocation(rectangle.x + rectangle.width / 2 + n4, rectangle.y + rectangle.height / 2);
                break;
            }
            default: {
                n5 = this.getTabAtLocation(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2 + n4);
            }
        }
        if (n5 != -1) {
            while (!this.tabPane.isEnabledAt(n5) && n5 != n3) {
                n5 = this.getNextTabIndex(n5);
            }
            this.navigateTo(n5);
        }
    }

    protected int getTabRunOffset(int n2, int n3, int n4, boolean bl2) {
        int n5;
        int n6 = this.getRunForTab(n3, n4);
        switch (n2) {
            case 2: {
                if (n6 == 0) {
                    n5 = bl2 ? -(this.calculateTabAreaWidth(n2, this.runCount, this.maxTabWidth) - this.maxTabWidth) : -this.maxTabWidth;
                    break;
                }
                if (n6 == this.runCount - 1) {
                    n5 = bl2 ? this.maxTabWidth : this.calculateTabAreaWidth(n2, this.runCount, this.maxTabWidth) - this.maxTabWidth;
                    break;
                }
                n5 = bl2 ? this.maxTabWidth : -this.maxTabWidth;
                break;
            }
            case 4: {
                if (n6 == 0) {
                    n5 = bl2 ? this.maxTabWidth : this.calculateTabAreaWidth(n2, this.runCount, this.maxTabWidth) - this.maxTabWidth;
                    break;
                }
                if (n6 == this.runCount - 1) {
                    n5 = bl2 ? -(this.calculateTabAreaWidth(n2, this.runCount, this.maxTabWidth) - this.maxTabWidth) : -this.maxTabWidth;
                    break;
                }
                n5 = bl2 ? this.maxTabWidth : -this.maxTabWidth;
                break;
            }
            case 3: {
                if (n6 == 0) {
                    n5 = bl2 ? this.maxTabHeight : this.calculateTabAreaHeight(n2, this.runCount, this.maxTabHeight) - this.maxTabHeight;
                    break;
                }
                if (n6 == this.runCount - 1) {
                    n5 = bl2 ? -(this.calculateTabAreaHeight(n2, this.runCount, this.maxTabHeight) - this.maxTabHeight) : -this.maxTabHeight;
                    break;
                }
                n5 = bl2 ? this.maxTabHeight : -this.maxTabHeight;
                break;
            }
            default: {
                n5 = n6 == 0 ? (bl2 ? -(this.calculateTabAreaHeight(n2, this.runCount, this.maxTabHeight) - this.maxTabHeight) : -this.maxTabHeight) : (n6 == this.runCount - 1 ? (bl2 ? this.maxTabHeight : this.calculateTabAreaHeight(n2, this.runCount, this.maxTabHeight) - this.maxTabHeight) : (bl2 ? this.maxTabHeight : -this.maxTabHeight));
            }
        }
        return n5;
    }

    protected int getTabLabelShiftX(int n2, int n3, boolean bl2) {
        Rectangle rectangle = this.rects[n3];
        int n4 = 0;
        switch (n2) {
            case 2: {
                n4 = bl2 ? -1 : 1;
                break;
            }
            case 4: {
                n4 = bl2 ? 1 : -1;
                break;
            }
            default: {
                n4 = rectangle.width % 2;
            }
        }
        return n4;
    }

    protected int getTabLabelShiftY(int n2, int n3, boolean bl2) {
        Rectangle rectangle = this.rects[n3];
        int n4 = 0;
        switch (n2) {
            case 3: {
                n4 = bl2 ? 1 : -1;
                break;
            }
            case 2: 
            case 4: {
                n4 = rectangle.height % 2;
                break;
            }
            default: {
                n4 = bl2 ? -1 : 1;
            }
        }
        return n4;
    }

    static int access$2700(SynthTabbedPaneUI synthTabbedPaneUI) {
        return synthTabbedPaneUI.focusIndex;
    }

    static void access$2300(SynthTabbedPaneUI synthTabbedPaneUI) {
        synthTabbedPaneUI.updateMnemonics();
    }

    static boolean access$1700(SynthTabbedPaneUI synthTabbedPaneUI) {
        return synthTabbedPaneUI.scrollableTabLayoutEnabled();
    }

    static void access$1900(SynthTabbedPaneUI synthTabbedPaneUI, int n2) {
        synthTabbedPaneUI.setMouseOverTab(n2);
    }

    static int access$2000(SynthTabbedPaneUI synthTabbedPaneUI, int n2, int n3) {
        return synthTabbedPaneUI.getClosestTab(n2, n3);
    }

    static int access$2600(SynthTabbedPaneUI synthTabbedPaneUI, int n2, int n3) {
        return synthTabbedPaneUI.getTabAtLocation(n2, n3);
    }

    static void access$2800(SynthTabbedPaneUI synthTabbedPaneUI, int n2, int n3) {
        synthTabbedPaneUI.updateMouseOver(n2, n3);
    }

    protected Component getVisibleComponent() {
        return this.visibleComponent;
    }

    protected void setVisibleComponent(Component component) {
        if (this.visibleComponent != null && this.visibleComponent != component && this.visibleComponent.getParent() == this.tabPane) {
            this.visibleComponent.setVisible(false);
        }
        if (component != null && !component.isVisible()) {
            component.setVisible(true);
        }
        this.visibleComponent = component;
    }

    protected FontMetrics getFontMetrics() {
        return this.getFontMetrics(this.tabContext.getStyle().getFont(this.tabContext));
    }

    protected int calculateTabWidth(int n2, int n3, FontMetrics fontMetrics) {
        View view;
        Icon icon = this.getIconForTab(n3);
        Insets insets = this.getTabInsets(n2, n3);
        int n4 = insets.left + insets.right + 3;
        if (icon != null) {
            n4 += icon.getIconWidth() + this.getTextIconGap();
        }
        if ((view = this.getTextViewForTab(n3)) != null) {
            n4 += (int)view.getPreferredSpan(0);
        } else {
            String string = this.tabPane.getTitleAt(n3);
            n4 += this.tabContext.getStyle().getSynthGraphics(this.tabContext).computeStringWidth(this.tabContext, fontMetrics.getFont(), fontMetrics, string);
        }
        return n4;
    }

    protected Insets getContentBorderInsets(int n2) {
        return this.tabContentContext.getStyle().getInsets(this.tabContentContext, null);
    }

    protected Insets getSelectedTabPadInsets(int n2) {
        Insets insets = (Insets)this.tabContext.getStyle().get(this.tabContext, "selectedTabPadInsets");
        if (insets == null) {
            return new Insets(0, 0, 0, 0);
        }
        Insets insets2 = new Insets(0, 0, 0, 0);
        SynthTabbedPaneUI.rotateInsets(insets, new Insets(0, 0, 0, 0), n2);
        return insets2;
    }

    protected Insets getTabAreaInsets(int n2) {
        return this.tabAreaContext.getStyle().getInsets(this.tabAreaContext, null);
    }

    protected Insets getTabInsets(int n2, int n3) {
        this.tabContext.update(n3, false, this.mouseIndex == n3, this.focusIndex == n3);
        return this.tabContext.getStyle().getInsets(this.tabContext, null);
    }

    protected LayoutManager createLayoutManager() {
        if (this.tabPane.getTabLayoutPolicy() == 1) {
            return new TabbedPaneScrollLayout(this, null);
        }
        return new TabbedPaneLayout(this);
    }

    protected FocusListener createFocusListener() {
        return new FocusHandler(this);
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler(this);
    }

    private Vector createHTMLVector() {
        Vector vector = new Vector();
        int n2 = this.tabPane.getTabCount();
        if (n2 > 0) {
            for (int i2 = 0; i2 < n2; ++i2) {
                String string = this.tabPane.getTitleAt(i2);
                if (BasicHTML.isHTMLString(string)) {
                    vector.addElement(BasicHTML.createHTMLView(this.tabPane, string));
                    continue;
                }
                vector.addElement(null);
            }
        }
        return vector;
    }

    public static void loadActionMap(ActionMap actionMap) {
        actionMap.put("navigateNext", new NextAction(null));
        actionMap.put("navigatePrevious", new PreviousAction(null));
        actionMap.put("navigateRight", new RightAction(null));
        actionMap.put("navigateLeft", new LeftAction(null));
        actionMap.put("navigateUp", new UpAction(null));
        actionMap.put("navigateDown", new DownAction(null));
        actionMap.put("navigatePageUp", new PageUpAction(null));
        actionMap.put("navigatePageDown", new PageDownAction(null));
        actionMap.put("requestFocus", new RequestFocusAction(null));
        actionMap.put("requestFocusForVisibleComponent", new RequestFocusForVisibleAction(null));
        actionMap.put("setSelectedIndex", new SetSelectedIndexAction(null));
        actionMap.put("selectTabWithFocus", new SelectFocusIndexAction(null));
        actionMap.put("scrollTabsForwardAction", scrollTabsForwardAction);
        actionMap.put("scrollTabsBackwardAction", scrollTabsBackwardAction);
    }

    protected Icon getIconForTab(int n2) {
        return !this.tabPane.isEnabled() || !this.tabPane.isEnabledAt(n2) ? this.tabPane.getDisabledIconAt(n2) : this.tabPane.getIconAt(n2);
    }

    InputMap getInputMap(int n2) {
        SynthContext synthContext = this.getContext((JComponent)this.tabPane, 1);
        InputMap inputMap = null;
        if (n2 == 1) {
            inputMap = (InputMap)synthContext.getStyle().get(synthContext, "TabbedPane.ancestorInputMap");
        } else if (n2 == 0) {
            inputMap = (InputMap)synthContext.getStyle().get(synthContext, "TabbedPane.focusInputMap");
        }
        synthContext.dispose();
        return inputMap;
    }

    private int getComponentState(JComponent jComponent) {
        return SynthLookAndFeel.getComponentState(jComponent);
    }

    public void installUI(JComponent jComponent) {
        this.tabPane = (JTabbedPane)jComponent;
        jComponent.setLayout(this.createLayoutManager());
        this.installComponents();
        this.installDefaults();
        this.installListeners();
        this.installKeyboardActions();
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallKeyboardActions();
        this.uninstallListeners();
        this.uninstallDefaults();
        this.uninstallComponents();
        jComponent.setLayout(null);
        this.tabPane = null;
    }

    public int getTabRunCount(JTabbedPane jTabbedPane) {
        this.ensureCurrentLayout();
        return this.runCount;
    }

    private void fetchStyle(JTabbedPane jTabbedPane) {
        SynthContext synthContext = this.getContext((JComponent)jTabbedPane, 1);
        SynthStyle synthStyle = this.style;
        this.style = SynthLookAndFeel.updateStyle(synthContext, this);
        if (this.style != synthStyle) {
            this.tabRunOverlay = 0;
            Integer n2 = (Integer)synthContext.getStyle().get(synthContext, "tabRunOverlay");
            if (n2 != null) {
                this.tabRunOverlay = n2;
            }
            this.selectionFollowsFocus = synthContext.getStyle().getBoolean(synthContext, "TabbedPane.selectionFollowsFocus", true);
        }
        synthContext.dispose();
        if (this.tabContext != null) {
            this.tabContext.dispose();
        }
        this.tabContext = (TabContext)this.getContext(jTabbedPane, Region.TABBED_PANE_TAB, 1);
        this.tabStyle = SynthLookAndFeel.updateStyle(this.tabContext, this);
        if (this.tabAreaContext != null) {
            this.tabAreaContext.dispose();
        }
        this.tabAreaContext = this.getContext(jTabbedPane, Region.TABBED_PANE_TAB_AREA, 1);
        this.tabAreaStyle = SynthLookAndFeel.updateStyle(this.tabAreaContext, this);
        if (this.tabContentContext != null) {
            this.tabContentContext.dispose();
        }
        this.tabContentContext = this.getContext(jTabbedPane, Region.TABBED_PANE_CONTENT, 1);
        this.tabContentStyle = SynthLookAndFeel.updateStyle(this.tabContentContext, this);
    }

    public int tabForCoordinate(JTabbedPane jTabbedPane, int n2, int n3) {
        this.ensureCurrentLayout();
        Point point = new Point(n2, n3);
        if (this.scrollableTabLayoutEnabled()) {
            this.translatePointToTabPanel(n2, n3, point);
        }
        int n4 = this.tabPane.getTabCount();
        for (int i2 = 0; i2 < n4; ++i2) {
            if (!this.rects[i2].contains(point.x, point.y)) continue;
            return i2;
        }
        return -1;
    }

    protected ChangeListener createChangeListener() {
        return new TabSelectionHandler(this);
    }

    protected MouseInputListener createMouseInputListener() {
        return new MouseHandler(this);
    }

    protected View getTextViewForTab(int n2) {
        if (this.htmlViews != null) {
            return (View)this.htmlViews.elementAt(n2);
        }
        return null;
    }

    private Region getRegion(JComponent jComponent) {
        return SynthLookAndFeel.getRegion(jComponent);
    }

    static SynthContext access$2100(SynthTabbedPaneUI synthTabbedPaneUI) {
        return synthTabbedPaneUI.tabAreaContext;
    }

    public SynthContext getContext(JComponent jComponent) {
        return this.getContext(jComponent, this.getComponentState(jComponent));
    }

    public SynthContext getContext(JComponent jComponent, int n2) {
        return SynthContext.getContext(class$com$sun$java$swing$plaf$gtk$SynthContext == null ? (class$com$sun$java$swing$plaf$gtk$SynthContext = SynthTabbedPaneUI.class$("com.sun.java.swing.plaf.gtk.SynthContext")) : class$com$sun$java$swing$plaf$gtk$SynthContext, jComponent, SynthLookAndFeel.getRegion(jComponent), this.style, n2);
    }

    static ScrollableTabSupport access$1800(SynthTabbedPaneUI synthTabbedPaneUI) {
        return synthTabbedPaneUI.tabScroller;
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return null;
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return null;
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        return null;
    }

    protected FontMetrics getFontMetrics(Font font) {
        return Toolkit.getDefaultToolkit().getFontMetrics(font);
    }

    protected void paint(SynthContext synthContext, Graphics graphics) {
        int n2 = this.tabPane.getTabCount();
        if (this.tabCount != n2) {
            this.tabCount = n2;
            this.updateMnemonics();
        }
        int n3 = this.tabPane.getSelectedIndex();
        int n4 = this.tabPane.getTabPlacement();
        this.ensureCurrentLayout();
        if (!this.scrollableTabLayoutEnabled()) {
            Insets insets = this.tabPane.getInsets();
            int n5 = insets.left;
            int n6 = insets.top;
            int n7 = this.tabPane.getWidth() - insets.left - insets.right;
            int n8 = this.tabPane.getHeight() - insets.top - insets.bottom;
            switch (n4) {
                case 2: {
                    n7 = this.calculateTabAreaWidth(n4, this.runCount, this.maxTabWidth);
                    break;
                }
                case 4: {
                    int n9 = this.calculateTabAreaWidth(n4, this.runCount, this.maxTabWidth);
                    n5 = n5 + n7 - n9;
                    n7 = n9;
                    break;
                }
                case 3: {
                    int n10 = this.calculateTabAreaHeight(n4, this.runCount, this.maxTabHeight);
                    n6 = n6 + n8 - n10;
                    n8 = n10;
                    break;
                }
                default: {
                    n8 = this.calculateTabAreaHeight(n4, this.runCount, this.maxTabHeight);
                }
            }
            this.paintTabArea(this.tabAreaContext, graphics, n4, n3, new Rectangle(n5, n6, n7, n8));
        }
        this.paintContentBorder(this.tabContentContext, graphics, n4, n3);
    }

    protected void paintContentBorder(SynthContext synthContext, Graphics graphics, int n2, int n3) {
        int n4 = this.tabPane.getWidth();
        int n5 = this.tabPane.getHeight();
        Insets insets = this.tabPane.getInsets();
        int n6 = insets.left;
        int n7 = insets.top;
        int n8 = n4 - insets.right - insets.left;
        int n9 = n5 - insets.top - insets.bottom;
        switch (n2) {
            case 2: {
                n8 -= (n6 += this.calculateTabAreaWidth(n2, this.runCount, this.maxTabWidth)) - insets.left;
                break;
            }
            case 4: {
                n8 -= this.calculateTabAreaWidth(n2, this.runCount, this.maxTabWidth);
                break;
            }
            case 3: {
                n9 -= this.calculateTabAreaHeight(n2, this.runCount, this.maxTabHeight);
                break;
            }
            default: {
                n9 -= (n7 += this.calculateTabAreaHeight(n2, this.runCount, this.maxTabHeight)) - insets.top;
            }
        }
        SynthLookAndFeel.updateSubregion(synthContext, graphics, new Rectangle(n6, n7, n8, n9));
    }

    protected static void rotateInsets(Insets insets, Insets insets2, int n2) {
        switch (n2) {
            case 2: {
                insets2.top = insets.left;
                insets2.left = insets.top;
                insets2.bottom = insets.right;
                insets2.right = insets.bottom;
                break;
            }
            case 3: {
                insets2.top = insets.bottom;
                insets2.left = insets.left;
                insets2.bottom = insets.top;
                insets2.right = insets.right;
                break;
            }
            case 4: {
                insets2.top = insets.left;
                insets2.left = insets.bottom;
                insets2.bottom = insets.right;
                insets2.right = insets.top;
                break;
            }
            default: {
                insets2.top = insets.top;
                insets2.left = insets.left;
                insets2.bottom = insets.bottom;
                insets2.right = insets.right;
            }
        }
    }

    private Point translatePointToTabPanel(int n2, int n3, Point point) {
        Point point2 = this.tabScroller.viewport.getLocation();
        Point point3 = this.tabScroller.viewport.getViewPosition();
        point.x = n2 + point2.x + point3.x;
        point.y = n3 + point2.y + point3.y;
        return point;
    }

    protected Rectangle getTabBounds(int n2, Rectangle rectangle) {
        rectangle.width = this.rects[n2].width;
        rectangle.height = this.rects[n2].height;
        if (this.scrollableTabLayoutEnabled()) {
            Point point = this.tabScroller.viewport.getLocation();
            Point point2 = this.tabScroller.viewport.getViewPosition();
            rectangle.x = this.rects[n2].x - point.x - point2.x;
            rectangle.y = this.rects[n2].y - point.y - point2.y;
        } else {
            rectangle.x = this.rects[n2].x;
            rectangle.y = this.rects[n2].y;
        }
        return rectangle;
    }

    public Rectangle getTabBounds(JTabbedPane jTabbedPane, int n2) {
        this.ensureCurrentLayout();
        Rectangle rectangle = new Rectangle();
        return this.getTabBounds(n2, rectangle);
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    static Hashtable access$1600(SynthTabbedPaneUI synthTabbedPaneUI) {
        return synthTabbedPaneUI.mnemonicToIndexMap;
    }

    static Vector access$2400(SynthTabbedPaneUI synthTabbedPaneUI) {
        return synthTabbedPaneUI.htmlViews;
    }

    static Vector access$2500(SynthTabbedPaneUI synthTabbedPaneUI) {
        return synthTabbedPaneUI.createHTMLVector();
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    public void update(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        SynthLookAndFeel.update(synthContext, graphics);
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    static void access$2200(SynthTabbedPaneUI synthTabbedPaneUI, JTabbedPane jTabbedPane) {
        synthTabbedPaneUI.fetchStyle(jTabbedPane);
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new SynthTabbedPaneUI();
    }

    public SynthContext getContext(JComponent jComponent, Region region) {
        return this.getContext(jComponent, region, this.getComponentState(jComponent));
    }

    private SynthContext getContext(JComponent jComponent, Region region, int n2) {
        Class clazz;
        SynthStyle synthStyle = null;
        Class clazz2 = clazz = class$com$sun$java$swing$plaf$gtk$SynthContext == null ? (class$com$sun$java$swing$plaf$gtk$SynthContext = SynthTabbedPaneUI.class$("com.sun.java.swing.plaf.gtk.SynthContext")) : class$com$sun$java$swing$plaf$gtk$SynthContext;
        if (region == Region.TABBED_PANE_TAB) {
            synthStyle = this.tabStyle;
            clazz = class$com$sun$java$swing$plaf$gtk$TabContext == null ? (class$com$sun$java$swing$plaf$gtk$TabContext = SynthTabbedPaneUI.class$("com.sun.java.swing.plaf.gtk.TabContext")) : class$com$sun$java$swing$plaf$gtk$TabContext;
        } else if (region == Region.TABBED_PANE_TAB_AREA) {
            synthStyle = this.tabAreaStyle;
        } else if (region == Region.TABBED_PANE_CONTENT) {
            synthStyle = this.tabContentStyle;
        }
        return SynthContext.getContext(clazz, jComponent, region, synthStyle, n2);
    }

    protected void paintTabArea(SynthContext synthContext, Graphics graphics, int n2, int n3, Rectangle rectangle) {
        SynthLookAndFeel.updateSubregion(synthContext, graphics, rectangle);
        int n4 = this.tabPane.getTabCount();
        Rectangle rectangle2 = new Rectangle();
        Rectangle rectangle3 = new Rectangle();
        Rectangle rectangle4 = graphics.getClipBounds();
        for (int i2 = this.runCount - 1; i2 >= 0; --i2) {
            int n5 = this.tabRuns[i2];
            int n6 = this.tabRuns[i2 == this.runCount - 1 ? 0 : i2 + 1];
            int n7 = n6 != 0 ? n6 - 1 : n4 - 1;
            for (int i3 = n5; i3 <= n7; ++i3) {
                if (!this.rects[i3].intersects(rectangle4) || n3 == i3) continue;
                this.paintTab(this.tabContext, graphics, n2, this.rects, i3, rectangle2, rectangle3);
            }
        }
        if (n3 >= 0 && this.rects[n3].intersects(rectangle4)) {
            this.paintTab(this.tabContext, graphics, n2, this.rects, n3, rectangle2, rectangle3);
        }
    }

    protected void paintIcon(Graphics graphics, int n2, int n3, Icon icon, Rectangle rectangle, boolean bl2) {
        if (icon != null) {
            icon.paintIcon(this.tabPane, graphics, rectangle.x, rectangle.y);
        }
    }

    static Vector access$2402(SynthTabbedPaneUI synthTabbedPaneUI, Vector vector) {
        synthTabbedPaneUI.htmlViews = vector;
        return synthTabbedPaneUI.htmlViews;
    }

    protected void paintTab(SynthContext synthContext, Graphics graphics, int n2, Rectangle[] rectangleArray, int n3, Rectangle rectangle, Rectangle rectangle2) {
        Rectangle rectangle3 = rectangleArray[n3];
        int n4 = this.tabPane.getSelectedIndex();
        boolean bl2 = n4 == n3;
        this.tabContext.update(n3, bl2, this.mouseIndex == n3, this.focusIndex == n3);
        SynthLookAndFeel.updateSubregion(synthContext, graphics, rectangle3);
        String string = this.tabPane.getTitleAt(n3);
        Font font = synthContext.getStyle().getFont(synthContext);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        Icon icon = this.getIconForTab(n3);
        this.layoutLabel(synthContext, n2, fontMetrics, n3, string, icon, rectangle3, rectangle, rectangle2, bl2);
        this.paintText(synthContext, graphics, n2, font, fontMetrics, n3, string, rectangle2, bl2);
        this.paintIcon(graphics, n2, n3, icon, rectangle, bl2);
    }

    protected void paintText(SynthContext synthContext, Graphics graphics, int n2, Font font, FontMetrics fontMetrics, int n3, String string, Rectangle rectangle, boolean bl2) {
        graphics.setFont(font);
        View view = this.getTextViewForTab(n3);
        if (view != null) {
            view.paint(graphics, rectangle);
        } else {
            int n4 = this.tabPane.getDisplayedMnemonicIndexAt(n3);
            graphics.setColor(synthContext.getStyle().getColor(synthContext, ColorType.TEXT_FOREGROUND));
            synthContext.getStyle().getSynthGraphics(synthContext).paintText(synthContext, graphics, string, rectangle, n4);
        }
    }

    protected void layoutLabel(SynthContext synthContext, int n2, FontMetrics fontMetrics, int n3, String string, Icon icon, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, boolean bl2) {
        View view = this.getTextViewForTab(n3);
        if (view != null) {
            this.tabPane.putClientProperty("html", view);
        }
        rectangle2.y = 0;
        rectangle2.x = 0;
        rectangle3.y = 0;
        rectangle3.x = 0;
        synthContext.getStyle().getSynthGraphics(synthContext).layoutText(synthContext, fontMetrics, string, icon, 0, 0, 10, 11, rectangle, rectangle2, rectangle3, this.getTextIconGap());
        this.tabPane.putClientProperty("html", null);
        int n4 = this.getTabLabelShiftX(n2, n3, bl2);
        int n5 = this.getTabLabelShiftY(n2, n3, bl2);
        rectangle2.x += n4;
        rectangle2.y += n5;
        rectangle3.x += n4;
        rectangle3.y += n5;
    }

    static class 1 {
    }

    private class ContainerHandler
    implements ContainerListener {
        private final SynthTabbedPaneUI this$0;

        private ContainerHandler(SynthTabbedPaneUI synthTabbedPaneUI) {
            this.this$0 = synthTabbedPaneUI;
        }

        public void componentAdded(ContainerEvent containerEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)containerEvent.getContainer();
            Component component = containerEvent.getChild();
            if (component instanceof UIResource) {
                return;
            }
            int n2 = jTabbedPane.indexOfComponent(component);
            String string = jTabbedPane.getTitleAt(n2);
            boolean bl2 = BasicHTML.isHTMLString(string);
            if (bl2) {
                if (SynthTabbedPaneUI.access$2400(this.this$0) == null) {
                    SynthTabbedPaneUI.access$2402(this.this$0, SynthTabbedPaneUI.access$2500(this.this$0));
                } else {
                    View view = BasicHTML.createHTMLView(jTabbedPane, string);
                    SynthTabbedPaneUI.access$2400(this.this$0).insertElementAt(view, n2);
                }
            } else if (SynthTabbedPaneUI.access$2400(this.this$0) != null) {
                SynthTabbedPaneUI.access$2400(this.this$0).insertElementAt(null, n2);
            }
        }

        public void componentRemoved(ContainerEvent containerEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)containerEvent.getContainer();
            Component component = containerEvent.getChild();
            if (component instanceof UIResource) {
                return;
            }
            Integer n2 = (Integer)jTabbedPane.getClientProperty("__index_to_remove__");
            if (n2 != null) {
                int n3 = n2;
                if (SynthTabbedPaneUI.access$2400(this.this$0) != null && SynthTabbedPaneUI.access$2400(this.this$0).size() >= n3) {
                    SynthTabbedPaneUI.access$2400(this.this$0).removeElementAt(n3);
                }
            }
        }

        ContainerHandler(SynthTabbedPaneUI synthTabbedPaneUI, 1 var2_2) {
            this(synthTabbedPaneUI);
        }
    }

    private static class DownAction
    extends AbstractAction {
        private DownAction() {
        }

        DownAction(1 var1_1) {
            this();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)actionEvent.getSource();
            SynthTabbedPaneUI synthTabbedPaneUI = (SynthTabbedPaneUI)jTabbedPane.getUI();
            synthTabbedPaneUI.navigateSelectedTab(5);
        }
    }

    class FocusHandler
    extends FocusAdapter {
        private final SynthTabbedPaneUI this$0;

        FocusHandler(SynthTabbedPaneUI synthTabbedPaneUI) {
            this.this$0 = synthTabbedPaneUI;
        }

        public void focusGained(FocusEvent focusEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)focusEvent.getSource();
            int n2 = jTabbedPane.getTabCount();
            if (SynthTabbedPaneUI.access$2700(this.this$0) == -1) {
                this.this$0.setFocusIndex(jTabbedPane.getSelectedIndex());
            }
            if (SynthTabbedPaneUI.access$2700(this.this$0) != -1 && n2 > 0 && n2 == this.this$0.rects.length) {
                jTabbedPane.repaint(this.this$0.getTabBounds(jTabbedPane, SynthTabbedPaneUI.access$2700(this.this$0)));
            }
        }

        public void focusLost(FocusEvent focusEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)focusEvent.getSource();
            int n2 = jTabbedPane.getTabCount();
            if (SynthTabbedPaneUI.access$2700(this.this$0) != -1 && n2 > 0 && n2 == this.this$0.rects.length) {
                jTabbedPane.repaint(this.this$0.getTabBounds(jTabbedPane, SynthTabbedPaneUI.access$2700(this.this$0)));
                this.this$0.setFocusIndex(-1);
            }
        }
    }

    private static class LeftAction
    extends AbstractAction {
        private LeftAction() {
        }

        LeftAction(1 var1_1) {
            this();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)actionEvent.getSource();
            SynthTabbedPaneUI synthTabbedPaneUI = (SynthTabbedPaneUI)jTabbedPane.getUI();
            synthTabbedPaneUI.navigateSelectedTab(7);
        }
    }

    class MouseHandler
    extends MouseInputAdapter {
        private final SynthTabbedPaneUI this$0;

        MouseHandler(SynthTabbedPaneUI synthTabbedPaneUI) {
            this.this$0 = synthTabbedPaneUI;
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            SynthTabbedPaneUI.access$2800(this.this$0, mouseEvent.getX(), mouseEvent.getY());
        }

        public void mouseExited(MouseEvent mouseEvent) {
            SynthTabbedPaneUI.access$1900(this.this$0, -1);
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            SynthTabbedPaneUI.access$2800(this.this$0, mouseEvent.getX(), mouseEvent.getY());
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (!this.this$0.tabPane.isEnabled()) {
                return;
            }
            int n2 = SynthTabbedPaneUI.access$2600(this.this$0, mouseEvent.getX(), mouseEvent.getY());
            if (n2 >= 0 && this.this$0.tabPane.isEnabledAt(n2)) {
                if (n2 != this.this$0.tabPane.getSelectedIndex()) {
                    this.this$0.tabPane.setSelectedIndex(n2);
                }
                if (this.this$0.tabPane.isRequestFocusEnabled() && n2 != SynthTabbedPaneUI.access$2700(this.this$0)) {
                    this.this$0.tabPane.requestFocus();
                    int n3 = SynthTabbedPaneUI.access$2700(this.this$0);
                    this.this$0.setFocusIndex(n2);
                    this.this$0.tabPane.repaint(this.this$0.getTabBounds(this.this$0.tabPane, SynthTabbedPaneUI.access$2700(this.this$0)));
                    if (n3 != -1) {
                        this.this$0.tabPane.repaint(this.this$0.getTabBounds(this.this$0.tabPane, n3));
                    }
                }
            }
        }
    }

    private static class NextAction
    extends AbstractAction {
        private NextAction() {
        }

        NextAction(1 var1_1) {
            this();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)actionEvent.getSource();
            SynthTabbedPaneUI synthTabbedPaneUI = (SynthTabbedPaneUI)jTabbedPane.getUI();
            synthTabbedPaneUI.navigateSelectedTab(12);
        }
    }

    private static class PageDownAction
    extends AbstractAction {
        private PageDownAction() {
        }

        PageDownAction(1 var1_1) {
            this();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)actionEvent.getSource();
            SynthTabbedPaneUI synthTabbedPaneUI = (SynthTabbedPaneUI)jTabbedPane.getUI();
            int n2 = jTabbedPane.getTabPlacement();
            if (n2 == 1 || n2 == 3) {
                synthTabbedPaneUI.navigateSelectedTab(3);
            } else {
                synthTabbedPaneUI.navigateSelectedTab(5);
            }
        }
    }

    private static class PageUpAction
    extends AbstractAction {
        private PageUpAction() {
        }

        PageUpAction(1 var1_1) {
            this();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)actionEvent.getSource();
            SynthTabbedPaneUI synthTabbedPaneUI = (SynthTabbedPaneUI)jTabbedPane.getUI();
            int n2 = jTabbedPane.getTabPlacement();
            if (n2 == 1 || n2 == 3) {
                synthTabbedPaneUI.navigateSelectedTab(7);
            } else {
                synthTabbedPaneUI.navigateSelectedTab(1);
            }
        }
    }

    private static class PreviousAction
    extends AbstractAction {
        private PreviousAction() {
        }

        PreviousAction(1 var1_1) {
            this();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)actionEvent.getSource();
            SynthTabbedPaneUI synthTabbedPaneUI = (SynthTabbedPaneUI)jTabbedPane.getUI();
            synthTabbedPaneUI.navigateSelectedTab(13);
        }
    }

    class PropertyChangeHandler
    implements PropertyChangeListener {
        private final SynthTabbedPaneUI this$0;

        PropertyChangeHandler(SynthTabbedPaneUI synthTabbedPaneUI) {
            this.this$0 = synthTabbedPaneUI;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)propertyChangeEvent.getSource();
            String string = propertyChangeEvent.getPropertyName();
            if (SynthLookAndFeel.shouldUpdateStyle(propertyChangeEvent)) {
                SynthTabbedPaneUI.access$2200(this.this$0, jTabbedPane);
            }
            if ("mnemonicAt".equals(string)) {
                SynthTabbedPaneUI.access$2300(this.this$0);
                jTabbedPane.repaint();
            } else if ("displayedMnemonicIndexAt".equals(string)) {
                jTabbedPane.repaint();
            } else if (string.equals("indexForTitle")) {
                int n2 = (Integer)propertyChangeEvent.getNewValue();
                String string2 = this.this$0.tabPane.getTitleAt(n2);
                if (BasicHTML.isHTMLString(string2)) {
                    if (SynthTabbedPaneUI.access$2400(this.this$0) == null) {
                        SynthTabbedPaneUI.access$2402(this.this$0, SynthTabbedPaneUI.access$2500(this.this$0));
                    } else {
                        View view = BasicHTML.createHTMLView(this.this$0.tabPane, string2);
                        SynthTabbedPaneUI.access$2400(this.this$0).setElementAt(view, n2);
                    }
                } else if (SynthTabbedPaneUI.access$2400(this.this$0) != null && SynthTabbedPaneUI.access$2400(this.this$0).elementAt(n2) != null) {
                    SynthTabbedPaneUI.access$2400(this.this$0).setElementAt(null, n2);
                }
                SynthTabbedPaneUI.access$2300(this.this$0);
            } else if (string.equals("tabLayoutPolicy")) {
                this.this$0.uninstallUI(jTabbedPane);
                this.this$0.installUI(jTabbedPane);
            }
        }
    }

    private static class RequestFocusAction
    extends AbstractAction {
        private RequestFocusAction() {
        }

        RequestFocusAction(1 var1_1) {
            this();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)actionEvent.getSource();
            jTabbedPane.requestFocus();
        }
    }

    private static class RequestFocusForVisibleAction
    extends AbstractAction {
        private RequestFocusForVisibleAction() {
        }

        RequestFocusForVisibleAction(1 var1_1) {
            this();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)actionEvent.getSource();
            SynthTabbedPaneUI synthTabbedPaneUI = (SynthTabbedPaneUI)jTabbedPane.getUI();
            synthTabbedPaneUI.requestFocusForVisibleComponent();
        }
    }

    private static class RightAction
    extends AbstractAction {
        private RightAction() {
        }

        RightAction(1 var1_1) {
            this();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)actionEvent.getSource();
            SynthTabbedPaneUI synthTabbedPaneUI = (SynthTabbedPaneUI)jTabbedPane.getUI();
            synthTabbedPaneUI.navigateSelectedTab(3);
        }
    }

    private static class ScrollTabsBackwardAction
    extends AbstractAction {
        private ScrollTabsBackwardAction() {
        }

        ScrollTabsBackwardAction(1 var1_1) {
            this();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTabbedPane jTabbedPane = null;
            Object object = actionEvent.getSource();
            if (object instanceof JTabbedPane) {
                jTabbedPane = (JTabbedPane)object;
            } else if (object instanceof ScrollableTabButton) {
                jTabbedPane = (JTabbedPane)((ScrollableTabButton)object).getParent();
            } else {
                return;
            }
            SynthTabbedPaneUI synthTabbedPaneUI = (SynthTabbedPaneUI)jTabbedPane.getUI();
            if (SynthTabbedPaneUI.access$1700(synthTabbedPaneUI)) {
                SynthTabbedPaneUI.access$1800(synthTabbedPaneUI).scrollBackward(jTabbedPane.getTabPlacement());
            }
        }
    }

    private static class ScrollTabsForwardAction
    extends AbstractAction {
        private ScrollTabsForwardAction() {
        }

        ScrollTabsForwardAction(1 var1_1) {
            this();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTabbedPane jTabbedPane = null;
            Object object = actionEvent.getSource();
            if (object instanceof JTabbedPane) {
                jTabbedPane = (JTabbedPane)object;
            } else if (object instanceof ScrollableTabButton) {
                jTabbedPane = (JTabbedPane)((ScrollableTabButton)object).getParent();
            } else {
                return;
            }
            SynthTabbedPaneUI synthTabbedPaneUI = (SynthTabbedPaneUI)jTabbedPane.getUI();
            if (SynthTabbedPaneUI.access$1700(synthTabbedPaneUI)) {
                SynthTabbedPaneUI.access$1800(synthTabbedPaneUI).scrollForward(jTabbedPane.getTabPlacement());
            }
        }
    }

    private class ScrollableTabButton
    extends SynthArrowButton
    implements UIResource,
    SwingConstants {
        private final SynthTabbedPaneUI this$0;

        public boolean scrollsForward() {
            return this.getDirection() == 3 || this.getDirection() == 5;
        }

        public ScrollableTabButton(SynthTabbedPaneUI synthTabbedPaneUI, int n2) {
            this.this$0 = synthTabbedPaneUI;
            super(n2);
        }
    }

    private class ScrollableTabPanel
    extends JPanel
    implements UIResource {
        private final SynthTabbedPaneUI this$0;

        public ScrollableTabPanel(SynthTabbedPaneUI synthTabbedPaneUI) {
            this.this$0 = synthTabbedPaneUI;
            this.setLayout(null);
        }

        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            this.this$0.paintTabArea(SynthTabbedPaneUI.access$2100(this.this$0), graphics, this.this$0.tabPane.getTabPlacement(), this.this$0.tabPane.getSelectedIndex(), this.getBounds());
        }
    }

    private class ScrollableTabSupport
    implements ChangeListener {
        public ScrollableTabViewport viewport;
        public ScrollableTabPanel tabPanel;
        public ScrollableTabButton scrollForwardButton;
        public ScrollableTabButton scrollBackwardButton;
        public int leadingTabIndex;
        private Point tabViewPosition;
        private final SynthTabbedPaneUI this$0;

        public void scrollBackward(int n2) {
            if (this.leadingTabIndex == 0) {
                return;
            }
            this.setLeadingTabIndex(n2, this.leadingTabIndex - 1);
        }

        public void scrollForward(int n2) {
            Dimension dimension = this.viewport.getViewSize();
            Rectangle rectangle = this.viewport.getViewRect();
            if (n2 == 1 || n2 == 3 ? rectangle.width >= dimension.width - rectangle.x : rectangle.height >= dimension.height - rectangle.y) {
                return;
            }
            this.setLeadingTabIndex(n2, this.leadingTabIndex + 1);
        }

        public void setLeadingTabIndex(int n2, int n3) {
            this.leadingTabIndex = n3;
            Dimension dimension = this.viewport.getViewSize();
            Rectangle rectangle = this.viewport.getViewRect();
            switch (n2) {
                case 1: 
                case 3: {
                    int n4 = this.tabViewPosition.x = this.leadingTabIndex == 0 ? 0 : this.this$0.rects[this.leadingTabIndex].x;
                    if (dimension.width - this.tabViewPosition.x >= rectangle.width) break;
                    Dimension dimension2 = new Dimension(dimension.width - this.tabViewPosition.x, rectangle.height);
                    this.viewport.setExtentSize(dimension2);
                    break;
                }
                case 2: 
                case 4: {
                    int n5 = this.tabViewPosition.y = this.leadingTabIndex == 0 ? 0 : this.this$0.rects[this.leadingTabIndex].y;
                    if (dimension.height - this.tabViewPosition.y >= rectangle.height) break;
                    Dimension dimension3 = new Dimension(rectangle.width, dimension.height - this.tabViewPosition.y);
                    this.viewport.setExtentSize(dimension3);
                }
            }
            this.viewport.setViewPosition(this.tabViewPosition);
        }

        ScrollableTabSupport(SynthTabbedPaneUI synthTabbedPaneUI, int n2) {
            this.this$0 = synthTabbedPaneUI;
            this.tabViewPosition = new Point(0, 0);
            this.viewport = new ScrollableTabViewport(synthTabbedPaneUI);
            this.tabPanel = new ScrollableTabPanel(synthTabbedPaneUI);
            this.viewport.setView(this.tabPanel);
            this.viewport.addChangeListener(this);
            if (n2 == 1 || n2 == 3) {
                this.scrollForwardButton = new ScrollableTabButton(synthTabbedPaneUI, 3);
                this.scrollBackwardButton = new ScrollableTabButton(synthTabbedPaneUI, 7);
            } else {
                this.scrollForwardButton = new ScrollableTabButton(synthTabbedPaneUI, 5);
                this.scrollBackwardButton = new ScrollableTabButton(synthTabbedPaneUI, 1);
            }
        }

        public String toString() {
            return new String("viewport.viewSize=" + this.viewport.getViewSize() + "\n" + "viewport.viewRectangle=" + this.viewport.getViewRect() + "\n" + "leadingTabIndex=" + this.leadingTabIndex + "\n" + "tabViewPosition=" + this.tabViewPosition);
        }

        public void stateChanged(ChangeEvent changeEvent) {
            JViewport jViewport = (JViewport)changeEvent.getSource();
            int n2 = this.this$0.tabPane.getTabPlacement();
            int n3 = this.this$0.tabPane.getTabCount();
            Rectangle rectangle = jViewport.getBounds();
            Dimension dimension = jViewport.getViewSize();
            Rectangle rectangle2 = jViewport.getViewRect();
            this.leadingTabIndex = SynthTabbedPaneUI.access$2000(this.this$0, rectangle2.x, rectangle2.y);
            if (this.leadingTabIndex + 1 < n3) {
                switch (n2) {
                    case 1: 
                    case 3: {
                        if (this.this$0.rects[this.leadingTabIndex].x >= rectangle2.x) break;
                        ++this.leadingTabIndex;
                        break;
                    }
                    case 2: 
                    case 4: {
                        if (this.this$0.rects[this.leadingTabIndex].y >= rectangle2.y) break;
                        ++this.leadingTabIndex;
                    }
                }
            }
            Insets insets = this.this$0.getContentBorderInsets(n2);
            switch (n2) {
                case 2: {
                    this.this$0.tabPane.repaint(rectangle.x + rectangle.width, rectangle.y, insets.left, rectangle.height);
                    this.scrollBackwardButton.setEnabled(rectangle2.y > 0);
                    this.scrollForwardButton.setEnabled(this.leadingTabIndex < n3 - 1 && dimension.height - rectangle2.y > rectangle2.height);
                    break;
                }
                case 4: {
                    this.this$0.tabPane.repaint(rectangle.x - insets.right, rectangle.y, insets.right, rectangle.height);
                    this.scrollBackwardButton.setEnabled(rectangle2.y > 0);
                    this.scrollForwardButton.setEnabled(this.leadingTabIndex < n3 - 1 && dimension.height - rectangle2.y > rectangle2.height);
                    break;
                }
                case 3: {
                    this.this$0.tabPane.repaint(rectangle.x, rectangle.y - insets.bottom, rectangle.width, insets.bottom);
                    this.scrollBackwardButton.setEnabled(rectangle2.x > 0);
                    this.scrollForwardButton.setEnabled(this.leadingTabIndex < n3 - 1 && dimension.width - rectangle2.x > rectangle2.width);
                    break;
                }
                default: {
                    this.this$0.tabPane.repaint(rectangle.x, rectangle.y + rectangle.height, rectangle.width, insets.top);
                    this.scrollBackwardButton.setEnabled(rectangle2.x > 0);
                    this.scrollForwardButton.setEnabled(this.leadingTabIndex < n3 - 1 && dimension.width - rectangle2.x > rectangle2.width);
                }
            }
        }
    }

    private class ScrollableTabViewport
    extends JViewport
    implements UIResource {
        private final SynthTabbedPaneUI this$0;

        public ScrollableTabViewport(SynthTabbedPaneUI synthTabbedPaneUI) {
            this.this$0 = synthTabbedPaneUI;
            this.setScrollMode(0);
        }
    }

    private static class SelectFocusIndexAction
    extends AbstractAction {
        private SelectFocusIndexAction() {
        }

        SelectFocusIndexAction(1 var1_1) {
            this();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)actionEvent.getSource();
            SynthTabbedPaneUI synthTabbedPaneUI = (SynthTabbedPaneUI)jTabbedPane.getUI();
            int n2 = synthTabbedPaneUI.getFocusIndex();
            if (n2 != -1) {
                jTabbedPane.setSelectedIndex(n2);
            }
        }
    }

    private static class SetSelectedIndexAction
    extends AbstractAction {
        private SetSelectedIndexAction() {
        }

        SetSelectedIndexAction(1 var1_1) {
            this();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)actionEvent.getSource();
            if (jTabbedPane != null && jTabbedPane.getUI() instanceof SynthTabbedPaneUI) {
                SynthTabbedPaneUI synthTabbedPaneUI = (SynthTabbedPaneUI)jTabbedPane.getUI();
                String string = actionEvent.getActionCommand();
                if (string != null && string.length() > 0) {
                    Integer n2;
                    int n3 = actionEvent.getActionCommand().charAt(0);
                    if (n3 >= 97 && n3 <= 122) {
                        n3 -= 32;
                    }
                    if ((n2 = (Integer)SynthTabbedPaneUI.access$1600(synthTabbedPaneUI).get(new Integer(n3))) != null && jTabbedPane.isEnabledAt(n2)) {
                        jTabbedPane.setSelectedIndex(n2);
                    }
                }
            }
        }
    }

    class TabSelectionHandler
    implements ChangeListener {
        private final SynthTabbedPaneUI this$0;

        TabSelectionHandler(SynthTabbedPaneUI synthTabbedPaneUI) {
            this.this$0 = synthTabbedPaneUI;
        }

        public void stateChanged(ChangeEvent changeEvent) {
            int n2;
            JTabbedPane jTabbedPane = (JTabbedPane)changeEvent.getSource();
            jTabbedPane.revalidate();
            jTabbedPane.repaint();
            if (jTabbedPane.getTabLayoutPolicy() == 1 && (n2 = jTabbedPane.getSelectedIndex()) < this.this$0.rects.length && n2 != -1) {
                SynthTabbedPaneUI.access$1800((SynthTabbedPaneUI)this.this$0).tabPanel.scrollRectToVisible(this.this$0.rects[n2]);
            }
        }
    }

    class TabbedPaneLayout
    implements LayoutManager {
        private final SynthTabbedPaneUI this$0;

        public void calculateLayoutInfo() {
            int n2 = this.this$0.tabPane.getTabCount();
            this.this$0.assureRectsCreated(n2);
            this.calculateTabRects(this.this$0.tabPane.getTabPlacement(), n2);
        }

        protected int preferredTabAreaHeight(int n2, int n3) {
            FontMetrics fontMetrics = this.this$0.getFontMetrics();
            int n4 = this.this$0.tabPane.getTabCount();
            int n5 = 0;
            if (n4 > 0) {
                int n6 = 1;
                int n7 = 0;
                int n8 = this.this$0.calculateMaxTabHeight(n2);
                for (int i2 = 0; i2 < n4; ++i2) {
                    int n9 = this.this$0.calculateTabWidth(n2, i2, fontMetrics);
                    if (n7 != 0 && n7 + n9 > n3) {
                        ++n6;
                        n7 = 0;
                    }
                    n7 += n9;
                }
                n5 = this.this$0.calculateTabAreaHeight(n2, n6, n8);
            }
            return n5;
        }

        protected int preferredTabAreaWidth(int n2, int n3) {
            FontMetrics fontMetrics = this.this$0.getFontMetrics();
            int n4 = this.this$0.tabPane.getTabCount();
            int n5 = 0;
            if (n4 > 0) {
                int n6 = 1;
                int n7 = 0;
                int n8 = fontMetrics.getHeight();
                this.this$0.maxTabWidth = this.this$0.calculateMaxTabWidth(n2);
                for (int i2 = 0; i2 < n4; ++i2) {
                    int n9 = this.this$0.calculateTabHeight(n2, i2, n8);
                    if (n7 != 0 && n7 + n9 > n3) {
                        ++n6;
                        n7 = 0;
                    }
                    n7 += n9;
                }
                n5 = this.this$0.calculateTabAreaWidth(n2, n6, this.this$0.maxTabWidth);
            }
            return n5;
        }

        protected void calculateTabRects(int n2, int n3) {
            int n4;
            Rectangle rectangle;
            int n5;
            int n6;
            int n7;
            int n8;
            FontMetrics fontMetrics = this.this$0.getFontMetrics();
            Dimension dimension = this.this$0.tabPane.getSize();
            Insets insets = this.this$0.tabPane.getInsets();
            Insets insets2 = this.this$0.getTabAreaInsets(n2);
            int n9 = fontMetrics.getHeight();
            int n10 = this.this$0.tabPane.getSelectedIndex();
            boolean bl2 = n2 == 2 || n2 == 4;
            boolean bl3 = SynthLookAndFeel.isLeftToRight(this.this$0.tabPane);
            switch (n2) {
                case 2: {
                    this.this$0.maxTabWidth = this.this$0.calculateMaxTabWidth(n2);
                    n8 = insets.left + insets2.left;
                    n7 = insets.top + insets2.top;
                    n6 = dimension.height - (insets.bottom + insets2.bottom);
                    break;
                }
                case 4: {
                    this.this$0.maxTabWidth = this.this$0.calculateMaxTabWidth(n2);
                    n8 = dimension.width - insets.right - insets2.right - this.this$0.maxTabWidth;
                    n7 = insets.top + insets2.top;
                    n6 = dimension.height - (insets.bottom + insets2.bottom);
                    break;
                }
                case 3: {
                    this.this$0.maxTabHeight = this.this$0.calculateMaxTabHeight(n2);
                    n8 = insets.left + insets2.left;
                    n7 = dimension.height - insets.bottom - insets2.bottom - this.this$0.maxTabHeight;
                    n6 = dimension.width - (insets.right + insets2.right);
                    break;
                }
                default: {
                    this.this$0.maxTabHeight = this.this$0.calculateMaxTabHeight(n2);
                    n8 = insets.left + insets2.left;
                    n7 = insets.top + insets2.top;
                    n6 = dimension.width - (insets.right + insets2.right);
                }
            }
            int n11 = this.this$0.getTabRunOverlay(n2);
            this.this$0.runCount = 0;
            this.this$0.selectedRun = -1;
            if (n3 == 0) {
                return;
            }
            for (n5 = 0; n5 < n3; ++n5) {
                rectangle = this.this$0.rects[n5];
                if (!bl2) {
                    if (n5 > 0) {
                        rectangle.x = this.this$0.rects[n5 - 1].x + this.this$0.rects[n5 - 1].width;
                    } else {
                        this.this$0.tabRuns[0] = 0;
                        this.this$0.runCount = 1;
                        this.this$0.maxTabWidth = 0;
                        rectangle.x = n8;
                    }
                    rectangle.width = this.this$0.calculateTabWidth(n2, n5, fontMetrics);
                    this.this$0.maxTabWidth = Math.max(this.this$0.maxTabWidth, rectangle.width);
                    if (rectangle.x != 2 + insets.left && rectangle.x + rectangle.width > n6) {
                        if (this.this$0.runCount > this.this$0.tabRuns.length - 1) {
                            this.this$0.expandTabRunsArray();
                        }
                        this.this$0.tabRuns[this.this$0.runCount] = n5;
                        ++this.this$0.runCount;
                        rectangle.x = n8;
                    }
                    rectangle.y = n7;
                    rectangle.height = this.this$0.maxTabHeight;
                } else {
                    if (n5 > 0) {
                        rectangle.y = this.this$0.rects[n5 - 1].y + this.this$0.rects[n5 - 1].height;
                    } else {
                        this.this$0.tabRuns[0] = 0;
                        this.this$0.runCount = 1;
                        this.this$0.maxTabHeight = 0;
                        rectangle.y = n7;
                    }
                    rectangle.height = this.this$0.calculateTabHeight(n2, n5, n9);
                    this.this$0.maxTabHeight = Math.max(this.this$0.maxTabHeight, rectangle.height);
                    if (rectangle.y != 2 + insets.top && rectangle.y + rectangle.height > n6) {
                        if (this.this$0.runCount > this.this$0.tabRuns.length - 1) {
                            this.this$0.expandTabRunsArray();
                        }
                        this.this$0.tabRuns[this.this$0.runCount] = n5;
                        ++this.this$0.runCount;
                        rectangle.y = n7;
                    }
                    rectangle.x = n8;
                    rectangle.width = this.this$0.maxTabWidth;
                }
                if (n5 != n10) continue;
                this.this$0.selectedRun = this.this$0.runCount - 1;
            }
            if (this.this$0.runCount > 1) {
                this.normalizeTabRuns(n2, n3, bl2 ? n7 : n8, n6);
                this.this$0.selectedRun = this.this$0.getRunForTab(n3, n10);
                if (this.this$0.shouldRotateTabRuns(n2)) {
                    this.rotateTabRuns(n2, this.this$0.selectedRun);
                }
            }
            for (n5 = this.this$0.runCount - 1; n5 >= 0; --n5) {
                int n12;
                int n13;
                n4 = this.this$0.tabRuns[n5];
                int n14 = this.this$0.tabRuns[n5 == this.this$0.runCount - 1 ? 0 : n5 + 1];
                int n15 = n13 = n14 != 0 ? n14 - 1 : n3 - 1;
                if (!bl2) {
                    for (n12 = n4; n12 <= n13; ++n12) {
                        rectangle = this.this$0.rects[n12];
                        rectangle.y = n7;
                        rectangle.x += this.this$0.getTabRunIndent(n2, n5);
                    }
                    if (this.this$0.shouldPadTabRun(n2, n5)) {
                        this.padTabRun(n2, n4, n13, n6);
                    }
                    if (n2 == 3) {
                        n7 -= this.this$0.maxTabHeight - n11;
                        continue;
                    }
                    n7 += this.this$0.maxTabHeight - n11;
                    continue;
                }
                for (n12 = n4; n12 <= n13; ++n12) {
                    rectangle = this.this$0.rects[n12];
                    rectangle.x = n8;
                    rectangle.y += this.this$0.getTabRunIndent(n2, n5);
                }
                if (this.this$0.shouldPadTabRun(n2, n5)) {
                    this.padTabRun(n2, n4, n13, n6);
                }
                if (n2 == 4) {
                    n8 -= this.this$0.maxTabWidth - n11;
                    continue;
                }
                n8 += this.this$0.maxTabWidth - n11;
            }
            this.padSelectedTab(n2, n10);
            if (!bl3 && !bl2) {
                n4 = dimension.width - (insets.right + insets2.right);
                for (n5 = 0; n5 < n3; ++n5) {
                    this.this$0.rects[n5].x = n4 - this.this$0.rects[n5].x - this.this$0.rects[n5].width;
                }
            }
        }

        protected void padSelectedTab(int n2, int n3) {
            if (n3 >= 0) {
                Rectangle rectangle = this.this$0.rects[n3];
                Insets insets = this.this$0.getSelectedTabPadInsets(n2);
                rectangle.x -= insets.left;
                rectangle.width += insets.left + insets.right;
                rectangle.y -= insets.top;
                rectangle.height += insets.top + insets.bottom;
            }
        }

        protected void rotateTabRuns(int n2, int n3) {
            for (int i2 = 0; i2 < n3; ++i2) {
                int n4 = this.this$0.tabRuns[0];
                for (int i3 = 1; i3 < this.this$0.runCount; ++i3) {
                    this.this$0.tabRuns[i3 - 1] = this.this$0.tabRuns[i3];
                }
                this.this$0.tabRuns[this.this$0.runCount - 1] = n4;
            }
        }

        protected void normalizeTabRuns(int n2, int n3, int n4, int n5) {
            boolean bl2 = n2 == 2 || n2 == 4;
            int n6 = this.this$0.runCount - 1;
            boolean bl3 = true;
            double d2 = 1.25;
            while (bl3) {
                int n7;
                int n8;
                int n9 = this.this$0.lastTabInRun(n3, n6);
                int n10 = this.this$0.lastTabInRun(n3, n6 - 1);
                if (!bl2) {
                    n8 = this.this$0.rects[n9].x + this.this$0.rects[n9].width;
                    n7 = (int)((double)this.this$0.maxTabWidth * d2);
                } else {
                    n8 = this.this$0.rects[n9].y + this.this$0.rects[n9].height;
                    n7 = (int)((double)this.this$0.maxTabHeight * d2 * 2.0);
                }
                if (n5 - n8 > n7) {
                    this.this$0.tabRuns[n6] = n10;
                    if (!bl2) {
                        this.this$0.rects[n10].x = n4;
                    } else {
                        this.this$0.rects[n10].y = n4;
                    }
                    for (int i2 = n10 + 1; i2 <= n9; ++i2) {
                        if (!bl2) {
                            this.this$0.rects[i2].x = this.this$0.rects[i2 - 1].x + this.this$0.rects[i2 - 1].width;
                            continue;
                        }
                        this.this$0.rects[i2].y = this.this$0.rects[i2 - 1].y + this.this$0.rects[i2 - 1].height;
                    }
                } else if (n6 == this.this$0.runCount - 1) {
                    bl3 = false;
                }
                if (n6 - 1 > 0) {
                    --n6;
                    continue;
                }
                n6 = this.this$0.runCount - 1;
                d2 += 0.25;
            }
        }

        protected void padTabRun(int n2, int n3, int n4, int n5) {
            Rectangle rectangle = this.this$0.rects[n4];
            if (n2 == 1 || n2 == 3) {
                int n6 = rectangle.x + rectangle.width - this.this$0.rects[n3].x;
                int n7 = n5 - (rectangle.x + rectangle.width);
                float f2 = (float)n7 / (float)n6;
                for (int i2 = n3; i2 <= n4; ++i2) {
                    Rectangle rectangle2 = this.this$0.rects[i2];
                    if (i2 > n3) {
                        rectangle2.x = this.this$0.rects[i2 - 1].x + this.this$0.rects[i2 - 1].width;
                    }
                    rectangle2.width += Math.round((float)rectangle2.width * f2);
                }
                rectangle.width = n5 - rectangle.x;
            } else {
                int n8 = rectangle.y + rectangle.height - this.this$0.rects[n3].y;
                int n9 = n5 - (rectangle.y + rectangle.height);
                float f3 = (float)n9 / (float)n8;
                for (int i3 = n3; i3 <= n4; ++i3) {
                    Rectangle rectangle3 = this.this$0.rects[i3];
                    if (i3 > n3) {
                        rectangle3.y = this.this$0.rects[i3 - 1].y + this.this$0.rects[i3 - 1].height;
                    }
                    rectangle3.height += Math.round((float)rectangle3.height * f3);
                }
                rectangle.height = n5 - rectangle.y;
            }
        }

        TabbedPaneLayout(SynthTabbedPaneUI synthTabbedPaneUI) {
            this.this$0 = synthTabbedPaneUI;
        }

        public void removeLayoutComponent(Component component) {
        }

        public void layoutContainer(Container container) {
            SynthTabbedPaneUI.access$1900(this.this$0, -1);
            int n2 = this.this$0.tabPane.getTabPlacement();
            Insets insets = this.this$0.tabPane.getInsets();
            int n3 = this.this$0.tabPane.getSelectedIndex();
            Component component = this.this$0.getVisibleComponent();
            this.calculateLayoutInfo();
            if (n3 < 0) {
                if (component != null) {
                    this.this$0.setVisibleComponent(null);
                }
            } else {
                int n4 = 0;
                int n5 = 0;
                Insets insets2 = this.this$0.getContentBorderInsets(n2);
                Component component2 = this.this$0.tabPane.getComponentAt(n3);
                boolean bl2 = false;
                if (component2 != null) {
                    if (component2 != component && component != null && SwingUtilities.findFocusOwner(component) != null) {
                        bl2 = true;
                    }
                    this.this$0.setVisibleComponent(component2);
                }
                Rectangle rectangle = this.this$0.tabPane.getBounds();
                int n6 = this.this$0.tabPane.getComponentCount();
                if (n6 > 0) {
                    int n7;
                    int n8;
                    switch (n2) {
                        case 2: {
                            n4 = this.this$0.calculateTabAreaWidth(n2, this.this$0.runCount, this.this$0.maxTabWidth);
                            n8 = insets.left + n4 + insets2.left;
                            n7 = insets.top + insets2.top;
                            break;
                        }
                        case 4: {
                            n4 = this.this$0.calculateTabAreaWidth(n2, this.this$0.runCount, this.this$0.maxTabWidth);
                            n8 = insets.left + insets2.left;
                            n7 = insets.top + insets2.top;
                            break;
                        }
                        case 3: {
                            n5 = this.this$0.calculateTabAreaHeight(n2, this.this$0.runCount, this.this$0.maxTabHeight);
                            n8 = insets.left + insets2.left;
                            n7 = insets.top + insets2.top;
                            break;
                        }
                        default: {
                            n5 = this.this$0.calculateTabAreaHeight(n2, this.this$0.runCount, this.this$0.maxTabHeight);
                            n8 = insets.left + insets2.left;
                            n7 = insets.top + n5 + insets2.top;
                        }
                    }
                    int n9 = rectangle.width - n4 - insets.left - insets.right - insets2.left - insets2.right;
                    int n10 = rectangle.height - n5 - insets.top - insets.bottom - insets2.top - insets2.bottom;
                    for (int i2 = 0; i2 < n6; ++i2) {
                        Component component3 = this.this$0.tabPane.getComponent(i2);
                        component3.setBounds(n8, n7, n9, n10);
                    }
                }
                if (bl2 && !this.this$0.requestFocusForVisibleComponent()) {
                    this.this$0.tabPane.requestFocus();
                }
            }
        }

        protected Dimension calculateSize(boolean bl2) {
            int n2;
            int n3 = this.this$0.tabPane.getTabPlacement();
            Insets insets = this.this$0.tabPane.getInsets();
            Insets insets2 = this.this$0.getContentBorderInsets(n3);
            Insets insets3 = this.this$0.getTabAreaInsets(n3);
            Dimension dimension = new Dimension(0, 0);
            int n4 = insets2.top + insets2.bottom;
            int n5 = insets2.left + insets2.right;
            int n6 = 0;
            int n7 = 0;
            for (n2 = 0; n2 < this.this$0.tabPane.getTabCount(); ++n2) {
                Component component = this.this$0.tabPane.getComponentAt(n2);
                if (component == null) continue;
                Dimension dimension2 = dimension;
                Dimension dimension3 = dimension2 = bl2 ? component.getMinimumSize() : component.getPreferredSize();
                if (dimension2 == null) continue;
                n7 = Math.max(dimension2.height, n7);
                n6 = Math.max(dimension2.width, n6);
            }
            n5 += n6;
            n4 += n7;
            n2 = 0;
            switch (n3) {
                case 2: 
                case 4: {
                    n4 = Math.max(n4, this.this$0.calculateMaxTabHeight(n3) + insets3.top + insets3.bottom);
                    n2 = this.preferredTabAreaWidth(n3, n4);
                    n5 += n2;
                    break;
                }
                default: {
                    n5 = Math.max(n5, this.this$0.calculateMaxTabWidth(n3) + insets3.left + insets3.right);
                    n2 = this.preferredTabAreaHeight(n3, n5);
                    n4 += n2;
                }
            }
            return new Dimension(n5 + insets.left + insets.right, n4 + insets.bottom + insets.top);
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public Dimension minimumLayoutSize(Container container) {
            return this.calculateSize(true);
        }

        public Dimension preferredLayoutSize(Container container) {
            return this.calculateSize(false);
        }
    }

    private class TabbedPaneScrollLayout
    extends TabbedPaneLayout {
        private final SynthTabbedPaneUI this$0;

        protected int preferredTabAreaHeight(int n2, int n3) {
            return this.this$0.calculateMaxTabHeight(n2);
        }

        protected int preferredTabAreaWidth(int n2, int n3) {
            return this.this$0.calculateMaxTabWidth(n2);
        }

        protected void calculateTabRects(int n2, int n3) {
            int n4;
            FontMetrics fontMetrics = this.this$0.getFontMetrics();
            Dimension dimension = this.this$0.tabPane.getSize();
            Insets insets = this.this$0.tabPane.getInsets();
            Insets insets2 = this.this$0.getTabAreaInsets(n2);
            int n5 = fontMetrics.getHeight();
            int n6 = this.this$0.tabPane.getSelectedIndex();
            boolean bl2 = n2 == 2 || n2 == 4;
            boolean bl3 = SynthLookAndFeel.isLeftToRight(this.this$0.tabPane);
            int n7 = insets2.left;
            int n8 = insets2.top;
            int n9 = 0;
            int n10 = 0;
            switch (n2) {
                case 2: 
                case 4: {
                    this.this$0.maxTabWidth = this.this$0.calculateMaxTabWidth(n2);
                    break;
                }
                default: {
                    this.this$0.maxTabHeight = this.this$0.calculateMaxTabHeight(n2);
                }
            }
            this.this$0.runCount = 0;
            this.this$0.selectedRun = -1;
            if (n3 == 0) {
                return;
            }
            this.this$0.selectedRun = 0;
            this.this$0.runCount = 1;
            for (n4 = 0; n4 < n3; ++n4) {
                Rectangle rectangle = this.this$0.rects[n4];
                if (!bl2) {
                    if (n4 > 0) {
                        rectangle.x = this.this$0.rects[n4 - 1].x + this.this$0.rects[n4 - 1].width;
                    } else {
                        this.this$0.tabRuns[0] = 0;
                        this.this$0.maxTabWidth = 0;
                        n10 += this.this$0.maxTabHeight;
                        rectangle.x = n7;
                    }
                    rectangle.width = this.this$0.calculateTabWidth(n2, n4, fontMetrics);
                    n9 = rectangle.x + rectangle.width;
                    this.this$0.maxTabWidth = Math.max(this.this$0.maxTabWidth, rectangle.width);
                    rectangle.y = n8;
                    rectangle.height = this.this$0.maxTabHeight;
                    continue;
                }
                if (n4 > 0) {
                    rectangle.y = this.this$0.rects[n4 - 1].y + this.this$0.rects[n4 - 1].height;
                } else {
                    this.this$0.tabRuns[0] = 0;
                    this.this$0.maxTabHeight = 0;
                    n9 = this.this$0.maxTabWidth;
                    rectangle.y = n8;
                }
                rectangle.height = this.this$0.calculateTabHeight(n2, n4, n5);
                n10 = rectangle.y + rectangle.height;
                this.this$0.maxTabHeight = Math.max(this.this$0.maxTabHeight, rectangle.height);
                rectangle.x = n7;
                rectangle.width = this.this$0.maxTabWidth;
            }
            if (!bl3 && !bl2) {
                int n11 = dimension.width - (insets.right + insets2.right);
                for (n4 = 0; n4 < n3; ++n4) {
                    this.this$0.rects[n4].x = n11 - this.this$0.rects[n4].x - this.this$0.rects[n4].width;
                }
            }
            SynthTabbedPaneUI.access$1800((SynthTabbedPaneUI)this.this$0).tabPanel.setPreferredSize(new Dimension(n9, n10));
        }

        private TabbedPaneScrollLayout(SynthTabbedPaneUI synthTabbedPaneUI) {
            this.this$0 = synthTabbedPaneUI;
            super(synthTabbedPaneUI);
        }

        public void layoutContainer(Container container) {
            int n2 = this.this$0.tabPane.getTabPlacement();
            int n3 = this.this$0.tabPane.getTabCount();
            Insets insets = this.this$0.tabPane.getInsets();
            int n4 = this.this$0.tabPane.getSelectedIndex();
            Component component = this.this$0.getVisibleComponent();
            this.calculateLayoutInfo();
            if (n4 < 0) {
                if (component != null) {
                    this.this$0.setVisibleComponent(null);
                }
            } else {
                Component component2 = this.this$0.tabPane.getComponentAt(n4);
                boolean bl2 = false;
                if (component2 != null) {
                    if (component2 != component && component != null && SwingUtilities.findFocusOwner(component) != null) {
                        bl2 = true;
                    }
                    this.this$0.setVisibleComponent(component2);
                }
                Insets insets2 = this.this$0.getContentBorderInsets(n2);
                Rectangle rectangle = this.this$0.tabPane.getBounds();
                int n5 = this.this$0.tabPane.getComponentCount();
                if (n5 > 0) {
                    int n6;
                    int n7;
                    int n8;
                    int n9;
                    int n10;
                    int n11;
                    int n12;
                    int n13;
                    switch (n2) {
                        case 2: {
                            n13 = this.this$0.calculateTabAreaWidth(n2, this.this$0.runCount, this.this$0.maxTabWidth);
                            n12 = rectangle.height - insets.top - insets.bottom;
                            n11 = insets.left;
                            n10 = insets.top;
                            n9 = n11 + n13 + insets2.left;
                            n8 = n10 + insets2.top;
                            n7 = rectangle.width - insets.left - insets.right - n13 - insets2.left - insets2.right;
                            n6 = rectangle.height - insets.top - insets.bottom - insets2.top - insets2.bottom;
                            break;
                        }
                        case 4: {
                            n13 = this.this$0.calculateTabAreaWidth(n2, this.this$0.runCount, this.this$0.maxTabWidth);
                            n12 = rectangle.height - insets.top - insets.bottom;
                            n11 = rectangle.width - insets.right - n13;
                            n10 = insets.top;
                            n9 = insets.left + insets2.left;
                            n8 = insets.top + insets2.top;
                            n7 = rectangle.width - insets.left - insets.right - n13 - insets2.left - insets2.right;
                            n6 = rectangle.height - insets.top - insets.bottom - insets2.top - insets2.bottom;
                            break;
                        }
                        case 3: {
                            n13 = rectangle.width - insets.left - insets.right;
                            n12 = this.this$0.calculateTabAreaHeight(n2, this.this$0.runCount, this.this$0.maxTabHeight);
                            n11 = insets.left;
                            n10 = rectangle.height - insets.bottom - n12;
                            n9 = insets.left + insets2.left;
                            n8 = insets.top + insets2.top;
                            n7 = rectangle.width - insets.left - insets.right - insets2.left - insets2.right;
                            n6 = rectangle.height - insets.top - insets.bottom - n12 - insets2.top - insets2.bottom;
                            break;
                        }
                        default: {
                            n13 = rectangle.width - insets.left - insets.right;
                            n12 = this.this$0.calculateTabAreaHeight(n2, this.this$0.runCount, this.this$0.maxTabHeight);
                            n11 = insets.left;
                            n10 = insets.top;
                            n9 = n11 + insets2.left;
                            n8 = n10 + n12 + insets2.top;
                            n7 = rectangle.width - insets.left - insets.right - insets2.left - insets2.right;
                            n6 = rectangle.height - insets.top - insets.bottom - n12 - insets2.top - insets2.bottom;
                        }
                    }
                    for (int i2 = 0; i2 < n5; ++i2) {
                        int n14;
                        int n15;
                        int n16;
                        int n17;
                        Cloneable cloneable;
                        JComponent jComponent;
                        Component component3 = this.this$0.tabPane.getComponent(i2);
                        if (component3 instanceof ScrollableTabViewport) {
                            jComponent = (JViewport)component3;
                            cloneable = ((JViewport)jComponent).getViewRect();
                            n17 = n13;
                            n16 = n12;
                            switch (n2) {
                                case 2: 
                                case 4: {
                                    n15 = this.this$0.rects[n3 - 1].y + this.this$0.rects[n3 - 1].height;
                                    if (n15 <= n12 || n15 - cloneable.y > (n16 = Math.max(n12 - 36, 36))) break;
                                    n16 = n15 - cloneable.y;
                                    break;
                                }
                                default: {
                                    n14 = this.this$0.rects[n3 - 1].x + this.this$0.rects[n3 - 1].width;
                                    if (n14 <= n13 || n14 - cloneable.x > (n17 = Math.max(n13 - 36, 36))) break;
                                    n17 = n14 - cloneable.x;
                                }
                            }
                            component3.setBounds(n11, n10, n17, n16);
                            continue;
                        }
                        if (component3 instanceof ScrollableTabButton) {
                            jComponent = (ScrollableTabButton)component3;
                            cloneable = jComponent.getPreferredSize();
                            n17 = 0;
                            n16 = 0;
                            n15 = ((Dimension)cloneable).width;
                            n14 = ((Dimension)cloneable).height;
                            boolean bl3 = false;
                            switch (n2) {
                                case 2: 
                                case 4: {
                                    int n18 = this.this$0.rects[n3 - 1].y + this.this$0.rects[n3 - 1].height;
                                    if (n18 <= n12) break;
                                    int n19 = ((ScrollableTabButton)jComponent).scrollsForward() ? 5 : 1;
                                    ((SynthArrowButton)jComponent).setDirection(n19);
                                    bl3 = true;
                                    n17 = n2 == 2 ? n11 + n13 - ((Dimension)cloneable).width : n11;
                                    n16 = n19 == 5 ? rectangle.height - insets.bottom - ((Dimension)cloneable).height : rectangle.height - insets.bottom - 2 * ((Dimension)cloneable).height;
                                    break;
                                }
                                default: {
                                    int n19 = this.this$0.rects[n3 - 1].x + this.this$0.rects[n3 - 1].width;
                                    if (n19 <= n13) break;
                                    int n20 = ((ScrollableTabButton)jComponent).scrollsForward() ? 3 : 7;
                                    ((SynthArrowButton)jComponent).setDirection(n20);
                                    bl3 = true;
                                    n17 = n20 == 3 ? rectangle.width - insets.left - ((Dimension)cloneable).width : rectangle.width - insets.left - 2 * ((Dimension)cloneable).width;
                                    n16 = n2 == 1 ? n10 + n12 - ((Dimension)cloneable).height : n10;
                                }
                            }
                            component3.setVisible(bl3);
                            if (!bl3) continue;
                            component3.setBounds(n17, n16, n15, n14);
                            continue;
                        }
                        component3.setBounds(n9, n8, n7, n6);
                    }
                    if (bl2 && !this.this$0.requestFocusForVisibleComponent()) {
                        this.this$0.tabPane.requestFocus();
                    }
                }
            }
        }

        TabbedPaneScrollLayout(SynthTabbedPaneUI synthTabbedPaneUI, 1 var2_2) {
            this(synthTabbedPaneUI);
        }
    }

    private static class UpAction
    extends AbstractAction {
        private UpAction() {
        }

        UpAction(1 var1_1) {
            this();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)actionEvent.getSource();
            SynthTabbedPaneUI synthTabbedPaneUI = (SynthTabbedPaneUI)jTabbedPane.getUI();
            synthTabbedPaneUI.navigateSelectedTab(1);
        }
    }
}

