/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.gtk;

import com.sun.java.swing.plaf.gtk.ColorType;
import com.sun.java.swing.plaf.gtk.Region;
import com.sun.java.swing.plaf.gtk.SynthButtonListener;
import com.sun.java.swing.plaf.gtk.SynthContext;
import com.sun.java.swing.plaf.gtk.SynthLookAndFeel;
import com.sun.java.swing.plaf.gtk.SynthStyle;
import com.sun.java.swing.plaf.gtk.SynthUI;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.plaf.ButtonUI;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicHTML;

class SynthButtonUI
extends ButtonUI
implements SynthUI {
    private static SynthButtonListener sharedButtonListener;
    private SynthStyle style;
    static Class class$com$sun$java$swing$plaf$gtk$SynthContext;

    SynthButtonUI() {
    }

    protected int getTextShiftOffset(SynthContext synthContext) {
        int n2;
        AbstractButton abstractButton = (AbstractButton)synthContext.getComponent();
        ButtonModel buttonModel = abstractButton.getModel();
        if (buttonModel.isArmed() && buttonModel.isPressed() && abstractButton.getPressedIcon() != null && (n2 = synthContext.getStyle().getInt(synthContext, this.getPropertyPrefix() + "textShiftOffset", -1)) != -1) {
            return n2;
        }
        return 0;
    }

    protected String getPropertyPrefix() {
        return "Button.";
    }

    void fetchStyle(AbstractButton abstractButton) {
        SynthContext synthContext = this.getContext(abstractButton, 1);
        SynthStyle synthStyle = this.style;
        this.style = SynthLookAndFeel.updateStyle(synthContext, this);
        if (this.style != synthStyle) {
            int n2;
            if (abstractButton.getMargin() == null || abstractButton.getMargin() instanceof UIResource) {
                Insets insets = (Insets)this.style.get(synthContext, this.getPropertyPrefix() + "margin");
                if (insets == null) {
                    insets = SynthLookAndFeel.EMPTY_UIRESOURCE_INSETS;
                }
                abstractButton.setMargin(insets);
            }
            if ((n2 = this.style.getInt(synthContext, this.getPropertyPrefix() + "iconTextGap", -1)) != -1) {
                abstractButton.setIconTextGap(n2);
            }
            abstractButton.setContentAreaFilled(this.style.getBoolean(synthContext, this.getPropertyPrefix() + "contentAreaFilled", true));
        }
        synthContext.dispose();
    }

    protected void installDefaults(AbstractButton abstractButton) {
        this.fetchStyle(abstractButton);
        abstractButton.setRolloverEnabled(true);
    }

    protected void installKeyboardActions(AbstractButton abstractButton) {
        SynthButtonListener synthButtonListener = this.getButtonListener(abstractButton);
        if (synthButtonListener != null) {
            synthButtonListener.installKeyboardActions(abstractButton);
        }
    }

    protected void installListeners(AbstractButton abstractButton) {
        SynthButtonListener synthButtonListener = this.createButtonListener(abstractButton);
        if (synthButtonListener != null) {
            abstractButton.addMouseListener(synthButtonListener);
            abstractButton.addMouseMotionListener(synthButtonListener);
            abstractButton.addFocusListener(synthButtonListener);
            abstractButton.addPropertyChangeListener(synthButtonListener);
            abstractButton.addChangeListener(synthButtonListener);
        }
    }

    protected void uninstallDefaults(AbstractButton abstractButton) {
        SynthContext synthContext = this.getContext(abstractButton, 1);
        this.style.uninstallDefaults(synthContext);
        synthContext.dispose();
        this.style = null;
    }

    protected void uninstallKeyboardActions(AbstractButton abstractButton) {
        SynthButtonListener synthButtonListener = this.getButtonListener(abstractButton);
        if (synthButtonListener != null) {
            synthButtonListener.uninstallKeyboardActions(abstractButton);
        }
    }

    protected void uninstallListeners(AbstractButton abstractButton) {
        SynthButtonListener synthButtonListener = this.getButtonListener(abstractButton);
        if (synthButtonListener != null) {
            abstractButton.removeMouseListener(synthButtonListener);
            abstractButton.removeMouseListener(synthButtonListener);
            abstractButton.removeMouseMotionListener(synthButtonListener);
            abstractButton.removeFocusListener(synthButtonListener);
            abstractButton.removeChangeListener(synthButtonListener);
            abstractButton.removePropertyChangeListener(synthButtonListener);
        }
    }

    private int getComponentState(JComponent jComponent) {
        ButtonModel buttonModel;
        int n2 = 1;
        if (!jComponent.isEnabled()) {
            n2 = 8;
        }
        if ((buttonModel = ((AbstractButton)jComponent).getModel()).isPressed()) {
            n2 = buttonModel.isArmed() ? 4 : 2;
        } else if (buttonModel.isRollover()) {
            n2 = 2;
        }
        if (buttonModel.isSelected()) {
            n2 |= 0x200;
        }
        if (jComponent.isFocusOwner()) {
            n2 |= 0x100;
        }
        if (jComponent instanceof JButton && ((JButton)jComponent).isDefaultButton()) {
            n2 |= 0x400;
        }
        return n2;
    }

    public void installUI(JComponent jComponent) {
        this.installDefaults((AbstractButton)jComponent);
        this.installListeners((AbstractButton)jComponent);
        this.installKeyboardActions((AbstractButton)jComponent);
        BasicHTML.updateRenderer(jComponent, ((AbstractButton)jComponent).getText());
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallKeyboardActions((AbstractButton)jComponent);
        this.uninstallListeners((AbstractButton)jComponent);
        this.uninstallDefaults((AbstractButton)jComponent);
        BasicHTML.updateRenderer(jComponent, "");
    }

    private Region getRegion(JComponent jComponent) {
        return SynthLookAndFeel.getRegion(jComponent);
    }

    protected SynthButtonListener createButtonListener(AbstractButton abstractButton) {
        if (sharedButtonListener == null) {
            sharedButtonListener = new SynthButtonListener();
        }
        return sharedButtonListener;
    }

    private SynthButtonListener getButtonListener(AbstractButton abstractButton) {
        return (SynthButtonListener)SynthLookAndFeel.getSynthEventListener(abstractButton);
    }

    public SynthContext getContext(JComponent jComponent) {
        return this.getContext(jComponent, this.getComponentState(jComponent));
    }

    SynthContext getContext(JComponent jComponent, int n2) {
        Region region = this.getRegion(jComponent);
        return SynthContext.getContext(class$com$sun$java$swing$plaf$gtk$SynthContext == null ? (class$com$sun$java$swing$plaf$gtk$SynthContext = SynthButtonUI.class$("com.sun.java.swing.plaf.gtk.SynthContext")) : class$com$sun$java$swing$plaf$gtk$SynthContext, jComponent, region, this.style, n2);
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        if (jComponent.getComponentCount() > 0 && jComponent.getLayout() != null) {
            return null;
        }
        AbstractButton abstractButton = (AbstractButton)jComponent;
        SynthContext synthContext = this.getContext(jComponent);
        Dimension dimension = synthContext.getStyle().getSynthGraphics(synthContext).getMaximumSize(synthContext, synthContext.getStyle().getFont(synthContext), abstractButton.getText(), this.getSizingIcon(abstractButton), abstractButton.getHorizontalAlignment(), abstractButton.getVerticalAlignment(), abstractButton.getHorizontalTextPosition(), abstractButton.getVerticalTextPosition(), abstractButton.getIconTextGap(), abstractButton.getDisplayedMnemonicIndex());
        synthContext.dispose();
        return dimension;
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        if (jComponent.getComponentCount() > 0 && jComponent.getLayout() != null) {
            return null;
        }
        AbstractButton abstractButton = (AbstractButton)jComponent;
        SynthContext synthContext = this.getContext(jComponent);
        Dimension dimension = synthContext.getStyle().getSynthGraphics(synthContext).getMinimumSize(synthContext, synthContext.getStyle().getFont(synthContext), abstractButton.getText(), this.getSizingIcon(abstractButton), abstractButton.getHorizontalAlignment(), abstractButton.getVerticalAlignment(), abstractButton.getHorizontalTextPosition(), abstractButton.getVerticalTextPosition(), abstractButton.getIconTextGap(), abstractButton.getDisplayedMnemonicIndex());
        synthContext.dispose();
        return dimension;
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        if (jComponent.getComponentCount() > 0 && jComponent.getLayout() != null) {
            return null;
        }
        AbstractButton abstractButton = (AbstractButton)jComponent;
        SynthContext synthContext = this.getContext(jComponent);
        Dimension dimension = synthContext.getStyle().getSynthGraphics(synthContext).getPreferredSize(synthContext, synthContext.getStyle().getFont(synthContext), abstractButton.getText(), this.getSizingIcon(abstractButton), abstractButton.getHorizontalAlignment(), abstractButton.getVerticalAlignment(), abstractButton.getHorizontalTextPosition(), abstractButton.getVerticalTextPosition(), abstractButton.getIconTextGap(), abstractButton.getDisplayedMnemonicIndex());
        synthContext.dispose();
        return dimension;
    }

    protected void paint(SynthContext synthContext, Graphics graphics) {
        AbstractButton abstractButton = (AbstractButton)synthContext.getComponent();
        graphics.setColor(synthContext.getStyle().getColor(synthContext, ColorType.TEXT_FOREGROUND));
        graphics.setFont(this.style.getFont(synthContext));
        synthContext.getStyle().getSynthGraphics(synthContext).paintText(synthContext, graphics, abstractButton.getText(), this.getIcon(abstractButton), abstractButton.getHorizontalAlignment(), abstractButton.getVerticalAlignment(), abstractButton.getHorizontalTextPosition(), abstractButton.getVerticalTextPosition(), abstractButton.getIconTextGap(), abstractButton.getDisplayedMnemonicIndex(), this.getTextShiftOffset(synthContext));
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    protected Icon getIcon(AbstractButton abstractButton) {
        Icon icon = abstractButton.getIcon();
        if (icon == null) {
            return null;
        }
        ButtonModel buttonModel = abstractButton.getModel();
        Icon icon2 = null;
        if (!buttonModel.isEnabled()) {
            icon2 = buttonModel.isSelected() ? abstractButton.getDisabledSelectedIcon() : abstractButton.getDisabledIcon();
        } else if (buttonModel.isPressed() && buttonModel.isArmed()) {
            icon2 = abstractButton.getPressedIcon();
            if (icon2 == null) {
                icon2 = abstractButton.getSelectedIcon();
            }
        } else if (abstractButton.isRolloverEnabled() && buttonModel.isRollover()) {
            if (buttonModel.isSelected()) {
                icon2 = abstractButton.getRolloverSelectedIcon();
                if (icon2 == null) {
                    icon2 = abstractButton.getSelectedIcon();
                }
            } else {
                icon2 = abstractButton.getRolloverIcon();
            }
        } else if (buttonModel.isSelected()) {
            icon2 = abstractButton.getSelectedIcon();
        }
        if (icon2 != null) {
            icon = icon2;
        }
        return icon;
    }

    protected Icon getSizingIcon(AbstractButton abstractButton) {
        return abstractButton.isEnabled() ? abstractButton.getIcon() : abstractButton.getDisabledIcon();
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    public void update(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        SynthLookAndFeel.update(synthContext, graphics);
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new SynthButtonUI();
    }
}

