/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.gtk;

import com.sun.java.swing.plaf.gtk.ColorType;
import com.sun.java.swing.plaf.gtk.GTKColorType;
import com.sun.java.swing.plaf.gtk.Metacity;
import com.sun.java.swing.plaf.gtk.SynthContext;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.io.File;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.SwingUtilities;

class MetacityBluecurve
extends Metacity {
    private static final int ArrowWidth = 7;
    private static final int ArrowHeight = 5;
    private static final int ButtonIPad = 3;
    private static final int ThickLineWidth = 3;
    private static final int IconTitleSpacing = 2;
    private static final int LeftTitleTextPad = 6;
    private static final int IconShadowOffset = 1;
    private static final Metacity.FrameGeometry normalFrameGeometry = new NormalFrameGeometry();
    private static final Metacity.FrameGeometry normalMaximizedFrameGeometry = new NormalMaximizedFrameGeometry();
    private HashMap images = new HashMap();

    private void button_generic_bg_after(Graphics graphics, int n2, int n3) {
        graphics.setColor(MetacityBluecurve.shadeColor(this.getColor(1, GTKColorType.DARK), 0.9f));
        graphics.drawLine(0, n3 - 1, n2, n3 - 1);
    }

    private void button_generic_bg_before(Graphics graphics, int n2, int n3) {
        this.drawDiagonalGradient(graphics, MetacityBluecurve.shadeColor(this.getColor(1, GTKColorType.BACKGROUND), 1.3f), MetacityBluecurve.shadeColor(this.getColor(1, GTKColorType.BACKGROUND), 0.9f), 0, 1, n2, n3);
        this.drawDiagonalGradient(graphics, MetacityBluecurve.shadeColor(this.getColor(1, GTKColorType.BACKGROUND), 0.9f), MetacityBluecurve.shadeColor(this.getColor(1, GTKColorType.BACKGROUND), 1.3f), 1, 1, n2 - 2, n3 - 2);
    }

    private void button_generic_bg_before_unfocused(Graphics graphics, int n2, int n3) {
        this.titlebar_bg_unfocused(graphics, n2, n3);
        this.drawVerticalGradient(graphics, MetacityBluecurve.shadeColor(this.getColor(1, GTKColorType.BACKGROUND), 1.5f), MetacityBluecurve.shadeColor(this.getColor(1, GTKColorType.BACKGROUND), 0.95f), 0, 1, n2, n3 - 2, 0.1f);
    }

    private void center_button_bg(Graphics graphics, int n2, int n3) {
        this.button_generic_bg_before(graphics, n2, n3);
        this.button_generic_bg_after(graphics, n2, n3);
        graphics.setColor(MetacityBluecurve.shadeColor(this.getColor(1, GTKColorType.BACKGROUND), 1.2f));
        graphics.drawLine(0, 0, n2, 0);
        graphics.setColor(this.getColor(1, GTKColorType.DARK));
        graphics.drawLine(n2 - 1, 0, n2 - 1, n3);
    }

    private void center_button_bg_unfocused(Graphics graphics, int n2, int n3) {
        this.button_generic_bg_before_unfocused(graphics, n2, n3);
    }

    private void close_button(Graphics graphics, int n2, int n3) {
        this.right_corner_button_bg(graphics, n2, n3);
        this.close_icon(graphics, n2, n3);
    }

    private void close_button_prelight(Graphics graphics, int n2, int n3) {
        this.right_corner_button_bg(graphics, n2, n3);
        this.prelight_tint(graphics, n2, n3);
        this.close_icon(graphics, n2, n3);
        this.right_corner_outline(graphics, n2, n3);
    }

    private void close_button_pressed(Graphics graphics, int n2, int n3) {
        this.right_corner_button_bg(graphics, n2, n3);
        this.darken_tint(graphics, n2, n3);
        this.close_icon(graphics, n2, n3);
    }

    private void close_icon(Graphics graphics, int n2, int n3) {
        Image image = this.getImage("close", this.getColor(1, GTKColorType.FOREGROUND));
        this.drawImage(graphics, image, this.getColor(1, GTKColorType.FOREGROUND), 0.7f, (n2 - image.getWidth(null)) / 2, (n3 - image.getHeight(null)) / 2);
    }

    private void corners_focused(Graphics graphics, int n2, int n3) {
        Color color = MetacityBluecurve.shadeColor(this.getColor(512, GTKColorType.BACKGROUND), 1.0f);
        Image image = this.getImage("bottom_left", color);
        graphics.drawImage(image, 0, n3 - image.getHeight(null), null);
        image = this.getImage("bottom_right", color);
        graphics.drawImage(image, n2 - image.getWidth(null), n3 - image.getHeight(null), null);
    }

    private void corners_unfocused(Graphics graphics, int n2, int n3) {
        Color color = MetacityBluecurve.shadeColor(this.getColor(8, GTKColorType.BACKGROUND), 0.8f);
        Image image = this.getImage("bottom_left", color);
        graphics.drawImage(image, 0, n3 - image.getHeight(null), null);
        image = this.getImage("bottom_right", color);
        graphics.drawImage(image, n2 - image.getWidth(null), n3 - image.getHeight(null), null);
    }

    private void darken_tint(Graphics graphics, int n2, int n3) {
        this.tintRect(graphics, 0, 0, n2, n3, MetacityBluecurve.shadeColor(this.getColor(1, GTKColorType.BACKGROUND), 0.75f), 0.5f);
    }

    private void focus_background(Graphics graphics, int n2, int n3) {
        this.outer_bevel(graphics, n2, n3);
        this.corners_focused(graphics, n2, n3);
    }

    private void left_corner_button_bg(Graphics graphics, int n2, int n3) {
        this.button_generic_bg_before(graphics, n2, n3);
        this.button_generic_bg_after(graphics, n2, n3);
        this.left_corner_outline(graphics, n2, n3);
        graphics.setColor(MetacityBluecurve.shadeColor(this.getColor(1, GTKColorType.BACKGROUND), 1.2f));
        graphics.drawLine(5, 0, n2, 0);
        graphics.setColor(MetacityBluecurve.shadeColor(this.getColor(1, GTKColorType.LIGHT), 1.2f));
        graphics.drawLine(1, 4, 1, n3 - 2);
        graphics.setColor(MetacityBluecurve.shadeColor(this.getColor(1, GTKColorType.LIGHT), 1.1f));
        graphics.drawLine(3, 1, 4, 1);
        graphics.drawLine(2, 2, 2, 3);
    }

    private void left_corner_button_bg_unfocused(Graphics graphics, int n2, int n3) {
        this.button_generic_bg_before_unfocused(graphics, n2, n3);
        this.left_corner_outline(graphics, n2, n3);
        graphics.setColor(MetacityBluecurve.shadeColor(this.getColor(8, GTKColorType.BACKGROUND), 1.2f));
        graphics.drawLine(5, 0, n2, 0);
        graphics.setColor(MetacityBluecurve.shadeColor(this.getColor(8, GTKColorType.LIGHT), 1.2f));
        graphics.drawLine(1, 4, 1, n3 - 2);
        graphics.setColor(MetacityBluecurve.shadeColor(this.getColor(8, GTKColorType.LIGHT), 1.1f));
        graphics.drawLine(3, 1, 4, 1);
        graphics.drawLine(2, 2, 2, 3);
    }

    private void left_corner_outline(Graphics graphics, int n2, int n3) {
        graphics.setColor(Color.black);
        graphics.drawLine(0, 4, 0, n3);
        graphics.drawLine(1, 2, 1, 3);
        graphics.drawLine(2, 1, 2, 1);
        graphics.drawLine(3, 0, 4, 0);
    }

    private void maximize_icon(Graphics graphics, int n2, int n3) {
        Image image = this.getImage("maximize", this.getColor(1, GTKColorType.FOREGROUND));
        this.drawImage(graphics, image, this.getColor(1, GTKColorType.FOREGROUND), 0.7f, (n2 - image.getWidth(null)) / 2, (n3 - image.getHeight(null)) / 2);
    }

    private void menu_button(Graphics graphics, int n2, int n3) {
        this.left_corner_button_bg(graphics, n2, n3);
        graphics.translate(2, 0);
        this.menu_icon(graphics, n2, n3);
        graphics.translate(-2, 0);
    }

    private void menu_button_prelight(Graphics graphics, int n2, int n3) {
        this.left_corner_button_bg(graphics, n2, n3);
        this.prelight_tint(graphics, n2, n3);
        graphics.translate(2, 0);
        this.menu_icon(graphics, n2, n3);
        graphics.translate(-2, 0);
        this.left_corner_outline(graphics, n2, n3);
    }

    private void menu_button_pressed(Graphics graphics, int n2, int n3) {
        this.left_corner_button_bg(graphics, n2, n3);
        this.darken_tint(graphics, n2, n3);
        graphics.translate(2, 0);
        this.menu_icon(graphics, n2, n3);
        graphics.translate(-2, 0);
    }

    private void menu_icon(Graphics graphics, int n2, int n3) {
        Image image = this.getImage("menu", this.getColor(1, GTKColorType.FOREGROUND));
        this.drawImage(graphics, image, this.getColor(1, GTKColorType.FOREGROUND), 0.7f, (n2 - image.getWidth(null) - 1) / 2, (n3 - image.getHeight(null)) / 2);
    }

    private void minimize_icon(Graphics graphics, int n2, int n3) {
        Image image = this.getImage("minimize", this.getColor(1, GTKColorType.FOREGROUND));
        this.drawImage(graphics, image, this.getColor(1, GTKColorType.FOREGROUND), 0.7f, (n2 - image.getWidth(null)) / 2, (n3 - image.getHeight(null)) / 2);
    }

    private void outer_bevel(Graphics graphics, int n2, int n3) {
        Metacity.FrameGeometry frameGeometry = this.getFrameGeometry();
        graphics.setColor(Color.black);
        graphics.drawLine(5, 0, n2 - 6, 0);
        graphics.drawLine(5, n3 - 1, n2 - 6, n3 - 1);
        graphics.drawLine(0, 5, 0, n3 - 6);
        graphics.drawLine(n2 - 1, 5, n2 - 1, n3 - 6);
        graphics.setColor(this.blendColor(this.getColor(1, GTKColorType.LIGHT), Color.white, 0.7f));
        graphics.drawLine(1, 3, 1, n3 - 4);
        graphics.setColor(this.getColor(1, GTKColorType.DARK));
        graphics.drawLine(frameGeometry.left_width - 1, frameGeometry.top_height - 1, frameGeometry.left_width - 1, n3 - frameGeometry.bottom_height);
        graphics.setColor(this.blendColor(this.getColor(1, GTKColorType.BACKGROUND), Color.black, 0.2f));
        graphics.drawLine(3, n3 - 2, n2 - 4, n3 - 2);
        graphics.setColor(this.getColor(1, GTKColorType.DARK));
        graphics.drawLine(frameGeometry.left_width, n3 - frameGeometry.bottom_height, n2 - frameGeometry.right_width, n3 - frameGeometry.bottom_height);
        graphics.setColor(this.blendColor(this.getColor(1, GTKColorType.LIGHT), Color.white, 0.7f));
        graphics.drawLine(frameGeometry.left_width, n3 - frameGeometry.bottom_height + 1, n2 - frameGeometry.right_width, n3 - frameGeometry.bottom_height + 1);
        graphics.setColor(this.getColor(1, GTKColorType.DARK));
        graphics.drawLine(n2 - frameGeometry.right_width, frameGeometry.top_height - 1, n2 - frameGeometry.right_width, n3 - frameGeometry.bottom_height);
        graphics.setColor(this.blendColor(this.getColor(1, GTKColorType.LIGHT), Color.white, 0.7f));
        graphics.drawLine(n2 - frameGeometry.right_width + 1, frameGeometry.top_height - 1, n2 - frameGeometry.right_width + 1, n3 - frameGeometry.bottom_height + 1);
        graphics.setColor(this.blendColor(this.getColor(1, GTKColorType.BACKGROUND), Color.black, 0.2f));
        graphics.drawLine(n2 - 2, 3, n2 - 2, n3 - 4);
    }

    private void prelight_tint(Graphics graphics, int n2, int n3) {
        this.tintRect(graphics, 1, 1, n2 - 2, n3 - 2, this.getColor(2, GTKColorType.BACKGROUND), 0.4f);
    }

    private void right_corner_button_bg(Graphics graphics, int n2, int n3) {
        this.button_generic_bg_before(graphics, n2, n3);
        this.button_generic_bg_after(graphics, n2, n3);
        this.right_corner_outline(graphics, n2, n3);
        graphics.setColor(MetacityBluecurve.shadeColor(this.getColor(1, GTKColorType.BACKGROUND), 1.2f));
        graphics.drawLine(0, 0, n2 - 6, 0);
        graphics.setColor(MetacityBluecurve.shadeColor(this.getColor(1, GTKColorType.BACKGROUND), 1.1f));
        graphics.drawLine(n2 - 4, 1, n2 - 5, 1);
        graphics.setColor(MetacityBluecurve.shadeColor(this.getColor(1, GTKColorType.BACKGROUND), 0.9f));
        graphics.drawLine(n2 - 3, 2, n2 - 3, 3);
        graphics.setColor(MetacityBluecurve.shadeColor(this.getColor(1, GTKColorType.BACKGROUND), 0.8f));
        graphics.drawLine(n2 - 2, 4, n2 - 2, n3 - 2);
    }

    private void right_corner_button_bg_unfocused(Graphics graphics, int n2, int n3) {
        this.button_generic_bg_before_unfocused(graphics, n2, n3);
        this.right_corner_outline(graphics, n2, n3);
        graphics.setColor(MetacityBluecurve.shadeColor(this.getColor(8, GTKColorType.BACKGROUND), 1.2f));
        graphics.drawLine(0, 0, n2 - 6, 0);
        graphics.setColor(MetacityBluecurve.shadeColor(this.getColor(8, GTKColorType.BACKGROUND), 1.1f));
        graphics.drawLine(n2 - 4, 1, n2 - 5, 1);
        graphics.setColor(MetacityBluecurve.shadeColor(this.getColor(8, GTKColorType.BACKGROUND), 0.9f));
        graphics.drawLine(n2 - 3, 2, n2 - 3, 3);
        graphics.setColor(MetacityBluecurve.shadeColor(this.getColor(8, GTKColorType.BACKGROUND), 0.8f));
        graphics.drawLine(n2 - 2, 4, n2 - 2, n3 - 2);
    }

    private void right_corner_outline(Graphics graphics, int n2, int n3) {
        graphics.setColor(Color.black);
        graphics.drawLine(n2 - 1, 4, n2 - 1, n3);
        graphics.drawLine(n2 - 5, 0, n2 - 4, 0);
        graphics.drawLine(n2 - 3, 1, n2 - 3, 1);
        graphics.drawLine(n2 - 2, 2, n2 - 2, 3);
    }

    private void titlebar_bg_unfocused(Graphics graphics, int n2, int n3) {
        this.drawVerticalGradient(graphics, MetacityBluecurve.shadeColor(this.getColor(8, GTKColorType.BACKGROUND), 1.0f), MetacityBluecurve.shadeColor(this.getColor(8, GTKColorType.BACKGROUND), 0.9f), 0, 0, n2, n3);
        graphics.setColor(MetacityBluecurve.shadeColor(this.getColor(8, GTKColorType.BACKGROUND), 0.6f));
        graphics.drawLine(0, n3 - 1, n2, n3 - 1);
        graphics.setColor(MetacityBluecurve.shadeColor(this.getColor(8, GTKColorType.BACKGROUND), 1.2f));
        graphics.drawLine(0, 0, n2, 0);
    }

    private void unfocus_background(Graphics graphics, int n2, int n3) {
        this.outer_bevel(graphics, n2, n3);
        this.corners_unfocused(graphics, n2, n3);
    }

    private void maximize_button(Graphics graphics, int n2, int n3, boolean bl2) {
        if (bl2) {
            this.right_corner_button_bg(graphics, n2, n3);
        } else {
            this.center_button_bg(graphics, n2, n3);
        }
        this.maximize_icon(graphics, n2, n3);
    }

    private void maximize_button_prelight(Graphics graphics, int n2, int n3, boolean bl2) {
        if (bl2) {
            this.right_corner_button_bg(graphics, n2, n3);
        } else {
            this.center_button_bg(graphics, n2, n3);
        }
        this.prelight_tint(graphics, n2, n3);
        this.maximize_icon(graphics, n2, n3);
    }

    private void maximize_button_pressed(Graphics graphics, int n2, int n3, boolean bl2) {
        if (bl2) {
            this.right_corner_button_bg(graphics, n2, n3);
        } else {
            this.center_button_bg(graphics, n2, n3);
        }
        this.darken_tint(graphics, n2, n3);
        this.maximize_icon(graphics, n2, n3);
    }

    private void minimize_button(Graphics graphics, int n2, int n3, boolean bl2) {
        if (bl2) {
            this.right_corner_button_bg(graphics, n2, n3);
        } else {
            this.center_button_bg(graphics, n2, n3);
        }
        this.minimize_icon(graphics, n2, n3);
    }

    private void minimize_button_prelight(Graphics graphics, int n2, int n3, boolean bl2) {
        if (bl2) {
            this.right_corner_button_bg(graphics, n2, n3);
        } else {
            this.center_button_bg(graphics, n2, n3);
        }
        this.prelight_tint(graphics, n2, n3);
        this.minimize_icon(graphics, n2, n3);
    }

    private void minimize_button_pressed(Graphics graphics, int n2, int n3, boolean bl2) {
        if (bl2) {
            this.right_corner_button_bg(graphics, n2, n3);
        } else {
            this.center_button_bg(graphics, n2, n3);
        }
        this.darken_tint(graphics, n2, n3);
        this.minimize_icon(graphics, n2, n3);
    }

    protected MetacityBluecurve(String string) {
        super(string, normalFrameGeometry);
    }

    void paintButtonBackground(SynthContext synthContext, Graphics graphics, int n2, int n3, int n4, int n5) {
        JInternalFrame jInternalFrame;
        this.context = synthContext;
        JButton jButton = (JButton)synthContext.getComponent();
        String string = jButton.getName();
        int n6 = synthContext.getComponentState();
        JComponent jComponent = (JComponent)jButton.getParent();
        Container container = jComponent.getParent();
        if (container instanceof JInternalFrame) {
            jInternalFrame = (JInternalFrame)container;
        } else if (container instanceof JInternalFrame.JDesktopIcon) {
            jInternalFrame = ((JInternalFrame.JDesktopIcon)container).getInternalFrame();
        } else {
            return;
        }
        boolean bl2 = jInternalFrame.isSelected();
        this.setFrameGeometry(jComponent, jInternalFrame.isMaximum() ? normalMaximizedFrameGeometry : normalFrameGeometry);
        if (string.equals("InternalFrameTitlePane.menuButton")) {
            if ((n6 & 4) != 0) {
                this.menu_button_pressed(graphics, n4, n5);
            } else if ((n6 & 2) != 0) {
                this.menu_button_prelight(graphics, n4, n5);
            } else {
                this.menu_button(graphics, n4, n5);
            }
        } else if (string.equals("InternalFrameTitlePane.iconifyButton")) {
            boolean bl3;
            boolean bl4 = bl3 = !jInternalFrame.isClosable() && !jInternalFrame.isMaximizable();
            if ((n6 & 4) != 0) {
                this.minimize_button_pressed(graphics, n4, n5, bl3);
            } else if ((n6 & 2) != 0) {
                this.minimize_button_prelight(graphics, n4, n5, bl3);
            } else {
                this.minimize_button(graphics, n4, n5, bl3);
            }
        } else if (string.equals("InternalFrameTitlePane.maximizeButton")) {
            boolean bl5;
            boolean bl6 = bl5 = !jInternalFrame.isClosable();
            if ((n6 & 4) != 0) {
                this.maximize_button_pressed(graphics, n4, n5, bl5);
            } else if ((n6 & 2) != 0) {
                this.maximize_button_prelight(graphics, n4, n5, bl5);
            } else {
                this.maximize_button(graphics, n4, n5, bl5);
            }
        } else if (string.equals("InternalFrameTitlePane.closeButton")) {
            if ((n6 & 4) != 0) {
                this.close_button_pressed(graphics, n4, n5);
            } else if ((n6 & 2) != 0) {
                this.close_button_prelight(graphics, n4, n5);
            } else {
                this.close_button(graphics, n4, n5);
            }
        }
    }

    void paintFrameBorder(SynthContext synthContext, Graphics graphics, int n2, int n3, int n4, int n5) {
        this.context = synthContext;
        JInternalFrame jInternalFrame = (JInternalFrame)synthContext.getComponent();
        JComponent jComponent = MetacityBluecurve.findChild(jInternalFrame, "InternalFrame.northPane");
        jInternalFrame.setOpaque(false);
        MetacityBluecurve.findChild(jComponent, "InternalFrameTitlePane.closeButton").setOpaque(false);
        boolean bl2 = jInternalFrame.isSelected();
        Metacity.FrameGeometry frameGeometry = jInternalFrame.isMaximum() ? normalMaximizedFrameGeometry : normalFrameGeometry;
        this.setFrameGeometry(jComponent, frameGeometry);
        Font font = graphics.getFont();
        graphics.setFont(jComponent.getFont());
        graphics.translate(n2, n3);
        graphics.setColor(jInternalFrame.getBackground());
        graphics.fillRect(0, frameGeometry.top_height, frameGeometry.left_width, n5 - frameGeometry.top_height - frameGeometry.bottom_height);
        graphics.fillRect(n4 - frameGeometry.right_width - 1, frameGeometry.top_height, frameGeometry.right_width, n5 - frameGeometry.top_height - frameGeometry.bottom_height);
        graphics.fillRect(frameGeometry.left_width, n5 - frameGeometry.bottom_height - 1, n4 - frameGeometry.left_width - frameGeometry.right_width, frameGeometry.bottom_height);
        int n6 = 0;
        int n7 = n4;
        JComponent jComponent2 = MetacityBluecurve.findChild(jComponent, "InternalFrameTitlePane.menuButton");
        if (jComponent2 != null) {
            int n8 = jComponent2.getX() + jComponent2.getWidth() - n2;
            n6 += n8;
            n7 -= n8;
        }
        JComponent jComponent3 = null;
        if (jInternalFrame.isIconifiable()) {
            jComponent3 = MetacityBluecurve.findChild(jComponent, "InternalFrameTitlePane.iconifyButton");
        }
        if (jComponent3 == null && jInternalFrame.isMaximizable()) {
            jComponent3 = MetacityBluecurve.findChild(jComponent, "InternalFrameTitlePane.maximizeButton");
        }
        if (jComponent3 == null && jInternalFrame.isClosable()) {
            jComponent3 = MetacityBluecurve.findChild(jComponent, "InternalFrameTitlePane.closeButton");
        }
        if (jComponent3 != null) {
            n7 = Math.min(n4, jComponent3.getX() - n2);
        }
        if (!bl2) {
            this.unfocus_background(graphics, n4, n5);
            graphics.translate(n6, 1);
            this.title_normal(graphics, n7, jComponent.getHeight() - 1, jInternalFrame);
            graphics.translate(-n6, -1);
        } else {
            this.focus_background(graphics, n4, n5);
            graphics.translate(n6, 1);
            this.title_focused(graphics, n7, jComponent.getHeight() - 1, jInternalFrame);
            graphics.translate(-n6, -1);
        }
        graphics.translate(-n2, -n3);
        graphics.setFont(font);
    }

    private Image getImage(String string) {
        Image image = (Image)this.images.get(string);
        if (image == null) {
            if (this.themeDir != null) {
                String string2 = this.themeDir + File.separator + string + ".png";
                image = (Image)AccessController.doPrivileged(new PrivilegedAction(this, string2){
                    private final String val$file;
                    private final MetacityBluecurve this$0;

                    public Object run() {
                        return new ImageIcon(this.val$file).getImage();
                    }
                    {
                        this.this$0 = metacityBluecurve;
                        this.val$file = string;
                    }
                });
            } else {
                String string3 = "resources/metacity/" + string + ".png";
                URL uRL = this.getClass().getResource(string3);
                if (uRL != null) {
                    image = new ImageIcon(uRL).getImage();
                }
            }
            if (image != null) {
                this.images.put(string, image);
            }
        }
        return image;
    }

    private void paintTitle(Graphics graphics, int n2, int n3, JInternalFrame jInternalFrame) {
        String string = jInternalFrame.getTitle();
        if (string != null) {
            if (jInternalFrame.getComponentOrientation().isLeftToRight()) {
                string = this.getTitle(string, graphics.getFontMetrics(), this.calculateTitleWidth(graphics, jInternalFrame));
            }
            graphics.drawString(string, n2, n3 + graphics.getFontMetrics().getAscent());
        }
    }

    private void title_focused(Graphics graphics, int n2, int n3, JInternalFrame jInternalFrame) {
        this.title_gradient(graphics, n2, n3, jInternalFrame);
        this.title_text_focused_no_icon(graphics, n2, n3, jInternalFrame);
        graphics.setColor(this.blendColor(this.getColor(512, GTKColorType.BACKGROUND), this.getColor(512, GTKColorType.FOREGROUND), 0.4f));
        graphics.drawLine(0, 0, 0, n3);
        graphics.drawLine(n2 - 1, 0, n2 - 1, n3);
    }

    private void title_gradient(Graphics graphics, int n2, int n3, JInternalFrame jInternalFrame) {
        int n4 = this.calculateTitleWidth(graphics, jInternalFrame);
        this.left_corner_outline(graphics, n2, n3);
        this.right_corner_outline(graphics, n2, n3);
        this.drawVerticalGradient(graphics, MetacityBluecurve.shadeColor(this.getColor(512, GTKColorType.BACKGROUND), 1.4f), MetacityBluecurve.shadeColor(this.getColor(512, GTKColorType.BACKGROUND), 1.0f), MetacityBluecurve.shadeColor(this.getColor(512, GTKColorType.BACKGROUND), 0.8f), 0, 0, n2, n3 - 1);
        Image image = this.getImage("white_stripes_tile");
        this.tileImage(graphics, image, Math.max(6 + n4 - 40, 1), 2, n2 - (6 + n4 - 40) - 2, n3 - 4, new float[]{0.0f, 0.3f, 0.4f, 0.4f});
        this.drawDiagonalGradient(graphics, MetacityBluecurve.shadeColor(this.getColor(512, GTKColorType.BACKGROUND), 2.0f), MetacityBluecurve.shadeColor(this.getColor(512, GTKColorType.BACKGROUND), 1.7f), 0, 0, n2, 2, 0.2f);
        this.drawVerticalGradient(graphics, MetacityBluecurve.shadeColor(this.getColor(512, GTKColorType.BACKGROUND), 2.0f), MetacityBluecurve.shadeColor(this.getColor(512, GTKColorType.BACKGROUND), 1.4f), 0, 0, n2, 1, 0.4f);
        this.drawDiagonalGradient(graphics, MetacityBluecurve.shadeColor(this.getColor(512, GTKColorType.BACKGROUND), 0.8f), MetacityBluecurve.shadeColor(this.getColor(512, GTKColorType.BACKGROUND), 0.5f), 0, n3 - 2, n2, 2, 0.2f);
        this.drawVerticalGradient(graphics, MetacityBluecurve.shadeColor(this.getColor(512, GTKColorType.BACKGROUND), 1.0f), MetacityBluecurve.shadeColor(this.getColor(512, GTKColorType.BACKGROUND), 0.7f), 0, n3 - 2, n2, 1, 0.9f);
        graphics.setColor(MetacityBluecurve.shadeColor(this.getColor(512, GTKColorType.BACKGROUND), 0.1f));
        graphics.drawLine(0, n3 - 1, n2, n3 - 1);
    }

    private void title_normal(Graphics graphics, int n2, int n3, JInternalFrame jInternalFrame) {
        this.titlebar_bg_unfocused(graphics, n2, n3);
        this.title_text_no_icon(graphics, n2, n3, jInternalFrame);
        graphics.setColor(this.blendColor(this.getColor(8, GTKColorType.BACKGROUND), this.getColor(8, GTKColorType.FOREGROUND), 0.3f));
        graphics.drawLine(0, 0, 0, n3 - 2);
        graphics.drawLine(n2 - 1, 0, n2 - 1, n3 - 2);
    }

    private void title_text_focused_no_icon(Graphics graphics, int n2, int n3, JInternalFrame jInternalFrame) {
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n4 = fontMetrics.getAscent() + fontMetrics.getDescent();
        Rectangle rectangle = graphics.getClipBounds();
        graphics.setClip(0, 0, n2 - 8, n3);
        graphics.setColor(this.blendColor(this.getColor(1, GTKColorType.TEXT_FOREGROUND), this.getColor(512, GTKColorType.BACKGROUND), 0.7f));
        this.paintTitle(graphics, 7, Math.max((n3 - n4) / 2, 0) + 1, jInternalFrame);
        graphics.setColor(this.getColor(512, ColorType.TEXT_FOREGROUND));
        this.paintTitle(graphics, 6, Math.max((n3 - n4) / 2, 0), jInternalFrame);
        graphics.setClip(rectangle);
    }

    private void title_text_no_icon(Graphics graphics, int n2, int n3, JInternalFrame jInternalFrame) {
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n4 = fontMetrics.getAscent() + fontMetrics.getDescent();
        Rectangle rectangle = graphics.getClipBounds();
        graphics.setClip(0, 0, n2 - 8, n3);
        graphics.setColor(this.blendColor(this.getColor(8, GTKColorType.TEXT_FOREGROUND), this.getColor(8, GTKColorType.BACKGROUND), 0.0f));
        this.paintTitle(graphics, 6, Math.max((n3 - n4) / 2, 0), jInternalFrame);
        graphics.setClip(rectangle);
    }

    private int calculateTitleWidth(Graphics graphics, JInternalFrame jInternalFrame) {
        Metacity.FrameGeometry frameGeometry = this.getFrameGeometry();
        String string = jInternalFrame.getTitle();
        if (string != null) {
            JComponent jComponent = MetacityBluecurve.findChild(jInternalFrame, "InternalFrame.northPane");
            JComponent jComponent2 = null;
            if (jInternalFrame.isIconifiable()) {
                jComponent2 = MetacityBluecurve.findChild(jComponent, "InternalFrameTitlePane.iconifyButton");
            }
            if (jComponent2 == null && jInternalFrame.isMaximizable()) {
                jComponent2 = MetacityBluecurve.findChild(jComponent, "InternalFrameTitlePane.maximizeButton");
            }
            if (jComponent2 == null && jInternalFrame.isClosable()) {
                jComponent2 = MetacityBluecurve.findChild(jComponent, "InternalFrameTitlePane.closeButton");
            }
            int n2 = jComponent2 != null ? jComponent2.getX() : jComponent.getWidth() - frameGeometry.right_titlebar_edge;
            return SwingUtilities.computeStringWidth(graphics.getFontMetrics(), string);
        }
        return 0;
    }

    private void drawImage(Graphics graphics, Image image, Color color, float f2, int n2, int n3) {
        if (graphics instanceof Graphics2D) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Composite composite = graphics2D.getComposite();
            graphics2D.setComposite(AlphaComposite.getInstance(3, f2));
            graphics2D.drawImage(image, n2, n3, null);
            graphics2D.setComposite(composite);
        }
    }

    private Image getImage(String string, Color color) {
        Image image = (Image)this.images.get(string + "-" + color.getRGB());
        if (image == null && (image = this.colorizeImage(this.getImage(string), color)) != null) {
            this.images.put(string + "-" + color.getRGB(), image);
        }
        return image;
    }

    Insets getBorderInsets(SynthContext synthContext, Insets insets) {
        Metacity.FrameGeometry frameGeometry = this.getFrameGeometry();
        if (insets == null) {
            insets = new Insets(0, 0, 0, 0);
        }
        insets.top = frameGeometry.title_border.top;
        insets.bottom = frameGeometry.bottom_height;
        insets.left = frameGeometry.left_width;
        insets.right = frameGeometry.right_width;
        return insets;
    }

    private String getTitle(String string, FontMetrics fontMetrics, int n2) {
        if (string == null || string.equals("")) {
            return "";
        }
        int n3 = SwingUtilities.computeStringWidth(fontMetrics, string);
        String string2 = "...";
        if (n3 > n2) {
            int n4;
            int n5 = SwingUtilities.computeStringWidth(fontMetrics, string2);
            for (n4 = 0; n4 < string.length() && (n5 += fontMetrics.charWidth(string.charAt(n4))) <= n2; ++n4) {
            }
            string = string.substring(0, n4) + string2;
        }
        return string;
    }

    private static class NormalFrameGeometry
    extends Metacity.FrameGeometry {
        NormalFrameGeometry() {
            this.left_width = 6;
            this.right_width = 6;
            this.bottom_height = 6;
            this.left_titlebar_edge = 0;
            this.right_titlebar_edge = 0;
            this.title_vertical_pad = 3;
            this.title_border = new Insets(1, 0, 0, 0);
            this.button_border = new Insets(1, 0, 0, 0);
            this.aspect_ratio = 0.9f;
        }
    }

    private static class NormalMaximizedFrameGeometry
    extends NormalFrameGeometry {
        NormalMaximizedFrameGeometry() {
            this.left_width = 0;
            this.right_width = 0;
            this.bottom_height = 0;
            this.left_titlebar_edge = 0;
            this.right_titlebar_edge = 0;
        }
    }
}

