/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.gtk;

import com.sun.java.swing.plaf.gtk.ColorType;
import com.sun.java.swing.plaf.gtk.Region;
import com.sun.java.swing.plaf.gtk.SynthContext;
import com.sun.java.swing.plaf.gtk.SynthPainter;
import com.sun.java.swing.plaf.gtk.SynthStyle;
import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;

class DefaultSynthStyle
extends SynthStyle
implements Cloneable {
    private boolean opaque;
    private Insets insets;
    StateInfo[] states;
    Map data;

    protected DefaultSynthStyle() {
    }

    public DefaultSynthStyle(DefaultSynthStyle defaultSynthStyle) {
        this.opaque = defaultSynthStyle.opaque;
        if (defaultSynthStyle.insets != null) {
            this.insets = new Insets(defaultSynthStyle.insets.top, defaultSynthStyle.insets.left, defaultSynthStyle.insets.bottom, defaultSynthStyle.insets.right);
        }
        if (defaultSynthStyle.states != null) {
            this.states = new StateInfo[defaultSynthStyle.states.length];
            for (int i2 = defaultSynthStyle.states.length - 1; i2 >= 0; --i2) {
                this.states[i2] = (StateInfo)defaultSynthStyle.states[i2].clone();
            }
        }
        if (defaultSynthStyle.data != null) {
            this.data = new HashMap();
            this.data.putAll(defaultSynthStyle.data);
        }
    }

    StateInfo getStateInfo(int n2) {
        if (this.states != null) {
            int n3 = 0;
            int n4 = -1;
            for (int i2 = this.states.length - 1; i2 >= 0; --i2) {
                int n5 = StateInfo.access$000(this.states[i2], n2);
                if (n5 <= n3) continue;
                n4 = i2;
                n3 = n5;
            }
            if (n4 != -1) {
                return this.states[n4];
            }
        }
        return null;
    }

    public boolean isOpaque(SynthContext synthContext) {
        return this.opaque;
    }

    public Object clone() {
        DefaultSynthStyle defaultSynthStyle;
        try {
            defaultSynthStyle = (DefaultSynthStyle)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
        if (this.states != null) {
            defaultSynthStyle.states = new StateInfo[this.states.length];
            for (int i2 = this.states.length - 1; i2 >= 0; --i2) {
                defaultSynthStyle.states[i2] = (StateInfo)this.states[i2].clone();
            }
        }
        if (this.data != null) {
            defaultSynthStyle.data = new HashMap();
            defaultSynthStyle.data.putAll(this.data);
        }
        return defaultSynthStyle;
    }

    public DefaultSynthStyle addTo(DefaultSynthStyle defaultSynthStyle) {
        if (this.insets != null) {
            defaultSynthStyle.insets = this.insets;
        }
        defaultSynthStyle.opaque = this.opaque;
        if (this.states != null) {
            if (defaultSynthStyle.states == null) {
                defaultSynthStyle.states = new StateInfo[this.states.length];
                for (int i2 = this.states.length - 1; i2 >= 0; --i2) {
                    if (this.states[i2] == null) continue;
                    defaultSynthStyle.states[i2] = (StateInfo)this.states[i2].clone();
                }
            } else {
                int n2;
                int n3;
                int n4;
                int n5 = 0;
                for (int i3 = this.states.length - 1; i3 >= 0; --i3) {
                    n4 = this.states[i3].getComponentState();
                    n3 = 0;
                    for (n2 = defaultSynthStyle.states.length - 1; n2 >= 0; --n2) {
                        if (n4 != defaultSynthStyle.states[n2].getComponentState()) continue;
                        this.states[i3].addTo(defaultSynthStyle.states[n2]);
                        n3 = 1;
                        break;
                    }
                    if (n3 != 0) continue;
                    ++n5;
                }
                if (n5 != 0) {
                    StateInfo[] stateInfoArray = new StateInfo[n5 + defaultSynthStyle.states.length];
                    n4 = defaultSynthStyle.states.length;
                    System.arraycopy(defaultSynthStyle.states, 0, stateInfoArray, 0, defaultSynthStyle.states.length);
                    for (n3 = this.states.length - 1; n3 >= 0; --n3) {
                        n2 = this.states[n3].getComponentState();
                        boolean bl2 = false;
                        for (int i4 = defaultSynthStyle.states.length - 1; i4 >= 0; --i4) {
                            if (n2 != defaultSynthStyle.states[i4].getComponentState()) continue;
                            bl2 = true;
                            break;
                        }
                        if (bl2) continue;
                        stateInfoArray[n4++] = (StateInfo)this.states[n3].clone();
                    }
                    defaultSynthStyle.states = stateInfoArray;
                }
            }
        }
        if (this.data != null) {
            if (defaultSynthStyle.data == null) {
                defaultSynthStyle.data = new HashMap();
            }
            defaultSynthStyle.data.putAll(this.data);
        }
        return defaultSynthStyle;
    }

    public SynthPainter getBackgroundPainter(SynthContext synthContext) {
        StateInfo stateInfo = this.getStateInfo(synthContext.getComponentState());
        if (stateInfo != null) {
            return stateInfo.getBackgroundPainter();
        }
        return null;
    }

    public SynthPainter getBorderPainter(SynthContext synthContext) {
        StateInfo stateInfo = this.getStateInfo(synthContext.getComponentState());
        if (stateInfo != null) {
            return stateInfo.getBorderPainter();
        }
        return null;
    }

    protected Font _getFont(JComponent jComponent, Region region, int n2) {
        StateInfo stateInfo = this.getStateInfo(n2);
        if (stateInfo != null) {
            return stateInfo.getFont();
        }
        return null;
    }

    public Insets getInsets(SynthContext synthContext, Insets insets) {
        if (insets == null) {
            insets = new Insets(0, 0, 0, 0);
        }
        if (this.insets != null) {
            insets.left = this.insets.left;
            insets.right = this.insets.right;
            insets.top = this.insets.top;
            insets.bottom = this.insets.bottom;
        } else {
            insets.bottom = 0;
            insets.top = 0;
            insets.right = 0;
            insets.left = 0;
        }
        return insets;
    }

    public Object get(SynthContext synthContext, Object object) {
        if (this.data != null) {
            return this.data.get(object);
        }
        return null;
    }

    public DefaultSynthStyle(Insets insets, boolean bl2, StateInfo[] stateInfoArray, Map map) {
        this.insets = insets;
        this.opaque = bl2;
        this.states = stateInfoArray;
        this.data = map;
    }

    protected Color _getColor(JComponent jComponent, Region region, int n2, ColorType colorType) {
        StateInfo stateInfo = this.getStateInfo(n2);
        if (stateInfo != null) {
            return stateInfo.getColor(colorType);
        }
        return null;
    }

    public static class StateInfo {
        private SynthPainter borderPainter;
        private SynthPainter backgroundPainter;
        private Font font;
        Color[] colors;
        private int state;

        public int getComponentState() {
            return this.state;
        }

        private final int getMatchCount(int n2) {
            n2 &= this.state;
            n2 -= (0xAAAAAAAA & n2) >>> 1;
            n2 = (n2 & 0x33333333) + (n2 >>> 2 & 0x33333333);
            n2 = n2 + (n2 >>> 4) & 0xF0F0F0F;
            n2 += n2 >>> 8;
            n2 += n2 >>> 16;
            return n2 & 0xFF;
        }

        public StateInfo(StateInfo stateInfo) {
            this.state = stateInfo.state;
            this.borderPainter = stateInfo.borderPainter;
            this.backgroundPainter = stateInfo.backgroundPainter;
            this.font = stateInfo.font;
            if (stateInfo.colors != null) {
                this.colors = new Color[stateInfo.colors.length];
                System.arraycopy(stateInfo.colors, 0, this.colors, 0, stateInfo.colors.length);
            }
        }

        static int access$000(StateInfo stateInfo, int n2) {
            return stateInfo.getMatchCount(n2);
        }

        public SynthPainter getBackgroundPainter() {
            return this.backgroundPainter;
        }

        public SynthPainter getBorderPainter() {
            return this.borderPainter;
        }

        protected Color[] getColors() {
            return this.colors;
        }

        public Font getFont() {
            return this.font;
        }

        public Object clone() {
            return new StateInfo(this);
        }

        public StateInfo addTo(StateInfo stateInfo) {
            stateInfo.borderPainter = this.borderPainter;
            stateInfo.backgroundPainter = this.backgroundPainter;
            if (this.font != null) {
                stateInfo.font = this.font;
            }
            if (this.colors != null) {
                if (stateInfo.colors == null) {
                    stateInfo.colors = new Color[this.colors.length];
                    System.arraycopy(this.colors, 0, stateInfo.colors, 0, this.colors.length);
                } else {
                    if (stateInfo.colors.length < this.colors.length) {
                        Color[] colorArray = stateInfo.colors;
                        stateInfo.colors = new Color[this.colors.length];
                        System.arraycopy(colorArray, 0, stateInfo.colors, 0, colorArray.length);
                    }
                    for (int i2 = this.colors.length - 1; i2 >= 0; --i2) {
                        if (this.colors[i2] == null) continue;
                        stateInfo.colors[i2] = this.colors[i2];
                    }
                }
            }
            return stateInfo;
        }

        public Color getColor(ColorType colorType) {
            int n2;
            if (this.colors != null && (n2 = colorType.getID()) < this.colors.length) {
                return this.colors[n2];
            }
            return null;
        }

        public StateInfo(int n2, SynthPainter synthPainter, SynthPainter synthPainter2, Font font, Color[] colorArray) {
            this.state = n2;
            this.borderPainter = synthPainter;
            this.backgroundPainter = synthPainter2;
            this.font = font;
            this.colors = colorArray;
        }
    }
}

