/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jnlp;

import com.sun.javaws.debug.Debug;
import com.sun.javaws.debug.Globals;
import java.applet.AudioClip;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Map;

final class AppletAudioClip
implements AudioClip {
    private static Constructor acConstructor = null;
    private URL url;
    private AudioClip audioClip;
    private static Map audioClips = new HashMap();

    public AppletAudioClip() {
        this.url = null;
        this.audioClip = null;
    }

    public synchronized void loop() {
        if (this.audioClip != null) {
            this.audioClip.loop();
        }
    }

    public synchronized void play() {
        if (this.audioClip != null) {
            this.audioClip.play();
        }
    }

    public synchronized void stop() {
        if (this.audioClip != null) {
            this.audioClip.stop();
        }
    }

    void createAppletAudioClip(InputStream inputStream) throws IOException {
        if (acConstructor == null) {
            if (Globals.TraceAppletViewer) {
                Debug.println("Initializing AudioClip constructor.");
            }
            try {
                acConstructor = (Constructor)AccessController.doPrivileged(new PrivilegedExceptionAction(this){
                    private final AppletAudioClip this$0;
                    {
                        this.this$0 = appletAudioClip;
                    }

                    public Object run() throws NoSuchMethodException, SecurityException, ClassNotFoundException {
                        Class<?> clazz;
                        block3: {
                            clazz = null;
                            try {
                                clazz = Class.forName("com.sun.media.sound.JavaSoundAudioClip", true, ClassLoader.getSystemClassLoader());
                                if (Globals.TraceAppletViewer) {
                                    Debug.println("Loaded JavaSoundAudioClip");
                                }
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                clazz = Class.forName("sun.audio.SunAudioClip", true, null);
                                if (!Globals.TraceAppletViewer) break block3;
                                Debug.println("Loaded SunAudioClip");
                            }
                        }
                        Class[] classArray = new Class[]{Class.forName("java.io.InputStream")};
                        return clazz.getConstructor(classArray);
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                if (Globals.TraceAppletViewer) {
                    Debug.println("Got a PrivilegedActionException: " + privilegedActionException.getException());
                }
                throw new IOException("Failed to get AudioClip constructor: " + privilegedActionException.getException());
            }
        }
        try {
            Object[] objectArray = new Object[]{inputStream};
            this.audioClip = (AudioClip)acConstructor.newInstance(objectArray);
        }
        catch (Exception exception) {
            throw new IOException("Failed to construct the AudioClip: " + exception);
        }
    }

    public AppletAudioClip(URL uRL) {
        block2: {
            this.url = null;
            this.audioClip = null;
            this.url = uRL;
            try {
                InputStream inputStream = uRL.openStream();
                this.createAppletAudioClip(inputStream);
            }
            catch (IOException iOException) {
                if (!Globals.TraceAppletViewer) break block2;
                Debug.println("IOException creating AppletAudioClip" + iOException);
            }
        }
    }

    private static void checkConnect(URL uRL) {
        block3: {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager == null) break block3;
            try {
                Permission permission = uRL.openConnection().getPermission();
                if (permission != null) {
                    securityManager.checkPermission(permission);
                    break block3;
                }
                securityManager.checkConnect(uRL.getHost(), uRL.getPort());
            }
            catch (IOException iOException) {
                securityManager.checkConnect(uRL.getHost(), uRL.getPort());
            }
        }
    }

    public static synchronized AudioClip get(URL uRL) {
        AppletAudioClip.checkConnect(uRL);
        AudioClip audioClip = (AudioClip)audioClips.get(uRL);
        if (audioClip == null) {
            audioClip = new AppletAudioClip(uRL);
            audioClips.put(uRL, audioClip);
        }
        return audioClip;
    }
}

