/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.ui.prefs;

import com.sun.javaws.LocalInstallHandler;
import com.sun.javaws.Resources;
import com.sun.javaws.debug.Debug;
import com.sun.javaws.security.CertificatePanel;
import com.sun.javaws.ui.general.Subcontroller;
import com.sun.javaws.ui.prefs.AdvancedPanel;
import com.sun.javaws.ui.prefs.InstallPanel;
import com.sun.javaws.ui.prefs.JREPanel;
import com.sun.javaws.ui.prefs.SubcontrollerCreator;
import com.sun.javaws.ui.prefs.UnixGeneralPanel;

public class UnixSubcontrollerCreator
extends SubcontrollerCreator {
    private Subcontroller[] _controllers;
    private String[] _names;
    private int _len;
    private boolean _lih;

    public int getSubcontrollerCount() {
        return this._len;
    }

    public UnixSubcontrollerCreator() {
        LocalInstallHandler localInstallHandler = LocalInstallHandler.getInstance();
        this._lih = localInstallHandler != null && localInstallHandler.isLocalInstallSupported();
        this._len = this._lih ? 5 : 4;
        this._names = new String[this._len];
        this._controllers = new Subcontroller[this._len];
        this._names[0] = Resources.getString("controlpanel.general.tabTitle");
        this._names[1] = Resources.getString("controlpanel.install.tabTitle");
        this._names[this._len - 3] = Resources.getString("controlpanel.jre.tabTitle");
        this._names[this._len - 2] = Resources.getString("controlpanel.advanced.tabTitle");
        this._names[this._len - 1] = Resources.getString("controlpanel.certs.tabTitle");
        int n = 0;
        while (n < this._len) {
            this._controllers[n] = null;
            ++n;
        }
    }

    public Subcontroller getSubcontroller(boolean bl, int n) {
        if (n < 0 || n >= this._len) {
            Debug.fatal("Invalid Subcontroller index: " + n);
        }
        if (this._controllers[n] == null && bl) {
            switch (n) {
                case 0: {
                    this._controllers[0] = new UnixGeneralPanel();
                    break;
                }
                case 1: {
                    this._controllers[1] = this._lih ? new InstallPanel() : new JREPanel();
                    break;
                }
                case 2: {
                    this._controllers[2] = this._lih ? new JREPanel() : new AdvancedPanel();
                    break;
                }
                case 3: {
                    this._controllers[3] = this._lih ? new AdvancedPanel() : new CertificatePanel();
                    break;
                }
                case 4: {
                    this._controllers[4] = new CertificatePanel();
                }
            }
        }
        return this._controllers[n];
    }

    public String getSubcontrollerTitle(int n) {
        if (n < 0 || n >= this._len) {
            Debug.fatal("Invalid Subcontroller index: " + n);
        }
        return this._names[n];
    }
}

