/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.ui.prefs;

import com.sun.javaws.ConfigProperties;
import com.sun.javaws.Resources;
import com.sun.javaws.debug.Debug;
import com.sun.javaws.debug.Globals;
import com.sun.javaws.proxy.InternetProxy;
import com.sun.javaws.proxy.InternetProxyInfo;
import com.sun.javaws.ui.prefs.PrefsPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;

public class GeneralPanel
extends PrefsPanel.PropertyPanel
implements ActionListener {
    private JTextField _httpTF;
    private JTextField _portTF;
    private JRadioButton _noProxyJRB;
    private JTextArea _proxyOverRideTA;
    private JRadioButton _manualProxyJRB;
    private JRadioButton _autoProxyJRB;
    private JTextField _autoProxyTF;
    private InternetProxyInfo _iProxyInfo;
    private InternetProxyInfo _browserIProxyInfo;

    public GeneralPanel() {
        InternetProxy internetProxy = InternetProxy.getInstance();
        this._iProxyInfo = internetProxy.getDefaultInfo();
        this._browserIProxyInfo = internetProxy.getBrowserInfo();
    }

    public void apply() {
        ConfigProperties configProperties = this.getConfigProperties();
        int n = -1;
        String string = null;
        String string2 = null;
        int n2 = -1;
        int n3 = -1;
        String string3 = "";
        if (this._noProxyJRB.isSelected()) {
            n = 0;
        } else if (this._manualProxyJRB.isSelected()) {
            n = 1;
            string2 = string = this._httpTF.getText();
            try {
                n2 = Integer.parseInt(this._portTF.getText());
            }
            catch (NumberFormatException numberFormatException) {
                n2 = -1;
            }
            n3 = n2;
            string3 = this._proxyOverRideTA.getText();
        } else {
            n = 2;
            if (this._browserIProxyInfo.getType() != 0) {
                string = this._browserIProxyInfo.getHTTPHost();
                n2 = this._browserIProxyInfo.getHTTPPort();
                string2 = this._browserIProxyInfo.getHTTPSHost();
                n3 = this._browserIProxyInfo.getHTTPSPort();
                string3 = this._browserIProxyInfo.getOverrides();
            }
        }
        if (string == null) {
            string = "";
            string2 = "";
        }
        this._iProxyInfo.setType(n);
        this._iProxyInfo.setHTTPHost(string);
        this._iProxyInfo.setHTTPPort(n2);
        String[] stringArray = new String[]{string3};
        this._iProxyInfo.setOverrides(stringArray);
        Properties properties = System.getProperties();
        properties.put("proxyHost", string);
        properties.put("proxyPort", String.valueOf(n2));
        properties.put("trustProxy", "true");
        properties.put("https.proxyHost", string2);
        properties.put("https.proxyPort", String.valueOf(n3));
        properties.put("http.nonProxyHosts", string3);
        string = this._httpTF.getText();
        try {
            n2 = Integer.parseInt(this._portTF.getText());
        }
        catch (NumberFormatException numberFormatException) {
            n2 = -1;
        }
        string3 = this._proxyOverRideTA.getText();
        configProperties.setProxy(n, string, n2, string3);
        configProperties.store();
        this.updateProxys();
    }

    protected void createPropertyControls() {
        this.setLayout(new GridBagLayout());
        this.addGridBagComponent(this, Box.createVerticalGlue(), 0, 0, 1, 1, 1.0, 0.5, 10, 1, null, 0, 0);
        this.addGridBagComponent(this, this.createProxyPanel(), 0, 1, 1, 1, 1.0, 0.0, 10, 2, null, 0, 0);
        this.addGridBagComponent(this, Box.createVerticalGlue(), 0, 2, 1, 1, 1.0, 0.5, 10, 1, null, 0, 0);
        this.revert();
    }

    public void revert() {
        ConfigProperties configProperties = this.getConfigProperties();
        if (configProperties.getProxyType() == 0) {
            this._noProxyJRB.setSelected(true);
        } else if (configProperties.getProxyType() == 1) {
            this._manualProxyJRB.setSelected(true);
        } else {
            this._autoProxyJRB.setSelected(true);
        }
        this.updateProxys();
        this.setInitialDialogPromptSettings();
        if (!this._autoProxyJRB.isEnabled() && this._autoProxyJRB.isSelected()) {
            this._noProxyJRB.setSelected(true);
        }
    }

    private void setInitialDialogPromptSettings() {
        String string;
        if (this._browserIProxyInfo.isValidAutoHTTPConfiguration() || this._browserIProxyInfo.isValidManualHTTPConfiguration()) {
            this._autoProxyTF.setText(Resources.getString("controlpanel.proxy.BrowserAutoProxyInfo", this._browserIProxyInfo.getHTTPHost(), Integer.toString(this._browserIProxyInfo.getHTTPPort())));
            this._autoProxyJRB.setEnabled(true);
            this._noProxyJRB.setSelected(false);
        } else if (this._browserIProxyInfo.getType() == 0) {
            this._autoProxyTF.setText(Resources.getString("controlpanel.proxy.BrowserDirect"));
            this._autoProxyJRB.setEnabled(true);
        } else {
            this._autoProxyTF.setText(Resources.getString("controlpanel.proxy.BrowserNoDetect"));
            this._autoProxyJRB.setEnabled(false);
        }
        ConfigProperties configProperties = this.getConfigProperties();
        boolean bl = false;
        if (configProperties.getHTTPProxy() != null && configProperties.getHTTPProxy() != "") {
            this._httpTF.setText(configProperties.getHTTPProxy());
            this._portTF.setText(configProperties.getHTTPProxyPort() == null ? "8080" : configProperties.getHTTPProxyPort());
            bl = true;
        } else if (this._browserIProxyInfo.getType() == 2 && this._browserIProxyInfo.getInvalidHTTPHost() != null && this._browserIProxyInfo.getInvalidHTTPHost() != "") {
            this._httpTF.setText(this._browserIProxyInfo.getInvalidHTTPHost());
            this._portTF.setText(this._browserIProxyInfo.getInvalidHTTPPort() == -1 ? "8080" : Integer.toString(this._browserIProxyInfo.getInvalidHTTPPort()));
            bl = true;
        }
        if (bl && !this._autoProxyJRB.isEnabled() && this._autoProxyJRB.isSelected()) {
            this._manualProxyJRB.setSelected(true);
            this.updateProxys();
        }
        if ((string = configProperties.getProxyOverrideString()) != null && string.compareTo("") == 0) {
            string = "";
        }
        this._proxyOverRideTA.setText(string);
    }

    private void updateProxys() {
        if (this._noProxyJRB.isSelected()) {
            this.enableManualUIGadgets(false);
        } else if (this._manualProxyJRB.isSelected()) {
            this.enableManualUIGadgets(true);
        } else if (this._autoProxyJRB.isSelected()) {
            this.enableManualUIGadgets(false);
        }
        if (Globals.TraceProxies) {
            Debug.println("Browser info=" + this._browserIProxyInfo);
            Debug.println("Current info=" + this._iProxyInfo);
        }
    }

    private void enableManualUIGadgets(boolean bl) {
        this._httpTF.setEnabled(bl);
        this._httpTF.setEditable(bl);
        this._portTF.setEnabled(bl);
        this._portTF.setEditable(bl);
        this._proxyOverRideTA.setEditable(bl);
        this._proxyOverRideTA.setEnabled(bl);
    }

    protected Component createProxyPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        Insets insets = new Insets(0, 2, 5, 8);
        this._noProxyJRB = new JRadioButton(Resources.getString("controlpanel.proxy.noProxy"));
        this._noProxyJRB.setMnemonic(Resources.getVKCode("controlpanel.proxy.noProxyMnemonic"));
        this._manualProxyJRB = new JRadioButton(Resources.getString("controlpanel.proxy.manualProxy"));
        this._manualProxyJRB.setMnemonic(Resources.getVKCode("controlpanel.proxy.manualProxyMnemonic"));
        this._autoProxyJRB = new JRadioButton(Resources.getString("controlpanel.proxy.autoProxy"));
        this._autoProxyJRB.setMnemonic(Resources.getVKCode("controlpanel.proxy.autoProxyMnemonic"));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this._noProxyJRB);
        buttonGroup.add(this._autoProxyJRB);
        buttonGroup.add(this._manualProxyJRB);
        this.addGridBagComponent(jPanel, this._noProxyJRB, 0, 0, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0);
        this._noProxyJRB.addActionListener(this);
        this.addGridBagComponent(jPanel, this._autoProxyJRB, 0, 1, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0);
        this._autoProxyJRB.addActionListener(this);
        this._autoProxyTF = new JTextField();
        this._autoProxyTF.setEditable(false);
        this._autoProxyTF.setEnabled(false);
        this._autoProxyTF.setDisabledTextColor(Color.black);
        this.addGridBagComponent(jPanel, this._autoProxyTF, 1, 1, 0, 1, 1.0, 0.0, 10, 2, new Insets(0, 2, 5, 2), 0, 0);
        this.addGridBagComponent(jPanel, this._manualProxyJRB, 0, 2, 1, 2, 0.0, 0.0, 17, 0, insets, 0, 0);
        this._manualProxyJRB.addActionListener(this);
        JLabel jLabel = new JLabel(Resources.getString("controlpanel.proxy.httpLabel"));
        JLabel jLabel2 = new JLabel(Resources.getString("controlpanel.proxy.portLabel"));
        JLabel jLabel3 = new JLabel(Resources.getString("controlpanel.proxy.overRideLabel"));
        jLabel.setDisplayedMnemonic(Resources.getVKCode("controlpanel.proxy.httpMnemonic"));
        jLabel2.setDisplayedMnemonic(Resources.getVKCode("controlpanel.proxy.portMnemonic"));
        jLabel3.setDisplayedMnemonic(Resources.getVKCode("controlpanel.proxy.overRideMnemonic"));
        this.addGridBagComponent(jPanel, jLabel, 1, 2, 1, 1, 0.0, 0.0, 13, 0, insets, 0, 0);
        this.addGridBagComponent(jPanel, jLabel2, 1, 3, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0);
        this.addGridBagComponent(jPanel, jLabel3, 0, 5, 0, 1, 0.0, 0.0, 17, 2, insets, 0, 0);
        insets.right = 2;
        this._httpTF = new JTextField();
        jLabel.setLabelFor(this._httpTF);
        this.addGridBagComponent(jPanel, this._httpTF, 2, 2, 1, 1, 1.0, 0.0, 10, 2, insets, 0, 0);
        this._portTF = new JTextField();
        jLabel2.setLabelFor(this._portTF);
        this.addGridBagComponent(jPanel, this._portTF, 2, 3, 1, 1, 1.0, 0.0, 10, 2, insets, 0, 0);
        this._proxyOverRideTA = new JTextArea("localhost", 3, 10);
        this._proxyOverRideTA.setLineWrap(true);
        this._proxyOverRideTA.setWrapStyleWord(true);
        this._proxyOverRideTA.setBorder(BorderFactory.createLineBorder(Color.black));
        jLabel3.setLabelFor(this._proxyOverRideTA);
        this.addGridBagComponent(jPanel, this._proxyOverRideTA, 0, 6, 3, 1, 1.0, 0.0, 10, 2, insets, 0, 0);
        this._autoProxyJRB.setNextFocusableComponent(this._manualProxyJRB);
        this._manualProxyJRB.setNextFocusableComponent(this._httpTF);
        this._httpTF.setNextFocusableComponent(this._portTF);
        jPanel.setBorder(new TitledBorder(LineBorder.createBlackLineBorder(), Resources.getString("controlpanel.proxy.title"), 1, 2));
        this.revert();
        return jPanel;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.updateProxys();
    }

    public JPanel getProxyPanel() {
        return (JPanel)this.createProxyPanel();
    }
}

