/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.ui.player;

import com.sun.javaws.BrowserSupport;
import com.sun.javaws.ConfigProperties;
import com.sun.javaws.LaunchDownload;
import com.sun.javaws.LocalApplicationProperties;
import com.sun.javaws.Resources;
import com.sun.javaws.cache.InstallCache;
import com.sun.javaws.debug.Debug;
import com.sun.javaws.jnl.IconDesc;
import com.sun.javaws.jnl.InformationDesc;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.ui.general.GeneralUtilities;
import com.sun.javaws.util.URLUtil;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;

public class JNLEntry
implements Comparable {
    private String _title;
    private String _vendor;
    private boolean _offline;
    private String _home;
    private String _description;
    private int _downloadSize;
    private URL _codebase;
    private LaunchDesc _launchDescriptor;
    private LocalApplicationProperties _lap;
    private long _mostRecentUsed;
    private boolean _cached;
    private URL _launchHome;
    private IconDesc _imageLoc;

    public int getDownloadSize() {
        return this._downloadSize;
    }

    public int hashCode() {
        URL uRL = this.getCodebase();
        if (uRL != null) {
            return uRL.hashCode();
        }
        return super.hashCode();
    }

    public long getMostRecentUsed() {
        return this._mostRecentUsed;
    }

    public JNLEntry() {
    }

    public void showHome() {
        block2: {
            String string = this.getHome();
            if (string == null) break block2;
            try {
                URL uRL = new URL(string);
                BrowserSupport.showDocument(uRL);
            }
            catch (MalformedURLException malformedURLException) {
                GeneralUtilities.showMessageDialog(null, Resources.getString("player.invalidHome"), Resources.getString("appname"), 0);
            }
        }
    }

    public boolean canRunOffline() {
        return this._offline;
    }

    public boolean isCached() {
        return this._cached;
    }

    public boolean launch() {
        try {
            String[] stringArray;
            String string = null;
            if (this._codebase != null && (stringArray = InstallCache.getCache().getCachedLaunchedFile(this._codebase)) != null) {
                string = stringArray.toString();
            }
            if (string == null && this._launchHome != null) {
                string = this._launchHome.toString();
            } else if (string == null) {
                return false;
            }
            stringArray = new String[]{ConfigProperties.getStartCommand(), string};
            Runtime.getRuntime().exec(stringArray);
            return true;
        }
        catch (IOException iOException) {
            Debug.ignoredException(iOException);
            return false;
        }
    }

    public LocalApplicationProperties getLocalApplicationProperties() {
        return this._lap;
    }

    public IconDesc getImageLocation() {
        return this._imageLoc;
    }

    public LaunchDesc getLaunchDescriptor() {
        return this._launchDescriptor;
    }

    public int compareTo(Object object) {
        JNLEntry jNLEntry = (JNLEntry)object;
        return this.getTitle().compareTo(jNLEntry.getTitle());
    }

    public boolean equals(Object object) {
        if (object instanceof JNLEntry) {
            URL uRL = this.getCodebase();
            URL uRL2 = ((JNLEntry)object).getCodebase();
            return URLUtil.equals(uRL, uRL2);
        }
        return super.equals(object);
    }

    public String getDescription() {
        return this._description;
    }

    public String getHome() {
        return this._home;
    }

    public String getTitle() {
        return this._title;
    }

    public String getVendor() {
        return this._vendor;
    }

    public String toString() {
        return this.getClass().getName() + "[ " + this.getTitle() + ", " + this.getVendor() + ", " + this.getDescription() + " ]";
    }

    public URL getCodebase() {
        return this._codebase;
    }

    public JNLEntry(LaunchDesc launchDesc, InformationDesc informationDesc, LocalApplicationProperties localApplicationProperties, URL uRL, long l) {
        this(launchDesc, informationDesc, localApplicationProperties, uRL, l, true, null);
    }

    public JNLEntry(LaunchDesc launchDesc, InformationDesc informationDesc, LocalApplicationProperties localApplicationProperties, URL uRL, long l, boolean bl, URL uRL2) {
        this._lap = localApplicationProperties;
        this._title = informationDesc.getTitle();
        this._vendor = informationDesc.getVendor();
        this._offline = informationDesc.supportsOfflineOperation();
        this._cached = bl;
        URL uRL3 = informationDesc.getHome();
        if (uRL3 != null) {
            this._home = uRL3.toExternalForm();
        }
        this._launchHome = uRL2;
        this._description = informationDesc.getDescription(1);
        this._downloadSize = (int)LaunchDownload.getCachedSize(launchDesc);
        this._imageLoc = informationDesc.getIconLocation(2, 0);
        this._codebase = launchDesc.getLocation() != null ? launchDesc.getLocation() : uRL;
        this._launchDescriptor = launchDesc;
        this._mostRecentUsed = l;
    }
}

