/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.motif;

import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Insets;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.peer.FileDialogPeer;
import java.io.File;
import java.io.FilenameFilter;
import sun.awt.datatransfer.ToolkitThreadBlockedHandler;
import sun.awt.motif.MComponentPeer;
import sun.awt.motif.MDialogPeer;
import sun.awt.motif.MToolkit;
import sun.awt.motif.MToolkitThreadBlockedHandler;

public class MFileDialogPeer
extends MDialogPeer
implements FileDialogPeer {
    private FilenameFilter filter;

    public void handleCancel() {
        FileDialog fileDialog = (FileDialog)this.target;
        MToolkit.executeOnEventHandlerThread(fileDialog, new Runnable(this, fileDialog){
            private final FileDialog val$fileDialog;
            private final MFileDialogPeer this$0;

            public void run() {
                this.val$fileDialog.setFile(null);
                this.val$fileDialog.hide();
            }
            {
                this.this$0 = mFileDialogPeer;
                this.val$fileDialog = fileDialog;
            }
        });
    }

    public void handleQuit() {
        FileDialog fileDialog = (FileDialog)this.target;
        MToolkit.executeOnEventHandlerThread(fileDialog, new Runnable(this, fileDialog){
            private final FileDialog val$fileDialog;
            private final MFileDialogPeer this$0;

            public void run() {
                this.val$fileDialog.hide();
            }
            {
                this.this$0 = mFileDialogPeer;
                this.val$fileDialog = fileDialog;
            }
        });
    }

    native void pDispose();

    native void pHide();

    native void pShow();

    public void pasteFromClipboard() {
        Clipboard clipboard = this.target.getToolkit().getSystemClipboard();
        Transferable transferable = clipboard.getContents(this);
        if (transferable != null) {
            try {
                String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                this.insertReplaceFileDialogText(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void show() {
        this.setVisible(true);
        this.setFilenameFilter(this.filter);
    }

    native void pReshape(int var1, int var2, int var3, int var4);

    public MFileDialogPeer(FileDialog fileDialog) {
        super(fileDialog);
        FileDialog fileDialog2 = fileDialog;
        String string = fileDialog2.getDirectory();
        String string2 = fileDialog2.getFile();
        FilenameFilter filenameFilter = fileDialog2.getFilenameFilter();
        this.insets = new Insets(0, 0, 0, 0);
        this.setDirectory(string);
        if (string2 != null) {
            this.setFile(string2);
        }
        this.setFilenameFilter(filenameFilter);
    }

    public native void setFont(Font var1);

    public void setFilenameFilter(FilenameFilter filenameFilter) {
        this.filter = filenameFilter;
        FileDialog fileDialog = (FileDialog)this.target;
        String string = fileDialog.getDirectory();
        String string2 = fileDialog.getFile();
        this.setFile(string2);
        this.doFilter(filenameFilter, null);
    }

    public void handleSelected(String string) {
        FileDialog fileDialog = (FileDialog)this.target;
        MToolkit.executeOnEventHandlerThread(fileDialog, new Runnable(this, string, fileDialog){
            private final String val$file;
            private final FileDialog val$fileDialog;
            private final MFileDialogPeer this$0;

            public void run() {
                String string;
                int n2 = this.val$file.lastIndexOf(File.separatorChar);
                if (n2 == -1) {
                    string = "." + File.separator;
                    this.val$fileDialog.setFile(this.val$file);
                } else {
                    string = this.val$file.substring(0, n2 + 1);
                    this.val$fileDialog.setFile(this.val$file.substring(n2 + 1));
                }
                this.val$fileDialog.setDirectory(string);
                this.val$fileDialog.hide();
            }
            {
                this.this$0 = mFileDialogPeer;
                this.val$file = string;
                this.val$fileDialog = fileDialog;
            }
        });
    }

    native void insertReplaceFileDialogText(String var1);

    public void setDirectory(String string) {
        String string2 = ((FileDialog)this.target).getFile();
        this.setFileEntry(string != null ? string : "./", string2 != null ? string2 : "", null);
    }

    public void setFile(String string) {
        String string2 = ((FileDialog)this.target).getDirectory();
        if (string2 == null) {
            string2 = "./";
        }
        this.setFileEntry(string2 != null ? string2 : "./", this.getFilteredFile(null), null);
    }

    private boolean proceedFiltering(String string, boolean bl2) {
        if (!bl2 || this.filter == null) {
            try {
                this.doFilter(this.filter, string);
                return true;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return false;
            }
        }
        ToolkitThreadBlockedHandler toolkitThreadBlockedHandler = MToolkitThreadBlockedHandler.getToolkitThreadBlockedHandler();
        boolean[] blArray = new boolean[1];
        boolean[] blArray2 = new boolean[1];
        blArray[0] = false;
        blArray2[0] = false;
        toolkitThreadBlockedHandler.lock();
        MToolkit.executeOnEventHandlerThread((FileDialog)this.target, new Runnable(this, toolkitThreadBlockedHandler, string, blArray2, blArray){
            private final ToolkitThreadBlockedHandler val$priveleged_lock;
            private final String val$dir;
            private final boolean[] val$result;
            private final boolean[] val$finished;
            private final MFileDialogPeer this$0;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                this.val$priveleged_lock.lock();
                try {
                    try {
                        this.this$0.doFilter(MFileDialogPeer.access$000(this.this$0), this.val$dir);
                        this.val$result[0] = true;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        this.val$result[0] = false;
                        Object var3_2 = null;
                        this.val$finished[0] = true;
                        this.val$priveleged_lock.exit();
                        this.val$priveleged_lock.unlock();
                    }
                    Object var3_1 = null;
                    this.val$finished[0] = true;
                    this.val$priveleged_lock.exit();
                    this.val$priveleged_lock.unlock();
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    this.val$finished[0] = true;
                    this.val$priveleged_lock.exit();
                    this.val$priveleged_lock.unlock();
                    throw throwable;
                }
            }
            {
                this.this$0 = mFileDialogPeer;
                this.val$priveleged_lock = toolkitThreadBlockedHandler;
                this.val$dir = string;
                this.val$result = blArray;
                this.val$finished = blArray2;
            }
        });
        while (!blArray[0]) {
            toolkitThreadBlockedHandler.enter();
        }
        toolkitThreadBlockedHandler.unlock();
        return blArray2[0];
    }

    native void create(MComponentPeer var1);

    static FilenameFilter access$000(MFileDialogPeer mFileDialogPeer) {
        return mFileDialogPeer.filter;
    }

    void create(MComponentPeer mComponentPeer, Object object) {
        this.create(mComponentPeer);
    }

    public void doFilter(FilenameFilter filenameFilter, String string) {
        String string2 = string == null ? ((FileDialog)this.target).getDirectory() : string;
        String string3 = this.getFilteredFile(null);
        File file = new File(string2 != null ? string2 : ".");
        String[] stringArray = file.list(new DirectoryFilter(this, filenameFilter));
        if (stringArray == null) {
            stringArray = new String[]{""};
        }
        this.setFileEntry(string2 != null ? string2 : ".", string3 != null ? string3 : "", stringArray);
    }

    String getFilteredFile(String string) {
        String string2;
        if (string == null) {
            string = ((FileDialog)this.target).getFile();
        }
        if ((string2 = ((FileDialog)this.target).getDirectory()) == null) {
            string2 = "./";
        }
        if (string == null) {
            string = "";
        }
        if (this.filter != null && !this.filter.accept(new File(string2), string)) {
            string = "";
        }
        return string;
    }

    native void setFileEntry(String var1, String var2, String[] var3);

    class DirectoryFilter
    implements FilenameFilter {
        FilenameFilter userFilter;
        private final MFileDialogPeer this$0;

        DirectoryFilter(MFileDialogPeer mFileDialogPeer, FilenameFilter filenameFilter) {
            this.this$0 = mFileDialogPeer;
            this.userFilter = filenameFilter;
        }

        public boolean accept(File file, String string) {
            File file2 = new File(file, string);
            if (file2.isDirectory()) {
                return false;
            }
            if (this.userFilter != null) {
                return this.userFilter.accept(file, string);
            }
            return true;
        }
    }
}

