/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.text.AttributedCharacterIterator;
import java.text.CharacterIteratorFieldDelegate;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.DecimalFormat;
import java.text.DontCareFieldPosition;
import java.text.FieldPosition;
import java.text.Format;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.Locale;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import sun.text.resources.LocaleData;

public class SimpleDateFormat
extends DateFormat {
    static final long serialVersionUID = 4774881970558875024L;
    static final int currentSerialVersion = 1;
    private int serialVersionOnStream = 1;
    private String pattern;
    private transient char[] compiledPattern;
    private static final int TAG_QUOTE_ASCII_CHAR = 100;
    private static final int TAG_QUOTE_CHARS = 101;
    private transient char zeroDigit;
    private DateFormatSymbols formatData;
    private Date defaultCenturyStart;
    private transient int defaultCenturyStartYear;
    private static final int millisPerHour = 3600000;
    private static final int millisPerMinute = 60000;
    private static final String GMT_PLUS = "GMT+";
    private static final String GMT_MINUS = "GMT-";
    private static final String GMT = "GMT";
    private static Hashtable cachedLocaleData = new Hashtable(3);
    private static Hashtable cachedNumberFormatData = new Hashtable(3);
    private static final int[] PATTERN_INDEX_TO_CALENDAR_FIELD = new int[]{0, 1, 2, 5, 11, 11, 12, 13, 14, 7, 6, 8, 3, 4, 9, 10, 10, 15, 15};
    private static final int[] PATTERN_INDEX_TO_DATE_FORMAT_FIELD = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 17};
    private static final DateFormat.Field[] PATTERN_INDEX_TO_DATE_FORMAT_FIELD_ID = new DateFormat.Field[]{DateFormat.Field.ERA, DateFormat.Field.YEAR, DateFormat.Field.MONTH, DateFormat.Field.DAY_OF_MONTH, DateFormat.Field.HOUR_OF_DAY1, DateFormat.Field.HOUR_OF_DAY0, DateFormat.Field.MINUTE, DateFormat.Field.SECOND, DateFormat.Field.MILLISECOND, DateFormat.Field.DAY_OF_WEEK, DateFormat.Field.DAY_OF_YEAR, DateFormat.Field.DAY_OF_WEEK_IN_MONTH, DateFormat.Field.WEEK_OF_YEAR, DateFormat.Field.WEEK_OF_MONTH, DateFormat.Field.AM_PM, DateFormat.Field.HOUR1, DateFormat.Field.HOUR0, DateFormat.Field.TIME_ZONE, DateFormat.Field.TIME_ZONE};

    public int hashCode() {
        return this.pattern.hashCode();
    }

    public SimpleDateFormat() {
        this(3, 3, Locale.getDefault());
    }

    private void initializeDefaultCentury() {
        this.calendar.setTime(new Date());
        this.calendar.add(1, -80);
        this.parseAmbiguousDatesAsAfter(this.calendar.getTime());
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        String string;
        TimeZone timeZone;
        objectInputStream.defaultReadObject();
        try {
            this.compiledPattern = this.compile(this.pattern);
        }
        catch (Exception exception) {
            throw new InvalidObjectException("invalid pattern");
        }
        if (this.serialVersionOnStream < 1) {
            this.initializeDefaultCentury();
        } else {
            this.parseAmbiguousDatesAsAfter(this.defaultCenturyStart);
        }
        this.serialVersionOnStream = 1;
        TimeZone timeZone2 = this.getTimeZone();
        if (timeZone2 instanceof SimpleTimeZone && (timeZone = TimeZone.getTimeZone(string = timeZone2.getID())) != null && timeZone.hasSameRules(timeZone2) && timeZone.getID().equals(string)) {
            this.setTimeZone(timeZone);
        }
    }

    public Object clone() {
        SimpleDateFormat simpleDateFormat = (SimpleDateFormat)super.clone();
        simpleDateFormat.formatData = (DateFormatSymbols)this.formatData.clone();
        return simpleDateFormat;
    }

    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        SimpleDateFormat simpleDateFormat = (SimpleDateFormat)object;
        return this.pattern.equals(simpleDateFormat.pattern) && this.formatData.equals(simpleDateFormat.formatData);
    }

    public String toLocalizedPattern() {
        return this.translatePattern(this.pattern, "GyMdkHmsSEDFwWahKzZ", this.formatData.localPatternChars);
    }

    public String toPattern() {
        return this.pattern;
    }

    public SimpleDateFormat(String string) {
        this(string, Locale.getDefault());
    }

    public void applyLocalizedPattern(String string) {
        String string2 = this.translatePattern(string, this.formatData.localPatternChars, "GyMdkHmsSEDFwWahKzZ");
        this.compiledPattern = this.compile(string2);
        this.pattern = string2;
    }

    public void applyPattern(String string) {
        this.compiledPattern = this.compile(string);
        this.pattern = string;
    }

    private char[] compile(String string) {
        int n2;
        int n3 = string.length();
        boolean bl2 = false;
        StringBuffer stringBuffer = new StringBuffer(n3 * 2);
        StringBuffer stringBuffer2 = null;
        int n4 = 0;
        int n5 = -1;
        for (n2 = 0; n2 < n3; ++n2) {
            char c2;
            int n6;
            char c3 = string.charAt(n2);
            if (c3 == '\'') {
                if (n2 + 1 < n3 && (c3 = string.charAt(n2 + 1)) == '\'') {
                    ++n2;
                    if (n4 != 0) {
                        SimpleDateFormat.encode(n5, n4, stringBuffer);
                        n5 = -1;
                        n4 = 0;
                    }
                    if (bl2) {
                        stringBuffer2.append(c3);
                        continue;
                    }
                    stringBuffer.append((char)(0x6400 | c3));
                    continue;
                }
                if (!bl2) {
                    if (n4 != 0) {
                        SimpleDateFormat.encode(n5, n4, stringBuffer);
                        n5 = -1;
                        n4 = 0;
                    }
                    if (stringBuffer2 == null) {
                        stringBuffer2 = new StringBuffer(n3);
                    } else {
                        stringBuffer2.setLength(0);
                    }
                    bl2 = true;
                    continue;
                }
                n6 = stringBuffer2.length();
                if (n6 == 1) {
                    c2 = stringBuffer2.charAt(0);
                    if (c2 < '\u0080') {
                        stringBuffer.append((char)(0x6400 | c2));
                    } else {
                        stringBuffer.append('\u6501');
                        stringBuffer.append(c2);
                    }
                } else {
                    SimpleDateFormat.encode(101, n6, stringBuffer);
                    stringBuffer.append(stringBuffer2);
                }
                bl2 = false;
                continue;
            }
            if (bl2) {
                stringBuffer2.append(c3);
                continue;
            }
            if (!(c3 >= 'a' && c3 <= 'z' || c3 >= 'A' && c3 <= 'Z')) {
                if (n4 != 0) {
                    SimpleDateFormat.encode(n5, n4, stringBuffer);
                    n5 = -1;
                    n4 = 0;
                }
                if (c3 < '\u0080') {
                    stringBuffer.append((char)(0x6400 | c3));
                    continue;
                }
                for (n6 = n2 + 1; !(n6 >= n3 || (c2 = string.charAt(n6)) == '\'' || c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z'); ++n6) {
                }
                stringBuffer.append((char)(0x6500 | n6 - n2));
                while (n2 < n6) {
                    stringBuffer.append(string.charAt(n2));
                    ++n2;
                }
                --n2;
                continue;
            }
            n6 = "GyMdkHmsSEDFwWahKzZ".indexOf(c3);
            if (n6 == -1) {
                throw new IllegalArgumentException("Illegal pattern character '" + c3 + "'");
            }
            if (n5 == -1 || n5 == n6) {
                n5 = n6;
                ++n4;
                continue;
            }
            SimpleDateFormat.encode(n5, n4, stringBuffer);
            n5 = n6;
            n4 = 1;
        }
        if (bl2) {
            throw new IllegalArgumentException("Unterminated quote");
        }
        if (n4 != 0) {
            SimpleDateFormat.encode(n5, n4, stringBuffer);
        }
        n2 = stringBuffer.length();
        char[] cArray = new char[n2];
        stringBuffer.getChars(0, n2, cArray, 0);
        return cArray;
    }

    private int subParseZoneString(String string, int n2) {
        int n3 = this.formatData.getZoneIndex(this.getTimeZone().getID());
        TimeZone timeZone = null;
        int n4 = 0;
        int n5 = 0;
        if (n3 != -1 && (n4 = this.matchZoneString(string, n2, n3)) > 0) {
            timeZone = TimeZone.getTimeZone(this.formatData.zoneStrings[n3][0]);
            n5 = n3;
        }
        if (timeZone == null && (n3 = this.formatData.getZoneIndex(TimeZone.getDefault().getID())) != -1 && (n4 = this.matchZoneString(string, n2, n3)) > 0) {
            timeZone = TimeZone.getTimeZone(this.formatData.zoneStrings[n3][0]);
            n5 = n3;
        }
        if (timeZone == null) {
            for (n5 = 0; n5 < this.formatData.zoneStrings.length; ++n5) {
                n4 = this.matchZoneString(string, n2, n5);
                if (n4 <= 0) continue;
                timeZone = TimeZone.getTimeZone(this.formatData.zoneStrings[n5][0]);
                break;
            }
        }
        if (timeZone != null) {
            int n6;
            int n7 = n6 = n4 >= 3 ? timeZone.getDSTSavings() : 0;
            if (n4 < 3 || n6 != 0) {
                this.calendar.set(15, timeZone.getRawOffset());
                this.calendar.set(16, n6);
            }
            return n2 + this.formatData.zoneStrings[n5][n4].length();
        }
        return 0;
    }

    private int matchZoneString(String string, int n2, int n3) {
        int n4;
        for (n4 = 1; n4 <= 4 && !string.regionMatches(true, n2, this.formatData.zoneStrings[n3][n4], 0, this.formatData.zoneStrings[n3][n4].length()); ++n4) {
        }
        return n4 > 4 ? -1 : n4;
    }

    private final void zeroPaddingNumber(int n2, int n3, int n4, StringBuffer stringBuffer) {
        try {
            if (this.zeroDigit == '\u0000') {
                this.zeroDigit = ((DecimalFormat)this.numberFormat).getDecimalFormatSymbols().getZeroDigit();
            }
            if (n2 >= 0) {
                if (n2 < 100 && n3 >= 1 && n3 <= 2) {
                    if (n2 < 10) {
                        if (n3 == 2) {
                            stringBuffer.append(this.zeroDigit);
                        }
                        stringBuffer.append((char)(this.zeroDigit + n2));
                    } else {
                        stringBuffer.append((char)(this.zeroDigit + n2 / 10));
                        stringBuffer.append((char)(this.zeroDigit + n2 % 10));
                    }
                    return;
                }
                if (n2 >= 1000 && n2 < 10000) {
                    if (n3 == 4) {
                        stringBuffer.append((char)(this.zeroDigit + n2 / 1000));
                        stringBuffer.append((char)(this.zeroDigit + (n2 %= 1000) / 100));
                        stringBuffer.append((char)(this.zeroDigit + (n2 %= 100) / 10));
                        stringBuffer.append((char)(this.zeroDigit + n2 % 10));
                        return;
                    }
                    if (n3 == 2 && n4 == 2) {
                        this.zeroPaddingNumber(n2 % 100, 2, 2, stringBuffer);
                        return;
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.numberFormat.setMinimumIntegerDigits(n3);
        this.numberFormat.setMaximumIntegerDigits(n4);
        this.numberFormat.format(n2, stringBuffer, DontCareFieldPosition.INSTANCE);
    }

    private static final void encode(int n2, int n3, StringBuffer stringBuffer) {
        if (n3 < 255) {
            stringBuffer.append((char)(n2 << 8 | n3));
        } else {
            stringBuffer.append((char)(n2 << 8 | 0xFF));
            stringBuffer.append((char)(n3 >>> 16));
            stringBuffer.append((char)(n3 & 0xFFFF));
        }
    }

    public DateFormatSymbols getDateFormatSymbols() {
        return (DateFormatSymbols)this.formatData.clone();
    }

    public void setDateFormatSymbols(DateFormatSymbols dateFormatSymbols) {
        this.formatData = (DateFormatSymbols)dateFormatSymbols.clone();
    }

    public Date get2DigitYearStart() {
        return this.defaultCenturyStart;
    }

    private void parseAmbiguousDatesAsAfter(Date date) {
        this.defaultCenturyStart = date;
        this.calendar.setTime(date);
        this.defaultCenturyStartYear = this.calendar.get(1);
    }

    public void set2DigitYearStart(Date date) {
        this.parseAmbiguousDatesAsAfter(date);
    }

    SimpleDateFormat(int n2, int n3, Locale locale) {
        Object[] objectArray;
        String[] stringArray = (String[])cachedLocaleData.get(locale);
        if (stringArray == null) {
            objectArray = LocaleData.getLocaleElements(locale);
            stringArray = objectArray.getStringArray("DateTimePatterns");
            cachedLocaleData.put(locale, stringArray);
        }
        this.formatData = new DateFormatSymbols(locale);
        if (n2 >= 0 && n3 >= 0) {
            objectArray = new Object[]{stringArray[n2], stringArray[n3 + 4]};
            this.pattern = MessageFormat.format(stringArray[8], objectArray);
        } else if (n2 >= 0) {
            this.pattern = stringArray[n2];
        } else if (n3 >= 0) {
            this.pattern = stringArray[n3 + 4];
        } else {
            throw new IllegalArgumentException("No date or time style specified");
        }
        this.initialize(locale);
    }

    private void initialize(Locale locale) {
        this.compiledPattern = this.compile(this.pattern);
        this.calendar = Calendar.getInstance(TimeZone.getDefault(), locale);
        this.numberFormat = (NumberFormat)cachedNumberFormatData.get(locale);
        if (this.numberFormat == null) {
            this.numberFormat = NumberFormat.getIntegerInstance(locale);
            this.numberFormat.setGroupingUsed(false);
            cachedNumberFormatData.put(locale, this.numberFormat);
        }
        this.numberFormat = (NumberFormat)this.numberFormat.clone();
        this.initializeDefaultCentury();
    }

    private int matchString(String string, int n2, int n3, String[] stringArray) {
        int n4 = 0;
        int n5 = stringArray.length;
        if (n3 == 7) {
            n4 = 1;
        }
        int n6 = 0;
        int n7 = -1;
        while (n4 < n5) {
            int n8 = stringArray[n4].length();
            if (n8 > n6 && string.regionMatches(true, n2, stringArray[n4], 0, n8)) {
                n7 = n4;
                n6 = n8;
            }
            ++n4;
        }
        if (n7 >= 0) {
            this.calendar.set(n3, n7);
            return n2 + n6;
        }
        return -n2;
    }

    private void subFormat(int n2, int n3, Format.FieldDelegate fieldDelegate, StringBuffer stringBuffer) {
        int n4;
        int n5 = Integer.MAX_VALUE;
        String string = null;
        int n6 = stringBuffer.length();
        int n7 = PATTERN_INDEX_TO_CALENDAR_FIELD[n2];
        int n8 = this.calendar.get(n7);
        switch (n2) {
            case 0: {
                string = this.formatData.eras[n8];
                break;
            }
            case 1: {
                if (n3 >= 4) {
                    this.zeroPaddingNumber(n8, n3, n5, stringBuffer);
                    break;
                }
                this.zeroPaddingNumber(n8, 2, 2, stringBuffer);
                break;
            }
            case 2: {
                if (n3 >= 4) {
                    string = this.formatData.months[n8];
                    break;
                }
                if (n3 == 3) {
                    string = this.formatData.shortMonths[n8];
                    break;
                }
                this.zeroPaddingNumber(n8 + 1, n3, n5, stringBuffer);
                break;
            }
            case 4: {
                if (n8 == 0) {
                    this.zeroPaddingNumber(this.calendar.getMaximum(11) + 1, n3, n5, stringBuffer);
                    break;
                }
                this.zeroPaddingNumber(n8, n3, n5, stringBuffer);
                break;
            }
            case 9: {
                if (n3 >= 4) {
                    string = this.formatData.weekdays[n8];
                    break;
                }
                string = this.formatData.shortWeekdays[n8];
                break;
            }
            case 14: {
                string = this.formatData.ampms[n8];
                break;
            }
            case 15: {
                if (n8 == 0) {
                    this.zeroPaddingNumber(this.calendar.getLeastMaximum(10) + 1, n3, n5, stringBuffer);
                    break;
                }
                this.zeroPaddingNumber(n8, n3, n5, stringBuffer);
                break;
            }
            case 17: {
                int n9;
                n4 = this.formatData.getZoneIndex(this.calendar.getTimeZone().getID());
                if (n4 == -1) {
                    n8 = this.calendar.get(15) + this.calendar.get(16);
                    if (n8 < 0) {
                        stringBuffer.append(GMT_MINUS);
                        n8 = -n8;
                    } else {
                        stringBuffer.append(GMT_PLUS);
                    }
                    n9 = n8 / 3600000;
                    if (n9 < 10) {
                        stringBuffer.append('0');
                    }
                    stringBuffer.append(n9);
                    stringBuffer.append(':');
                    n9 = n8 % 3600000 / 60000;
                    if (n9 < 10) {
                        stringBuffer.append('0');
                    }
                    stringBuffer.append(n9);
                    break;
                }
                if (this.calendar.get(16) != 0) {
                    if (n3 >= 4) {
                        string = this.formatData.zoneStrings[n4][3];
                        break;
                    }
                    string = this.formatData.zoneStrings[n4][4];
                    break;
                }
                if (n3 >= 4) {
                    string = this.formatData.zoneStrings[n4][1];
                    break;
                }
                string = this.formatData.zoneStrings[n4][2];
                break;
            }
            case 18: {
                n8 = this.calendar.get(15) + this.calendar.get(16);
                if (n8 < 0) {
                    stringBuffer.append('-');
                    n8 = -n8;
                } else {
                    stringBuffer.append('+');
                }
                int n9 = n8 / 3600000;
                if (n9 < 10) {
                    stringBuffer.append('0');
                }
                stringBuffer.append(n9);
                n9 = n8 % 3600000 / 60000;
                if (n9 < 10) {
                    stringBuffer.append('0');
                }
                stringBuffer.append(n9);
                break;
            }
            default: {
                this.zeroPaddingNumber(n8, n3, n5, stringBuffer);
            }
        }
        if (string != null) {
            stringBuffer.append(string);
        }
        n4 = PATTERN_INDEX_TO_DATE_FORMAT_FIELD[n2];
        DateFormat.Field field = PATTERN_INDEX_TO_DATE_FORMAT_FIELD_ID[n2];
        fieldDelegate.formatted(n4, field, field, n6, stringBuffer.length(), stringBuffer);
    }

    public AttributedCharacterIterator formatToCharacterIterator(Object object) {
        StringBuffer stringBuffer = new StringBuffer();
        CharacterIteratorFieldDelegate characterIteratorFieldDelegate = new CharacterIteratorFieldDelegate();
        if (object instanceof Date) {
            this.format((Date)object, stringBuffer, characterIteratorFieldDelegate);
        } else if (object instanceof Number) {
            this.format(new Date(((Number)object).longValue()), stringBuffer, characterIteratorFieldDelegate);
        } else {
            if (object == null) {
                throw new NullPointerException("formatToCharacterIterator must be passed non-null object");
            }
            throw new IllegalArgumentException("Cannot format given Object as a Date");
        }
        return characterIteratorFieldDelegate.getIterator(stringBuffer.toString());
    }

    public SimpleDateFormat(String string, DateFormatSymbols dateFormatSymbols) {
        this.pattern = string;
        this.formatData = (DateFormatSymbols)dateFormatSymbols.clone();
        this.initialize(Locale.getDefault());
    }

    private int subParse(String string, int n2, int n3, int n4, boolean bl2, boolean[] blArray, ParsePosition parsePosition) {
        int n5;
        Number number = null;
        int n6 = 0;
        ParsePosition parsePosition2 = new ParsePosition(0);
        parsePosition2.index = n2;
        int n7 = PATTERN_INDEX_TO_CALENDAR_FIELD[n3];
        while (true) {
            if (parsePosition2.index >= string.length()) {
                parsePosition.errorIndex = n2;
                return -1;
            }
            n5 = string.charAt(parsePosition2.index);
            if (n5 != 32 && n5 != 9) break;
            ++parsePosition2.index;
        }
        if (n3 == 4 || n3 == 15 || n3 == 2 && n4 <= 2 || n3 == 1) {
            if (bl2) {
                if (n2 + n4 > string.length()) {
                    parsePosition.errorIndex = n2;
                    return -1;
                }
                number = this.numberFormat.parse(string.substring(0, n2 + n4), parsePosition2);
            } else {
                number = this.numberFormat.parse(string, parsePosition2);
            }
            if (number == null) {
                parsePosition.errorIndex = parsePosition2.index;
                return -1;
            }
            n6 = number.intValue();
        }
        switch (n3) {
            case 0: {
                n5 = this.matchString(string, n2, 0, this.formatData.eras);
                if (n5 > 0) {
                    return n5;
                }
                parsePosition.errorIndex = parsePosition2.index;
                return -1;
            }
            case 1: {
                if (n4 <= 2 && parsePosition2.index - n2 == 2 && Character.isDigit(string.charAt(n2)) && Character.isDigit(string.charAt(n2 + 1))) {
                    int n8 = this.defaultCenturyStartYear % 100;
                    blArray[0] = n6 == n8;
                    n6 += this.defaultCenturyStartYear / 100 * 100 + (n6 < n8 ? 100 : 0);
                }
                this.calendar.set(1, n6);
                return parsePosition2.index;
            }
            case 2: {
                if (n4 <= 2) {
                    this.calendar.set(2, n6 - 1);
                    return parsePosition2.index;
                }
                int n9 = 0;
                n9 = this.matchString(string, n2, 2, this.formatData.months);
                if (n9 > 0) {
                    return n9;
                }
                n5 = this.matchString(string, n2, 2, this.formatData.shortMonths);
                if (n5 > 0) {
                    return n5;
                }
                parsePosition.errorIndex = parsePosition2.index;
                return -1;
            }
            case 4: {
                if (n6 == this.calendar.getMaximum(11) + 1) {
                    n6 = 0;
                }
                this.calendar.set(11, n6);
                return parsePosition2.index;
            }
            case 9: {
                int n10 = 0;
                n10 = this.matchString(string, n2, 7, this.formatData.weekdays);
                if (n10 > 0) {
                    return n10;
                }
                n5 = this.matchString(string, n2, 7, this.formatData.shortWeekdays);
                if (n5 > 0) {
                    return n5;
                }
                parsePosition.errorIndex = parsePosition2.index;
                return -1;
            }
            case 14: {
                n5 = this.matchString(string, n2, 9, this.formatData.ampms);
                if (n5 > 0) {
                    return n5;
                }
                parsePosition.errorIndex = parsePosition2.index;
                return -1;
            }
            case 15: {
                if (n6 == this.calendar.getLeastMaximum(10) + 1) {
                    n6 = 0;
                }
                this.calendar.set(10, n6);
                return parsePosition2.index;
            }
            case 17: 
            case 18: {
                int n11;
                int n12 = 0;
                if (string.length() - n2 >= GMT.length() && string.regionMatches(true, n2, GMT, 0, GMT.length())) {
                    int n13;
                    char c2;
                    this.calendar.set(16, 0);
                    parsePosition2.index = n2 + GMT.length();
                    try {
                        if (string.charAt(parsePosition2.index) == '+') {
                            n12 = 1;
                        } else if (string.charAt(parsePosition2.index) == '-') {
                            n12 = -1;
                        }
                    }
                    catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                        // empty catch block
                    }
                    if (n12 == 0) {
                        this.calendar.set(15, 0);
                        return parsePosition2.index;
                    }
                    try {
                        c2 = string.charAt(++parsePosition2.index);
                        if (c2 < '0' || c2 > '9') {
                            parsePosition.errorIndex = parsePosition2.index;
                            return -1;
                        }
                        n13 = c2 - 48;
                        if (string.charAt(++parsePosition2.index) != ':') {
                            c2 = string.charAt(parsePosition2.index);
                            if (c2 < '0' || c2 > '9') {
                                parsePosition.errorIndex = parsePosition2.index;
                                return -1;
                            }
                            n13 *= 10;
                            n13 += c2 - 48;
                            ++parsePosition2.index;
                        }
                        if (n13 > 23) {
                            parsePosition.errorIndex = parsePosition2.index - 1;
                            return -1;
                        }
                        if (string.charAt(parsePosition2.index) != ':') {
                            parsePosition.errorIndex = parsePosition2.index;
                            return -1;
                        }
                    }
                    catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                        parsePosition.errorIndex = parsePosition2.index;
                        return -1;
                    }
                    n11 = n13 * 60;
                    try {
                        c2 = string.charAt(++parsePosition2.index);
                        if (c2 < '0' || c2 > '9') {
                            parsePosition.errorIndex = parsePosition2.index;
                            return -1;
                        }
                        n13 = c2 - 48;
                        if ((c2 = string.charAt(++parsePosition2.index)) < '0' || c2 > '9') {
                            parsePosition.errorIndex = parsePosition2.index;
                            return -1;
                        }
                        n13 *= 10;
                        if ((n13 += c2 - 48) > 59) {
                            parsePosition.errorIndex = parsePosition2.index;
                            return -1;
                        }
                    }
                    catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                        parsePosition.errorIndex = parsePosition2.index;
                        return -1;
                    }
                    n11 += n13;
                } else {
                    int n14 = this.subParseZoneString(string, parsePosition2.index);
                    if (n14 != 0) {
                        return n14;
                    }
                    try {
                        char c3;
                        if (string.charAt(parsePosition2.index) == '+') {
                            n12 = 1;
                        } else if (string.charAt(parsePosition2.index) == '-') {
                            n12 = -1;
                        }
                        if (n12 == 0) {
                            parsePosition.errorIndex = parsePosition2.index;
                            return -1;
                        }
                        int n15 = 0;
                        if ((c3 = string.charAt(++parsePosition2.index)) < '0' || c3 > '9') {
                            parsePosition.errorIndex = parsePosition2.index;
                            return -1;
                        }
                        n15 = c3 - 48;
                        if ((c3 = string.charAt(++parsePosition2.index)) < '0' || c3 > '9') {
                            parsePosition.errorIndex = parsePosition2.index;
                            return -1;
                        }
                        n15 *= 10;
                        if ((n15 += c3 - 48) > 23) {
                            parsePosition.errorIndex = parsePosition2.index;
                            return -1;
                        }
                        int n16 = 0;
                        if ((c3 = string.charAt(++parsePosition2.index)) < '0' || c3 > '9') {
                            parsePosition.errorIndex = parsePosition2.index;
                            return -1;
                        }
                        n16 = c3 - 48;
                        if ((c3 = string.charAt(++parsePosition2.index)) < '0' || c3 > '9') {
                            parsePosition.errorIndex = parsePosition2.index;
                            return -1;
                        }
                        n16 *= 10;
                        if ((n16 += c3 - 48) > 59) {
                            parsePosition.errorIndex = parsePosition2.index;
                            return -1;
                        }
                        n11 = n15 * 60 + n16;
                    }
                    catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                        parsePosition.errorIndex = parsePosition2.index;
                        return -1;
                    }
                }
                if (n12 != 0) {
                    this.calendar.set(15, n11 *= 60000 * n12);
                    this.calendar.set(16, 0);
                    return ++parsePosition2.index;
                }
                parsePosition.errorIndex = parsePosition2.index;
                return -1;
            }
        }
        if (bl2) {
            if (n2 + n4 > string.length()) {
                parsePosition.errorIndex = parsePosition2.index;
                return -1;
            }
            number = this.numberFormat.parse(string.substring(0, n2 + n4), parsePosition2);
        } else {
            number = this.numberFormat.parse(string, parsePosition2);
        }
        if (number != null) {
            this.calendar.set(n7, number.intValue());
            return parsePosition2.index;
        }
        parsePosition.errorIndex = parsePosition2.index;
        return -1;
    }

    public SimpleDateFormat(String string, Locale locale) {
        this.pattern = string;
        this.formatData = new DateFormatSymbols(locale);
        this.initialize(locale);
    }

    public Date parse(String string, ParsePosition parsePosition) {
        Date date;
        int n2;
        int n3 = n2 = parsePosition.index;
        int n4 = string.length();
        boolean[] blArray = new boolean[]{false};
        this.calendar.clear();
        int n5 = 0;
        block6: while (n5 < this.compiledPattern.length) {
            int n6;
            int n7;
            int n8 = this.compiledPattern[n5] >>> 8;
            if ((n7 = this.compiledPattern[n5++] & 0xFF) == 255) {
                n7 = this.compiledPattern[n5++] << 16;
                n7 |= this.compiledPattern[n5++];
            }
            switch (n8) {
                case 100: {
                    if (n2 >= n4 || string.charAt(n2) != (char)n7) {
                        parsePosition.index = n3;
                        parsePosition.errorIndex = n2;
                        return null;
                    }
                    ++n2;
                    continue block6;
                }
                case 101: {
                    while (n7-- > 0) {
                        if (n2 >= n4 || string.charAt(n2) != this.compiledPattern[n5++]) {
                            parsePosition.index = n3;
                            parsePosition.errorIndex = n2;
                            return null;
                        }
                        ++n2;
                    }
                    continue block6;
                }
            }
            boolean bl2 = false;
            if (n5 < this.compiledPattern.length && (n6 = this.compiledPattern[n5] >>> 8) != 100 && n6 != 101) {
                bl2 = true;
            }
            if ((n2 = this.subParse(string, n2, n8, n7, bl2, blArray, parsePosition)) >= 0) continue;
            parsePosition.index = n3;
            return null;
        }
        if (this.calendar.isSet(9) && !this.calendar.isSet(10) && !this.calendar.isSet(11)) {
            this.calendar.set(10, 0);
        }
        parsePosition.index = n2;
        try {
            if (blArray[0]) {
                Calendar calendar = (Calendar)this.calendar.clone();
                date = this.calendar.getTime();
                if (date.before(this.defaultCenturyStart)) {
                    calendar.set(1, this.defaultCenturyStartYear + 100);
                    date = calendar.getTime();
                }
            } else {
                date = this.calendar.getTime();
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            parsePosition.errorIndex = n2;
            parsePosition.index = n3;
            return null;
        }
        return date;
    }

    private String translatePattern(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl2 = false;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (bl2) {
                if (c2 == '\'') {
                    bl2 = false;
                }
            } else if (c2 == '\'') {
                bl2 = true;
            } else if (c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z') {
                int n2 = string2.indexOf(c2);
                if (n2 == -1) {
                    throw new IllegalArgumentException("Illegal pattern  character '" + c2 + "'");
                }
                c2 = string3.charAt(n2);
            }
            stringBuffer.append(c2);
        }
        if (bl2) {
            throw new IllegalArgumentException("Unfinished quote in pattern");
        }
        return stringBuffer.toString();
    }

    public StringBuffer format(Date date, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        fieldPosition.endIndex = 0;
        fieldPosition.beginIndex = 0;
        return this.format(date, stringBuffer, fieldPosition.getFieldDelegate());
    }

    private StringBuffer format(Date date, StringBuffer stringBuffer, Format.FieldDelegate fieldDelegate) {
        this.calendar.setTime(date);
        int n2 = 0;
        block4: while (n2 < this.compiledPattern.length) {
            int n3;
            int n4 = this.compiledPattern[n2] >>> 8;
            if ((n3 = this.compiledPattern[n2++] & 0xFF) == 255) {
                n3 = this.compiledPattern[n2++] << 16;
                n3 |= this.compiledPattern[n2++];
            }
            switch (n4) {
                case 100: {
                    stringBuffer.append((char)n3);
                    continue block4;
                }
                case 101: {
                    stringBuffer.append(this.compiledPattern, n2, n3);
                    n2 += n3;
                    continue block4;
                }
            }
            this.subFormat(n4, n3, fieldDelegate, stringBuffer);
        }
        return stringBuffer;
    }
}

