/*
 * Decompiled with CFR 0.152.
 */
package com.sun.imageio.plugins.jpeg;

import com.sun.imageio.plugins.jpeg.JPEGBuffer;
import com.sun.imageio.plugins.jpeg.MarkerSegment;
import java.io.IOException;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageOutputStream;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class SOSMarkerSegment
extends MarkerSegment {
    int startSpectralSelection;
    int endSpectralSelection;
    int approxHigh;
    int approxLow;
    ScanComponentSpec[] componentSpecs;

    void print() {
        this.printTag("SOS");
        System.out.print("Start spectral selection: ");
        System.out.println(this.startSpectralSelection);
        System.out.print("End spectral selection: ");
        System.out.println(this.endSpectralSelection);
        System.out.print("Approx high: ");
        System.out.println(this.approxHigh);
        System.out.print("Approx low: ");
        System.out.println(this.approxLow);
        System.out.print("Num scan components: ");
        System.out.println(this.componentSpecs.length);
        for (int i2 = 0; i2 < this.componentSpecs.length; ++i2) {
            this.componentSpecs[i2].print();
        }
    }

    SOSMarkerSegment(boolean bl2, byte[] byArray, int n2) {
        super(218);
        this.startSpectralSelection = 0;
        this.endSpectralSelection = 63;
        this.approxHigh = 0;
        this.approxLow = 0;
        this.componentSpecs = new ScanComponentSpec[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = 0;
            if (bl2 && (i2 == 1 || i2 == 2)) {
                n3 = 1;
            }
            this.componentSpecs[i2] = new ScanComponentSpec(this, byArray[i2], n3);
        }
    }

    SOSMarkerSegment(JPEGBuffer jPEGBuffer) throws IOException {
        super(jPEGBuffer);
        int n2 = jPEGBuffer.buf[jPEGBuffer.bufPtr++];
        this.componentSpecs = new ScanComponentSpec[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            this.componentSpecs[i2] = new ScanComponentSpec(this, jPEGBuffer);
        }
        this.startSpectralSelection = jPEGBuffer.buf[jPEGBuffer.bufPtr++];
        this.endSpectralSelection = jPEGBuffer.buf[jPEGBuffer.bufPtr++];
        this.approxHigh = jPEGBuffer.buf[jPEGBuffer.bufPtr] >> 4;
        this.approxLow = jPEGBuffer.buf[jPEGBuffer.bufPtr++] & 0xF;
        jPEGBuffer.bufAvail -= this.length;
    }

    ScanComponentSpec getScanComponentSpec(byte by, int n2) {
        return new ScanComponentSpec(this, by, n2);
    }

    protected Object clone() {
        SOSMarkerSegment sOSMarkerSegment = (SOSMarkerSegment)super.clone();
        if (this.componentSpecs != null) {
            sOSMarkerSegment.componentSpecs = (ScanComponentSpec[])this.componentSpecs.clone();
            for (int i2 = 0; i2 < this.componentSpecs.length; ++i2) {
                sOSMarkerSegment.componentSpecs[i2] = (ScanComponentSpec)this.componentSpecs[i2].clone();
            }
        }
        return sOSMarkerSegment;
    }

    IIOMetadataNode getNativeNode() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("sos");
        iIOMetadataNode.setAttribute("numScanComponents", Integer.toString(this.componentSpecs.length));
        iIOMetadataNode.setAttribute("startSpectralSelection", Integer.toString(this.startSpectralSelection));
        iIOMetadataNode.setAttribute("endSpectralSelection", Integer.toString(this.endSpectralSelection));
        iIOMetadataNode.setAttribute("approxHigh", Integer.toString(this.approxHigh));
        iIOMetadataNode.setAttribute("approxLow", Integer.toString(this.approxLow));
        for (int i2 = 0; i2 < this.componentSpecs.length; ++i2) {
            iIOMetadataNode.appendChild(this.componentSpecs[i2].getNativeNode());
        }
        return iIOMetadataNode;
    }

    void write(ImageOutputStream imageOutputStream) throws IOException {
    }

    SOSMarkerSegment(Node node) throws IIOInvalidTreeException {
        super(218);
        this.startSpectralSelection = 0;
        this.endSpectralSelection = 63;
        this.approxHigh = 0;
        this.approxLow = 0;
        this.updateFromNativeNode(node, true);
    }

    void updateFromNativeNode(Node node, boolean bl2) throws IIOInvalidTreeException {
        NamedNodeMap namedNodeMap = node.getAttributes();
        int n2 = SOSMarkerSegment.getAttributeValue(node, namedNodeMap, "numScanComponents", 1, 4, true);
        int n3 = SOSMarkerSegment.getAttributeValue(node, namedNodeMap, "startSpectralSelection", 0, 63, false);
        this.startSpectralSelection = n3 != -1 ? n3 : this.startSpectralSelection;
        n3 = SOSMarkerSegment.getAttributeValue(node, namedNodeMap, "endSpectralSelection", 0, 63, false);
        this.endSpectralSelection = n3 != -1 ? n3 : this.endSpectralSelection;
        n3 = SOSMarkerSegment.getAttributeValue(node, namedNodeMap, "approxHigh", 0, 15, false);
        this.approxHigh = n3 != -1 ? n3 : this.approxHigh;
        n3 = SOSMarkerSegment.getAttributeValue(node, namedNodeMap, "approxLow", 0, 15, false);
        this.approxLow = n3 != -1 ? n3 : this.approxLow;
        NodeList nodeList = node.getChildNodes();
        if (nodeList.getLength() != n2) {
            throw new IIOInvalidTreeException("numScanComponents must match the number of children", node);
        }
        this.componentSpecs = new ScanComponentSpec[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            this.componentSpecs[i2] = new ScanComponentSpec(this, nodeList.item(i2));
        }
    }

    class ScanComponentSpec
    implements Cloneable {
        int componentSelector;
        int dcHuffTable;
        int acHuffTable;
        private final SOSMarkerSegment this$0;

        void print() {
            System.out.print("Component Selector: ");
            System.out.println(this.componentSelector);
            System.out.print("DC huffman table: ");
            System.out.println(this.dcHuffTable);
            System.out.print("AC huffman table: ");
            System.out.println(this.acHuffTable);
        }

        ScanComponentSpec(SOSMarkerSegment sOSMarkerSegment, byte by, int n2) {
            this.this$0 = sOSMarkerSegment;
            this.componentSelector = by;
            this.dcHuffTable = n2;
            this.acHuffTable = n2;
        }

        protected Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                return null;
            }
        }

        IIOMetadataNode getNativeNode() {
            IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("scanComponentSpec");
            iIOMetadataNode.setAttribute("componentSelector", Integer.toString(this.componentSelector));
            iIOMetadataNode.setAttribute("dcHuffTable", Integer.toString(this.dcHuffTable));
            iIOMetadataNode.setAttribute("acHuffTable", Integer.toString(this.acHuffTable));
            return iIOMetadataNode;
        }

        ScanComponentSpec(SOSMarkerSegment sOSMarkerSegment, JPEGBuffer jPEGBuffer) {
            this.this$0 = sOSMarkerSegment;
            this.componentSelector = jPEGBuffer.buf[jPEGBuffer.bufPtr++];
            this.dcHuffTable = jPEGBuffer.buf[jPEGBuffer.bufPtr] >> 4;
            this.acHuffTable = jPEGBuffer.buf[jPEGBuffer.bufPtr++] & 0xF;
        }

        ScanComponentSpec(SOSMarkerSegment sOSMarkerSegment, Node node) throws IIOInvalidTreeException {
            this.this$0 = sOSMarkerSegment;
            NamedNodeMap namedNodeMap = node.getAttributes();
            this.componentSelector = MarkerSegment.getAttributeValue(node, namedNodeMap, "componentSelector", 0, 255, true);
            this.dcHuffTable = MarkerSegment.getAttributeValue(node, namedNodeMap, "dcHuffTable", 0, 3, true);
            this.acHuffTable = MarkerSegment.getAttributeValue(node, namedNodeMap, "acHuffTable", 0, 3, true);
        }
    }
}

