/*
 * Decompiled with CFR 0.152.
 */
package com.sun.security.sasl.gsskerb;

import com.sun.security.sasl.preview.SaslClient;
import com.sun.security.sasl.preview.SaslException;
import com.sun.security.sasl.util.SaslImpl;
import java.io.IOException;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.MessageProp;
import org.ietf.jgss.Oid;

final class GssKerberosV5
extends SaslImpl
implements SaslClient {
    private static final String KRB5_OID_STR = "1.2.840.113554.1.2.2";
    private static Oid KRB5_OID;
    private boolean finalHandshake = false;
    private boolean mutual = false;
    private int gssQop = 0;
    private byte[] authzID;
    private GSSContext secCtx = null;
    private MessageProp msgProp;

    GssKerberosV5(String string, String string2, String string3, Map map, CallbackHandler callbackHandler) throws SaslException {
        super(map);
        String string4 = string2 + "@" + string3;
        try {
            String string5;
            GSSManager gSSManager = GSSManager.getInstance();
            GSSName gSSName = gSSManager.createName(string4, GSSName.NT_HOSTBASED_SERVICE, KRB5_OID);
            this.secCtx = gSSManager.createContext(gSSName, KRB5_OID, null, Integer.MAX_VALUE);
            if (map != null && (string5 = (String)map.get("javax.security.sasl.server.authentication")) != null) {
                this.mutual = "true".equalsIgnoreCase(string5);
            }
            this.secCtx.requestMutualAuth(this.mutual);
            this.secCtx.requestConf(true);
            this.secCtx.requestInteg(true);
        }
        catch (GSSException gSSException) {
            throw new SaslException("Failure to initialize security context", gSSException);
        }
        if (string != null && string.length() > 0) {
            try {
                this.authzID = string.getBytes("UTF8");
            }
            catch (IOException iOException) {
                throw new SaslException("Cannot encode authorization ID", iOException);
            }
        }
    }

    public boolean hasInitialResponse() {
        return true;
    }

    public synchronized void dispose() throws SaslException {
        if (this.secCtx != null) {
            try {
                this.secCtx.dispose();
            }
            catch (GSSException gSSException) {
                throw new SaslException("Problem disposing GSS context", gSSException);
            }
            this.secCtx = null;
        }
    }

    protected void finalize() throws Throwable {
        this.dispose();
    }

    public byte[] evaluateChallenge(byte[] byArray) throws SaslException {
        if (this.completed) {
            throw new SaslException("SASL authentication already complete");
        }
        if (this.finalHandshake) {
            return this.doFinalHandshake(byArray);
        }
        try {
            byte[] byArray2 = this.secCtx.initSecContext(byArray, 0, byArray.length);
            if (this.secCtx.isEstablished()) {
                this.finalHandshake = true;
                if (byArray2 == null) {
                    return new byte[0];
                }
            }
            return byArray2;
        }
        catch (GSSException gSSException) {
            throw new SaslException("GSS initiate failed", gSSException);
        }
    }

    private byte[] doFinalHandshake(byte[] byArray) throws SaslException {
        try {
            if (byArray.length == 0) {
                return new byte[0];
            }
            byte[] byArray2 = this.secCtx.unwrap(byArray, 0, byArray.length, new MessageProp(0, false));
            byte by = GssKerberosV5.findPreferredMask(byArray2[0], this.qop);
            if (by == 0) {
                throw new SaslException("No common protection layer between client and server");
            }
            if ((by & 4) != 0) {
                this.privacy = true;
                this.integrity = true;
            } else if ((by & 2) != 0) {
                this.integrity = true;
            }
            int n = GssKerberosV5.networkByteOrderToInt(byArray2, 1, 3);
            this.sendMaxBufSize = this.sendMaxBufSize == 0 ? n : Math.min(this.sendMaxBufSize, n);
            this.rawSendSize = this.secCtx.getWrapSizeLimit(this.gssQop, this.privacy, this.sendMaxBufSize);
            int n2 = 4;
            if (this.authzID != null) {
                n2 += this.authzID.length;
            }
            byte[] byArray3 = new byte[n2];
            byArray3[0] = by;
            GssKerberosV5.intToNetworkByteOrder(this.recvMaxBufSize, byArray3, 1, 3);
            if (this.authzID != null) {
                System.arraycopy(this.authzID, 0, byArray3, 4, this.authzID.length);
            }
            byArray2 = this.secCtx.wrap(byArray3, 0, byArray3.length, new MessageProp(0, false));
            this.completed = true;
            this.msgProp = new MessageProp(this.gssQop, this.privacy);
            return byArray2;
        }
        catch (GSSException gSSException) {
            throw new SaslException("Final handshake failed", gSSException);
        }
    }

    public String getMechanismName() {
        return "GSSAPI";
    }

    public byte[] unwrap(byte[] byArray, int n, int n2) throws SaslException {
        if (!this.completed) {
            throw new SaslException("Not completed");
        }
        try {
            return this.secCtx.unwrap(byArray, n, n2, this.msgProp);
        }
        catch (GSSException gSSException) {
            throw new SaslException("Problems unwrapping SASL buffer", gSSException);
        }
    }

    public byte[] wrap(byte[] byArray, int n, int n2) throws SaslException {
        if (!this.completed) {
            throw new SaslException("Not completed");
        }
        try {
            return this.secCtx.wrap(byArray, n, n2, this.msgProp);
        }
        catch (GSSException gSSException) {
            throw new SaslException("Problem performing GSS wrap", gSSException);
        }
    }

    static {
        try {
            KRB5_OID = new Oid(KRB5_OID_STR);
        }
        catch (GSSException gSSException) {
            // empty catch block
        }
    }
}

