/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.security;

import com.sun.javaws.Resources;
import com.sun.javaws.debug.Debug;
import java.security.Principal;
import java.security.cert.X509Certificate;

class DeploymentCertificateInfo {
    X509Certificate cert;

    public String toString() {
        return this.extractAliasName(this.cert);
    }

    public X509Certificate getCertificate() {
        return this.cert;
    }

    DeploymentCertificateInfo(X509Certificate x509Certificate) {
        this.cert = x509Certificate;
    }

    private static String getMessage(String string) {
        return Resources.getString(string);
    }

    private String extractAliasName(X509Certificate x509Certificate) {
        String string = DeploymentCertificateInfo.getMessage("security_dialog.unknown.subject");
        String string2 = DeploymentCertificateInfo.getMessage("security_dialog.unknown.issuer");
        try {
            Principal principal = x509Certificate.getSubjectDN();
            Principal principal2 = x509Certificate.getIssuerDN();
            String string3 = principal.getName();
            String string4 = principal2.getName();
            string = this.extractFromQuote(string3, "CN=");
            if (string == null) {
                string = this.extractFromQuote(string3, "O=");
            }
            if (string == null) {
                string = DeploymentCertificateInfo.getMessage("security_dialog.unknown.subject");
            }
            if ((string2 = this.extractFromQuote(string4, "CN=")) == null) {
                string2 = this.extractFromQuote(string4, "O=");
            }
            if (string2 == null) {
                string2 = DeploymentCertificateInfo.getMessage("security_dialog.unknown.issuer");
            }
        }
        catch (Exception exception) {
            Debug.ignoredException(exception);
        }
        return Resources.getString("security_dialog.certShowName", string, string2);
    }

    private String extractFromQuote(String string, String string2) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf(string2);
        int n2 = 0;
        if (n >= 0) {
            if ((n2 = string.charAt(n += string2.length()) == '\"' ? string.indexOf(34, ++n) : string.indexOf(44, n)) < 0) {
                return string.substring(n);
            }
            return string.substring(n, n2);
        }
        return null;
    }
}

