/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jnlp;

import com.sun.javaws.Resources;
import com.sun.javaws.debug.Debug;
import com.sun.jnlp.CheckServicePermission;
import com.sun.jnlp.SmartSecurityDialog;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.jnlp.ClipboardService;

public final class ClipboardServiceImpl
implements ClipboardService {
    private static ClipboardServiceImpl _sharedInstance = null;
    private Clipboard _sysClipboard = null;
    private SmartSecurityDialog _readDialog = new SmartSecurityDialog(Resources.getString("APIImpl.clipboard.message.read"));
    private SmartSecurityDialog _writeDialog = new SmartSecurityDialog(Resources.getString("APIImpl.clipboard.message.write"));

    private ClipboardServiceImpl() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        if (toolkit != null) {
            this._sysClipboard = toolkit.getSystemClipboard();
        }
    }

    private boolean hasClipboard() {
        return this._sysClipboard != null;
    }

    private synchronized boolean askUser(boolean bl) {
        if (!this.hasClipboard()) {
            return false;
        }
        if (CheckServicePermission.hasClipboardPermissions()) {
            return true;
        }
        return bl ? this._writeDialog.showDialog() : this._readDialog.showDialog();
    }

    public static synchronized ClipboardServiceImpl getInstance() {
        if (_sharedInstance == null) {
            _sharedInstance = new ClipboardServiceImpl();
        }
        return _sharedInstance;
    }

    public Transferable getContents() {
        if (!this.askUser(false)) {
            return null;
        }
        return (Transferable)AccessController.doPrivileged(new PrivilegedAction(this){
            private final ClipboardServiceImpl this$0;
            {
                this.this$0 = clipboardServiceImpl;
            }

            public Object run() {
                return ClipboardServiceImpl.access$000(this.this$0).getContents(null);
            }
        });
    }

    public void setContents(Transferable transferable) {
        if (!this.askUser(true)) {
            return;
        }
        AccessController.doPrivileged(new PrivilegedAction(this, transferable){
            private final Transferable val$contents;
            private final ClipboardServiceImpl this$0;

            public Object run() {
                if (this.val$contents != null) {
                    DataFlavor[] dataFlavorArray = this.val$contents.getTransferDataFlavors();
                    if (dataFlavorArray == null || dataFlavorArray[0] == null) {
                        return null;
                    }
                    try {
                        if (this.val$contents.getTransferData(dataFlavorArray[0]) == null) {
                            return null;
                        }
                    }
                    catch (IOException iOException) {
                        Debug.ignoredException(iOException);
                    }
                    catch (UnsupportedFlavorException unsupportedFlavorException) {
                        Debug.ignoredException(unsupportedFlavorException);
                    }
                }
                ClipboardServiceImpl.access$000(this.this$0).setContents(this.val$contents, null);
                return null;
            }
            {
                this.this$0 = clipboardServiceImpl;
                this.val$contents = transferable;
            }
        });
    }

    static Clipboard access$000(ClipboardServiceImpl clipboardServiceImpl) {
        return clipboardServiceImpl._sysClipboard;
    }
}

